// Code generated by "./generator ./org.freedesktop.networkmanager"; DO NOT EDIT.

// SPDX-FileCopyrightText: 2018 - 2022 UnionTech Software Technology Co., Ltd.
//
// SPDX-License-Identifier: GPL-3.0-or-later
package networkmanager

import (
	"errors"
	"fmt"
	"unsafe"

	"github.com/godbus/dbus"
	"github.com/linuxdeepin/go-dbus-factory/object_manager"
	"github.com/linuxdeepin/go-lib/dbusutil"
	"github.com/linuxdeepin/go-lib/dbusutil/proxy"
)

type ObjectManager interface {
	object_manager.ObjectManager // interface org.freedesktop.DBus.ObjectManager
	proxy.Object
}

type objectObjectManager struct {
	object_manager.InterfaceObjectManager // interface org.freedesktop.DBus.ObjectManager
	proxy.ImplObject
}

func NewObjectManager(conn *dbus.Conn) ObjectManager {
	obj := new(objectObjectManager)
	obj.ImplObject.Init_(conn, "org.freedesktop.NetworkManager", "/org/freedesktop")
	return obj
}

type AccessPoint interface {
	accessPoint // interface org.freedesktop.NetworkManager.AccessPoint
	proxy.Object
}

type objectAccessPoint struct {
	interfaceAccessPoint // interface org.freedesktop.NetworkManager.AccessPoint
	proxy.ImplObject
}

func NewAccessPoint(conn *dbus.Conn, path dbus.ObjectPath) (AccessPoint, error) {
	if !path.IsValid() {
		return nil, errors.New("path is invalid")
	}
	obj := new(objectAccessPoint)
	obj.ImplObject.Init_(conn, "org.freedesktop.NetworkManager", path)
	return obj, nil
}

type accessPoint interface {
	ConnectSignalPropertiesChanged(cb func(properties map[string]dbus.Variant)) (dbusutil.SignalHandlerId, error)
	Flags() proxy.PropUint32
	WpaFlags() proxy.PropUint32
	RsnFlags() proxy.PropUint32
	Ssid() proxy.PropByteArray
	Frequency() proxy.PropUint32
	HwAddress() proxy.PropString
	Mode() proxy.PropUint32
	MaxBitrate() proxy.PropUint32
	Strength() proxy.PropByte
	LastSeen() proxy.PropInt32
}

type interfaceAccessPoint struct{}

func (v *interfaceAccessPoint) GetObject_() *proxy.ImplObject {
	return (*proxy.ImplObject)(unsafe.Pointer(v))
}

func (*interfaceAccessPoint) GetInterfaceName_() string {
	return "org.freedesktop.NetworkManager.AccessPoint"
}

// signal PropertiesChanged

func (v *interfaceAccessPoint) ConnectSignalPropertiesChanged(cb func(properties map[string]dbus.Variant)) (dbusutil.SignalHandlerId, error) {
	if cb == nil {
		return 0, errors.New("nil callback")
	}
	obj := v.GetObject_()
	rule := fmt.Sprintf(
		"type='signal',interface='%s',member='%s',path='%s',sender='%s'",
		v.GetInterfaceName_(), "PropertiesChanged", obj.Path_(), obj.ServiceName_())

	sigRule := &dbusutil.SignalRule{
		Path: obj.Path_(),
		Name: v.GetInterfaceName_() + ".PropertiesChanged",
	}
	handlerFunc := func(sig *dbus.Signal) {
		var properties map[string]dbus.Variant
		err := dbus.Store(sig.Body, &properties)
		if err == nil {
			cb(properties)
		}
	}

	return obj.ConnectSignal_(rule, sigRule, handlerFunc)
}

// property Flags u

func (v *interfaceAccessPoint) Flags() proxy.PropUint32 {
	return &proxy.ImplPropUint32{
		Impl: v,
		Name: "Flags",
	}
}

// property WpaFlags u

func (v *interfaceAccessPoint) WpaFlags() proxy.PropUint32 {
	return &proxy.ImplPropUint32{
		Impl: v,
		Name: "WpaFlags",
	}
}

// property RsnFlags u

func (v *interfaceAccessPoint) RsnFlags() proxy.PropUint32 {
	return &proxy.ImplPropUint32{
		Impl: v,
		Name: "RsnFlags",
	}
}

// property Ssid ay

func (v *interfaceAccessPoint) Ssid() proxy.PropByteArray {
	return &proxy.ImplPropByteArray{
		Impl: v,
		Name: "Ssid",
	}
}

// property Frequency u

func (v *interfaceAccessPoint) Frequency() proxy.PropUint32 {
	return &proxy.ImplPropUint32{
		Impl: v,
		Name: "Frequency",
	}
}

// property HwAddress s

func (v *interfaceAccessPoint) HwAddress() proxy.PropString {
	return &proxy.ImplPropString{
		Impl: v,
		Name: "HwAddress",
	}
}

// property Mode u

func (v *interfaceAccessPoint) Mode() proxy.PropUint32 {
	return &proxy.ImplPropUint32{
		Impl: v,
		Name: "Mode",
	}
}

// property MaxBitrate u

func (v *interfaceAccessPoint) MaxBitrate() proxy.PropUint32 {
	return &proxy.ImplPropUint32{
		Impl: v,
		Name: "MaxBitrate",
	}
}

// property Strength y

func (v *interfaceAccessPoint) Strength() proxy.PropByte {
	return &proxy.ImplPropByte{
		Impl: v,
		Name: "Strength",
	}
}

// property LastSeen i

func (v *interfaceAccessPoint) LastSeen() proxy.PropInt32 {
	return &proxy.ImplPropInt32{
		Impl: v,
		Name: "LastSeen",
	}
}

type AgentManager interface {
	agentManager // interface org.freedesktop.NetworkManager.AgentManager
	proxy.Object
}

type objectAgentManager struct {
	interfaceAgentManager // interface org.freedesktop.NetworkManager.AgentManager
	proxy.ImplObject
}

func NewAgentManager(conn *dbus.Conn) AgentManager {
	obj := new(objectAgentManager)
	obj.ImplObject.Init_(conn, "org.freedesktop.NetworkManager", "/org/freedesktop/NetworkManager/AgentManager")
	return obj
}

type agentManager interface {
	GoRegister(flags dbus.Flags, ch chan *dbus.Call, identifier string) *dbus.Call
	Register(flags dbus.Flags, identifier string) error
	GoRegisterWithCapabilities(flags dbus.Flags, ch chan *dbus.Call, identifier string, capabilities uint32) *dbus.Call
	RegisterWithCapabilities(flags dbus.Flags, identifier string, capabilities uint32) error
	GoUnregister(flags dbus.Flags, ch chan *dbus.Call) *dbus.Call
	Unregister(flags dbus.Flags) error
}

type interfaceAgentManager struct{}

func (v *interfaceAgentManager) GetObject_() *proxy.ImplObject {
	return (*proxy.ImplObject)(unsafe.Pointer(v))
}

func (*interfaceAgentManager) GetInterfaceName_() string {
	return "org.freedesktop.NetworkManager.AgentManager"
}

// method Register

func (v *interfaceAgentManager) GoRegister(flags dbus.Flags, ch chan *dbus.Call, identifier string) *dbus.Call {
	return v.GetObject_().Go_(v.GetInterfaceName_()+".Register", flags, ch, identifier)
}

func (v *interfaceAgentManager) Register(flags dbus.Flags, identifier string) error {
	return (<-v.GoRegister(flags, make(chan *dbus.Call, 1), identifier).Done).Err
}

// method RegisterWithCapabilities

func (v *interfaceAgentManager) GoRegisterWithCapabilities(flags dbus.Flags, ch chan *dbus.Call, identifier string, capabilities uint32) *dbus.Call {
	return v.GetObject_().Go_(v.GetInterfaceName_()+".RegisterWithCapabilities", flags, ch, identifier, capabilities)
}

func (v *interfaceAgentManager) RegisterWithCapabilities(flags dbus.Flags, identifier string, capabilities uint32) error {
	return (<-v.GoRegisterWithCapabilities(flags, make(chan *dbus.Call, 1), identifier, capabilities).Done).Err
}

// method Unregister

func (v *interfaceAgentManager) GoUnregister(flags dbus.Flags, ch chan *dbus.Call) *dbus.Call {
	return v.GetObject_().Go_(v.GetInterfaceName_()+".Unregister", flags, ch)
}

func (v *interfaceAgentManager) Unregister(flags dbus.Flags) error {
	return (<-v.GoUnregister(flags, make(chan *dbus.Call, 1)).Done).Err
}

type Checkpoint interface {
	checkpoint // interface org.freedesktop.NetworkManager.Checkpoint
	proxy.Object
}

type objectCheckpoint struct {
	interfaceCheckpoint // interface org.freedesktop.NetworkManager.Checkpoint
	proxy.ImplObject
}

func NewCheckpoint(conn *dbus.Conn, path dbus.ObjectPath) (Checkpoint, error) {
	if !path.IsValid() {
		return nil, errors.New("path is invalid")
	}
	obj := new(objectCheckpoint)
	obj.ImplObject.Init_(conn, "org.freedesktop.NetworkManager", path)
	return obj, nil
}

type checkpoint interface {
	ConnectSignalPropertiesChanged(cb func(properties map[string]dbus.Variant)) (dbusutil.SignalHandlerId, error)
	Devices() proxy.PropObjectPathArray
	Created() proxy.PropInt64
	RollbackTimeout() proxy.PropUint32
}

type interfaceCheckpoint struct{}

func (v *interfaceCheckpoint) GetObject_() *proxy.ImplObject {
	return (*proxy.ImplObject)(unsafe.Pointer(v))
}

func (*interfaceCheckpoint) GetInterfaceName_() string {
	return "org.freedesktop.NetworkManager.Checkpoint"
}

// signal PropertiesChanged

func (v *interfaceCheckpoint) ConnectSignalPropertiesChanged(cb func(properties map[string]dbus.Variant)) (dbusutil.SignalHandlerId, error) {
	if cb == nil {
		return 0, errors.New("nil callback")
	}
	obj := v.GetObject_()
	rule := fmt.Sprintf(
		"type='signal',interface='%s',member='%s',path='%s',sender='%s'",
		v.GetInterfaceName_(), "PropertiesChanged", obj.Path_(), obj.ServiceName_())

	sigRule := &dbusutil.SignalRule{
		Path: obj.Path_(),
		Name: v.GetInterfaceName_() + ".PropertiesChanged",
	}
	handlerFunc := func(sig *dbus.Signal) {
		var properties map[string]dbus.Variant
		err := dbus.Store(sig.Body, &properties)
		if err == nil {
			cb(properties)
		}
	}

	return obj.ConnectSignal_(rule, sigRule, handlerFunc)
}

// property Devices ao

func (v *interfaceCheckpoint) Devices() proxy.PropObjectPathArray {
	return &proxy.ImplPropObjectPathArray{
		Impl: v,
		Name: "Devices",
	}
}

// property Created x

func (v *interfaceCheckpoint) Created() proxy.PropInt64 {
	return &proxy.ImplPropInt64{
		Impl: v,
		Name: "Created",
	}
}

// property RollbackTimeout u

func (v *interfaceCheckpoint) RollbackTimeout() proxy.PropUint32 {
	return &proxy.ImplPropUint32{
		Impl: v,
		Name: "RollbackTimeout",
	}
}

type ActiveConnection interface {
	activeConnection // interface org.freedesktop.NetworkManager.Connection.Active
	proxy.Object
}

type objectActiveConnection struct {
	interfaceActiveConnection // interface org.freedesktop.NetworkManager.Connection.Active
	proxy.ImplObject
}

func NewActiveConnection(conn *dbus.Conn, path dbus.ObjectPath) (ActiveConnection, error) {
	if !path.IsValid() {
		return nil, errors.New("path is invalid")
	}
	obj := new(objectActiveConnection)
	obj.ImplObject.Init_(conn, "org.freedesktop.NetworkManager", path)
	return obj, nil
}

type activeConnection interface {
	ConnectStateChanged(cb func(state uint32, reason uint32)) (dbusutil.SignalHandlerId, error)
	ConnectSignalPropertiesChanged(cb func(properties map[string]dbus.Variant)) (dbusutil.SignalHandlerId, error)
	Connection() proxy.PropObjectPath
	SpecificObject() proxy.PropObjectPath
	Id() proxy.PropString
	Uuid() proxy.PropString
	Type() proxy.PropString
	Devices() proxy.PropObjectPathArray
	State() proxy.PropUint32
	Default() proxy.PropBool
	Ip4Config() proxy.PropObjectPath
	Dhcp4Config() proxy.PropObjectPath
	Default6() proxy.PropBool
	Ip6Config() proxy.PropObjectPath
	Dhcp6Config() proxy.PropObjectPath
	Vpn() proxy.PropBool
	Master() proxy.PropObjectPath
}

type interfaceActiveConnection struct{}

func (v *interfaceActiveConnection) GetObject_() *proxy.ImplObject {
	return (*proxy.ImplObject)(unsafe.Pointer(v))
}

func (*interfaceActiveConnection) GetInterfaceName_() string {
	return "org.freedesktop.NetworkManager.Connection.Active"
}

// signal StateChanged

func (v *interfaceActiveConnection) ConnectStateChanged(cb func(state uint32, reason uint32)) (dbusutil.SignalHandlerId, error) {
	if cb == nil {
		return 0, errors.New("nil callback")
	}
	obj := v.GetObject_()
	rule := fmt.Sprintf(
		"type='signal',interface='%s',member='%s',path='%s',sender='%s'",
		v.GetInterfaceName_(), "StateChanged", obj.Path_(), obj.ServiceName_())

	sigRule := &dbusutil.SignalRule{
		Path: obj.Path_(),
		Name: v.GetInterfaceName_() + ".StateChanged",
	}
	handlerFunc := func(sig *dbus.Signal) {
		var state uint32
		var reason uint32
		err := dbus.Store(sig.Body, &state, &reason)
		if err == nil {
			cb(state, reason)
		}
	}

	return obj.ConnectSignal_(rule, sigRule, handlerFunc)
}

// signal PropertiesChanged

func (v *interfaceActiveConnection) ConnectSignalPropertiesChanged(cb func(properties map[string]dbus.Variant)) (dbusutil.SignalHandlerId, error) {
	if cb == nil {
		return 0, errors.New("nil callback")
	}
	obj := v.GetObject_()
	rule := fmt.Sprintf(
		"type='signal',interface='%s',member='%s',path='%s',sender='%s'",
		v.GetInterfaceName_(), "PropertiesChanged", obj.Path_(), obj.ServiceName_())

	sigRule := &dbusutil.SignalRule{
		Path: obj.Path_(),
		Name: v.GetInterfaceName_() + ".PropertiesChanged",
	}
	handlerFunc := func(sig *dbus.Signal) {
		var properties map[string]dbus.Variant
		err := dbus.Store(sig.Body, &properties)
		if err == nil {
			cb(properties)
		}
	}

	return obj.ConnectSignal_(rule, sigRule, handlerFunc)
}

// property Connection o

func (v *interfaceActiveConnection) Connection() proxy.PropObjectPath {
	return &proxy.ImplPropObjectPath{
		Impl: v,
		Name: "Connection",
	}
}

// property SpecificObject o

func (v *interfaceActiveConnection) SpecificObject() proxy.PropObjectPath {
	return &proxy.ImplPropObjectPath{
		Impl: v,
		Name: "SpecificObject",
	}
}

// property Id s

func (v *interfaceActiveConnection) Id() proxy.PropString {
	return &proxy.ImplPropString{
		Impl: v,
		Name: "Id",
	}
}

// property Uuid s

func (v *interfaceActiveConnection) Uuid() proxy.PropString {
	return &proxy.ImplPropString{
		Impl: v,
		Name: "Uuid",
	}
}

// property Type s

func (v *interfaceActiveConnection) Type() proxy.PropString {
	return &proxy.ImplPropString{
		Impl: v,
		Name: "Type",
	}
}

// property Devices ao

func (v *interfaceActiveConnection) Devices() proxy.PropObjectPathArray {
	return &proxy.ImplPropObjectPathArray{
		Impl: v,
		Name: "Devices",
	}
}

// property State u

func (v *interfaceActiveConnection) State() proxy.PropUint32 {
	return &proxy.ImplPropUint32{
		Impl: v,
		Name: "State",
	}
}

// property Default b

func (v *interfaceActiveConnection) Default() proxy.PropBool {
	return &proxy.ImplPropBool{
		Impl: v,
		Name: "Default",
	}
}

// property Ip4Config o

func (v *interfaceActiveConnection) Ip4Config() proxy.PropObjectPath {
	return &proxy.ImplPropObjectPath{
		Impl: v,
		Name: "Ip4Config",
	}
}

// property Dhcp4Config o

func (v *interfaceActiveConnection) Dhcp4Config() proxy.PropObjectPath {
	return &proxy.ImplPropObjectPath{
		Impl: v,
		Name: "Dhcp4Config",
	}
}

// property Default6 b

func (v *interfaceActiveConnection) Default6() proxy.PropBool {
	return &proxy.ImplPropBool{
		Impl: v,
		Name: "Default6",
	}
}

// property Ip6Config o

func (v *interfaceActiveConnection) Ip6Config() proxy.PropObjectPath {
	return &proxy.ImplPropObjectPath{
		Impl: v,
		Name: "Ip6Config",
	}
}

// property Dhcp6Config o

func (v *interfaceActiveConnection) Dhcp6Config() proxy.PropObjectPath {
	return &proxy.ImplPropObjectPath{
		Impl: v,
		Name: "Dhcp6Config",
	}
}

// property Vpn b

func (v *interfaceActiveConnection) Vpn() proxy.PropBool {
	return &proxy.ImplPropBool{
		Impl: v,
		Name: "Vpn",
	}
}

// property Master o

func (v *interfaceActiveConnection) Master() proxy.PropObjectPath {
	return &proxy.ImplPropObjectPath{
		Impl: v,
		Name: "Master",
	}
}

type Dhcp4Config interface {
	dhcp4Config // interface org.freedesktop.NetworkManager.DHCP4Config
	proxy.Object
}

type objectDhcp4Config struct {
	interfaceDhcp4Config // interface org.freedesktop.NetworkManager.DHCP4Config
	proxy.ImplObject
}

func NewDhcp4Config(conn *dbus.Conn, path dbus.ObjectPath) (Dhcp4Config, error) {
	if !path.IsValid() {
		return nil, errors.New("path is invalid")
	}
	obj := new(objectDhcp4Config)
	obj.ImplObject.Init_(conn, "org.freedesktop.NetworkManager", path)
	return obj, nil
}

type dhcp4Config interface {
	ConnectSignalPropertiesChanged(cb func(properties map[string]dbus.Variant)) (dbusutil.SignalHandlerId, error)
	Options() PropMapStringVariant
}

type interfaceDhcp4Config struct{}

func (v *interfaceDhcp4Config) GetObject_() *proxy.ImplObject {
	return (*proxy.ImplObject)(unsafe.Pointer(v))
}

func (*interfaceDhcp4Config) GetInterfaceName_() string {
	return "org.freedesktop.NetworkManager.DHCP4Config"
}

// signal PropertiesChanged

func (v *interfaceDhcp4Config) ConnectSignalPropertiesChanged(cb func(properties map[string]dbus.Variant)) (dbusutil.SignalHandlerId, error) {
	if cb == nil {
		return 0, errors.New("nil callback")
	}
	obj := v.GetObject_()
	rule := fmt.Sprintf(
		"type='signal',interface='%s',member='%s',path='%s',sender='%s'",
		v.GetInterfaceName_(), "PropertiesChanged", obj.Path_(), obj.ServiceName_())

	sigRule := &dbusutil.SignalRule{
		Path: obj.Path_(),
		Name: v.GetInterfaceName_() + ".PropertiesChanged",
	}
	handlerFunc := func(sig *dbus.Signal) {
		var properties map[string]dbus.Variant
		err := dbus.Store(sig.Body, &properties)
		if err == nil {
			cb(properties)
		}
	}

	return obj.ConnectSignal_(rule, sigRule, handlerFunc)
}

// property Options a{sv}

func (v *interfaceDhcp4Config) Options() PropMapStringVariant {
	return &implPropMapStringVariant{
		Impl: v,
		Name: "Options",
	}
}

type Dhcp6Config interface {
	dhcp6Config // interface org.freedesktop.NetworkManager.DHCP6Config
	proxy.Object
}

type objectDhcp6Config struct {
	interfaceDhcp6Config // interface org.freedesktop.NetworkManager.DHCP6Config
	proxy.ImplObject
}

func NewDhcp6Config(conn *dbus.Conn, path dbus.ObjectPath) (Dhcp6Config, error) {
	if !path.IsValid() {
		return nil, errors.New("path is invalid")
	}
	obj := new(objectDhcp6Config)
	obj.ImplObject.Init_(conn, "org.freedesktop.NetworkManager", path)
	return obj, nil
}

type dhcp6Config interface {
	ConnectSignalPropertiesChanged(cb func(properties map[string]dbus.Variant)) (dbusutil.SignalHandlerId, error)
	Options() PropMapStringVariant
}

type interfaceDhcp6Config struct{}

func (v *interfaceDhcp6Config) GetObject_() *proxy.ImplObject {
	return (*proxy.ImplObject)(unsafe.Pointer(v))
}

func (*interfaceDhcp6Config) GetInterfaceName_() string {
	return "org.freedesktop.NetworkManager.DHCP6Config"
}

// signal PropertiesChanged

func (v *interfaceDhcp6Config) ConnectSignalPropertiesChanged(cb func(properties map[string]dbus.Variant)) (dbusutil.SignalHandlerId, error) {
	if cb == nil {
		return 0, errors.New("nil callback")
	}
	obj := v.GetObject_()
	rule := fmt.Sprintf(
		"type='signal',interface='%s',member='%s',path='%s',sender='%s'",
		v.GetInterfaceName_(), "PropertiesChanged", obj.Path_(), obj.ServiceName_())

	sigRule := &dbusutil.SignalRule{
		Path: obj.Path_(),
		Name: v.GetInterfaceName_() + ".PropertiesChanged",
	}
	handlerFunc := func(sig *dbus.Signal) {
		var properties map[string]dbus.Variant
		err := dbus.Store(sig.Body, &properties)
		if err == nil {
			cb(properties)
		}
	}

	return obj.ConnectSignal_(rule, sigRule, handlerFunc)
}

// property Options a{sv}

func (v *interfaceDhcp6Config) Options() PropMapStringVariant {
	return &implPropMapStringVariant{
		Impl: v,
		Name: "Options",
	}
}

type DnsManager interface {
	dnsManager // interface org.freedesktop.NetworkManager.DnsManager
	proxy.Object
}

type objectDnsManager struct {
	interfaceDnsManager // interface org.freedesktop.NetworkManager.DnsManager
	proxy.ImplObject
}

func NewDnsManager(conn *dbus.Conn) DnsManager {
	obj := new(objectDnsManager)
	obj.ImplObject.Init_(conn, "org.freedesktop.NetworkManager", "/org/freedesktop/NetworkManager/DnsManager")
	return obj
}

type dnsManager interface {
	Mode() proxy.PropString
	RcManager() proxy.PropString
	Configuration() PropMapSVSlice
}

type interfaceDnsManager struct{}

func (v *interfaceDnsManager) GetObject_() *proxy.ImplObject {
	return (*proxy.ImplObject)(unsafe.Pointer(v))
}

func (*interfaceDnsManager) GetInterfaceName_() string {
	return "org.freedesktop.NetworkManager.DnsManager"
}

// property Mode s

func (v *interfaceDnsManager) Mode() proxy.PropString {
	return &proxy.ImplPropString{
		Impl: v,
		Name: "Mode",
	}
}

// property RcManager s

func (v *interfaceDnsManager) RcManager() proxy.PropString {
	return &proxy.ImplPropString{
		Impl: v,
		Name: "RcManager",
	}
}

// property Configuration aa{sv}

func (v *interfaceDnsManager) Configuration() PropMapSVSlice {
	return &implPropMapSVSlice{
		Impl: v,
		Name: "Configuration",
	}
}

type IP4Config interface {
	ip4Config // interface org.freedesktop.NetworkManager.IP4Config
	proxy.Object
}

type objectIP4Config struct {
	interfaceIp4Config // interface org.freedesktop.NetworkManager.IP4Config
	proxy.ImplObject
}

func NewIP4Config(conn *dbus.Conn, path dbus.ObjectPath) (IP4Config, error) {
	if !path.IsValid() {
		return nil, errors.New("path is invalid")
	}
	obj := new(objectIP4Config)
	obj.ImplObject.Init_(conn, "org.freedesktop.NetworkManager", path)
	return obj, nil
}

type ip4Config interface {
	ConnectSignalPropertiesChanged(cb func(properties map[string]dbus.Variant)) (dbusutil.SignalHandlerId, error)
	Addresses() PropUint32SliceSlice
	AddressData() PropMapSVSlice
	Gateway() proxy.PropString
	Routes() PropUint32SliceSlice
	RouteData() PropMapSVSlice
	Nameservers() proxy.PropUint32Array
	Domains() proxy.PropStringArray
	Searches() proxy.PropStringArray
	DnsOptions() proxy.PropStringArray
	DnsPriority() proxy.PropInt32
	WinsServers() proxy.PropUint32Array
}

type interfaceIp4Config struct{}

func (v *interfaceIp4Config) GetObject_() *proxy.ImplObject {
	return (*proxy.ImplObject)(unsafe.Pointer(v))
}

func (*interfaceIp4Config) GetInterfaceName_() string {
	return "org.freedesktop.NetworkManager.IP4Config"
}

// signal PropertiesChanged

func (v *interfaceIp4Config) ConnectSignalPropertiesChanged(cb func(properties map[string]dbus.Variant)) (dbusutil.SignalHandlerId, error) {
	if cb == nil {
		return 0, errors.New("nil callback")
	}
	obj := v.GetObject_()
	rule := fmt.Sprintf(
		"type='signal',interface='%s',member='%s',path='%s',sender='%s'",
		v.GetInterfaceName_(), "PropertiesChanged", obj.Path_(), obj.ServiceName_())

	sigRule := &dbusutil.SignalRule{
		Path: obj.Path_(),
		Name: v.GetInterfaceName_() + ".PropertiesChanged",
	}
	handlerFunc := func(sig *dbus.Signal) {
		var properties map[string]dbus.Variant
		err := dbus.Store(sig.Body, &properties)
		if err == nil {
			cb(properties)
		}
	}

	return obj.ConnectSignal_(rule, sigRule, handlerFunc)
}

// property Addresses aau

func (v *interfaceIp4Config) Addresses() PropUint32SliceSlice {
	return &implPropUint32SliceSlice{
		Impl: v,
		Name: "Addresses",
	}
}

// property AddressData aa{sv}

func (v *interfaceIp4Config) AddressData() PropMapSVSlice {
	return &implPropMapSVSlice{
		Impl: v,
		Name: "AddressData",
	}
}

// property Gateway s

func (v *interfaceIp4Config) Gateway() proxy.PropString {
	return &proxy.ImplPropString{
		Impl: v,
		Name: "Gateway",
	}
}

// property Routes aau

func (v *interfaceIp4Config) Routes() PropUint32SliceSlice {
	return &implPropUint32SliceSlice{
		Impl: v,
		Name: "Routes",
	}
}

// property RouteData aa{sv}

func (v *interfaceIp4Config) RouteData() PropMapSVSlice {
	return &implPropMapSVSlice{
		Impl: v,
		Name: "RouteData",
	}
}

// property Nameservers au

func (v *interfaceIp4Config) Nameservers() proxy.PropUint32Array {
	return &proxy.ImplPropUint32Array{
		Impl: v,
		Name: "Nameservers",
	}
}

// property Domains as

func (v *interfaceIp4Config) Domains() proxy.PropStringArray {
	return &proxy.ImplPropStringArray{
		Impl: v,
		Name: "Domains",
	}
}

// property Searches as

func (v *interfaceIp4Config) Searches() proxy.PropStringArray {
	return &proxy.ImplPropStringArray{
		Impl: v,
		Name: "Searches",
	}
}

// property DnsOptions as

func (v *interfaceIp4Config) DnsOptions() proxy.PropStringArray {
	return &proxy.ImplPropStringArray{
		Impl: v,
		Name: "DnsOptions",
	}
}

// property DnsPriority i

func (v *interfaceIp4Config) DnsPriority() proxy.PropInt32 {
	return &proxy.ImplPropInt32{
		Impl: v,
		Name: "DnsPriority",
	}
}

// property WinsServers au

func (v *interfaceIp4Config) WinsServers() proxy.PropUint32Array {
	return &proxy.ImplPropUint32Array{
		Impl: v,
		Name: "WinsServers",
	}
}

type IP6Config interface {
	ip6Config // interface org.freedesktop.NetworkManager.IP6Config
	proxy.Object
}

type objectIP6Config struct {
	interfaceIp6Config // interface org.freedesktop.NetworkManager.IP6Config
	proxy.ImplObject
}

func NewIP6Config(conn *dbus.Conn, path dbus.ObjectPath) (IP6Config, error) {
	if !path.IsValid() {
		return nil, errors.New("path is invalid")
	}
	obj := new(objectIP6Config)
	obj.ImplObject.Init_(conn, "org.freedesktop.NetworkManager", path)
	return obj, nil
}

type ip6Config interface {
	ConnectSignalPropertiesChanged(cb func(properties map[string]dbus.Variant)) (dbusutil.SignalHandlerId, error)
	Addresses() PropIP6ConfigAddresses
	AddressData() PropMapSVSlice
	Gateway() proxy.PropString
	Routes() PropIP6ConfigRoutes
	RouteData() PropMapSVSlice
	Nameservers() PropIP6NameServers
	Domains() proxy.PropStringArray
	Searches() proxy.PropStringArray
	DnsOptions() proxy.PropStringArray
	DnsPriority() proxy.PropInt32
}

type interfaceIp6Config struct{}

func (v *interfaceIp6Config) GetObject_() *proxy.ImplObject {
	return (*proxy.ImplObject)(unsafe.Pointer(v))
}

func (*interfaceIp6Config) GetInterfaceName_() string {
	return "org.freedesktop.NetworkManager.IP6Config"
}

// signal PropertiesChanged

func (v *interfaceIp6Config) ConnectSignalPropertiesChanged(cb func(properties map[string]dbus.Variant)) (dbusutil.SignalHandlerId, error) {
	if cb == nil {
		return 0, errors.New("nil callback")
	}
	obj := v.GetObject_()
	rule := fmt.Sprintf(
		"type='signal',interface='%s',member='%s',path='%s',sender='%s'",
		v.GetInterfaceName_(), "PropertiesChanged", obj.Path_(), obj.ServiceName_())

	sigRule := &dbusutil.SignalRule{
		Path: obj.Path_(),
		Name: v.GetInterfaceName_() + ".PropertiesChanged",
	}
	handlerFunc := func(sig *dbus.Signal) {
		var properties map[string]dbus.Variant
		err := dbus.Store(sig.Body, &properties)
		if err == nil {
			cb(properties)
		}
	}

	return obj.ConnectSignal_(rule, sigRule, handlerFunc)
}

type PropIP6ConfigAddresses interface {
	Get(flags dbus.Flags) (value []IP6Address, err error)
	Set(flags dbus.Flags, value []IP6Address) error
	ConnectChanged(cb func(hasValue bool, value []IP6Address)) error
}

type implPropIP6ConfigAddresses struct {
	Impl proxy.Implementer
	Name string
}

func (p implPropIP6ConfigAddresses) Get(flags dbus.Flags) (value []IP6Address, err error) {
	err = p.Impl.GetObject_().GetProperty_(flags, p.Impl.GetInterfaceName_(),
		p.Name, &value)
	return
}

func (p implPropIP6ConfigAddresses) Set(flags dbus.Flags, value []IP6Address) error {
	return p.Impl.GetObject_().SetProperty_(flags, p.Impl.GetInterfaceName_(), p.Name, value)
}

func (p implPropIP6ConfigAddresses) ConnectChanged(cb func(hasValue bool, value []IP6Address)) error {
	if cb == nil {
		return errors.New("nil callback")
	}
	cb0 := func(hasValue bool, value interface{}) {
		if hasValue {
			var v []IP6Address
			err := dbus.Store([]interface{}{value}, &v)
			if err != nil {
				return
			}
			cb(true, v)
		} else {
			cb(false, nil)
		}
	}
	return p.Impl.GetObject_().ConnectPropertyChanged_(p.Impl.GetInterfaceName_(),
		p.Name, cb0)
}

// property Addresses a(ayuay)

func (v *interfaceIp6Config) Addresses() PropIP6ConfigAddresses {
	return &implPropIP6ConfigAddresses{
		Impl: v,
		Name: "Addresses",
	}
}

// property AddressData aa{sv}

func (v *interfaceIp6Config) AddressData() PropMapSVSlice {
	return &implPropMapSVSlice{
		Impl: v,
		Name: "AddressData",
	}
}

// property Gateway s

func (v *interfaceIp6Config) Gateway() proxy.PropString {
	return &proxy.ImplPropString{
		Impl: v,
		Name: "Gateway",
	}
}

type PropIP6ConfigRoutes interface {
	Get(flags dbus.Flags) (value []IP6Route, err error)
	Set(flags dbus.Flags, value []IP6Route) error
	ConnectChanged(cb func(hasValue bool, value []IP6Route)) error
}

type implPropIP6ConfigRoutes struct {
	Impl proxy.Implementer
	Name string
}

func (p implPropIP6ConfigRoutes) Get(flags dbus.Flags) (value []IP6Route, err error) {
	err = p.Impl.GetObject_().GetProperty_(flags, p.Impl.GetInterfaceName_(),
		p.Name, &value)
	return
}

func (p implPropIP6ConfigRoutes) Set(flags dbus.Flags, value []IP6Route) error {
	return p.Impl.GetObject_().SetProperty_(flags, p.Impl.GetInterfaceName_(), p.Name, value)
}

func (p implPropIP6ConfigRoutes) ConnectChanged(cb func(hasValue bool, value []IP6Route)) error {
	if cb == nil {
		return errors.New("nil callback")
	}
	cb0 := func(hasValue bool, value interface{}) {
		if hasValue {
			var v []IP6Route
			err := dbus.Store([]interface{}{value}, &v)
			if err != nil {
				return
			}
			cb(true, v)
		} else {
			cb(false, nil)
		}
	}
	return p.Impl.GetObject_().ConnectPropertyChanged_(p.Impl.GetInterfaceName_(),
		p.Name, cb0)
}

// property Routes a(ayuayu)

func (v *interfaceIp6Config) Routes() PropIP6ConfigRoutes {
	return &implPropIP6ConfigRoutes{
		Impl: v,
		Name: "Routes",
	}
}

// property RouteData aa{sv}

func (v *interfaceIp6Config) RouteData() PropMapSVSlice {
	return &implPropMapSVSlice{
		Impl: v,
		Name: "RouteData",
	}
}

type PropIP6NameServers interface {
	Get(flags dbus.Flags) (value [][]byte, err error)
	Set(flags dbus.Flags, value [][]byte) error
	ConnectChanged(cb func(hasValue bool, value [][]byte)) error
}

type implPropIP6NameServers struct {
	Impl proxy.Implementer
	Name string
}

func (p implPropIP6NameServers) Get(flags dbus.Flags) (value [][]byte, err error) {
	err = p.Impl.GetObject_().GetProperty_(flags, p.Impl.GetInterfaceName_(),
		p.Name, &value)
	return
}

func (p implPropIP6NameServers) Set(flags dbus.Flags, value [][]byte) error {
	return p.Impl.GetObject_().SetProperty_(flags, p.Impl.GetInterfaceName_(), p.Name, value)
}

func (p implPropIP6NameServers) ConnectChanged(cb func(hasValue bool, value [][]byte)) error {
	if cb == nil {
		return errors.New("nil callback")
	}
	cb0 := func(hasValue bool, value interface{}) {
		if hasValue {
			var v [][]byte
			err := dbus.Store([]interface{}{value}, &v)
			if err != nil {
				return
			}
			cb(true, v)
		} else {
			cb(false, nil)
		}
	}
	return p.Impl.GetObject_().ConnectPropertyChanged_(p.Impl.GetInterfaceName_(),
		p.Name, cb0)
}

// property Nameservers aay

func (v *interfaceIp6Config) Nameservers() PropIP6NameServers {
	return &implPropIP6NameServers{
		Impl: v,
		Name: "Nameservers",
	}
}

// property Domains as

func (v *interfaceIp6Config) Domains() proxy.PropStringArray {
	return &proxy.ImplPropStringArray{
		Impl: v,
		Name: "Domains",
	}
}

// property Searches as

func (v *interfaceIp6Config) Searches() proxy.PropStringArray {
	return &proxy.ImplPropStringArray{
		Impl: v,
		Name: "Searches",
	}
}

// property DnsOptions as

func (v *interfaceIp6Config) DnsOptions() proxy.PropStringArray {
	return &proxy.ImplPropStringArray{
		Impl: v,
		Name: "DnsOptions",
	}
}

// property DnsPriority i

func (v *interfaceIp6Config) DnsPriority() proxy.PropInt32 {
	return &proxy.ImplPropInt32{
		Impl: v,
		Name: "DnsPriority",
	}
}

type Manager interface {
	manager // interface org.freedesktop.NetworkManager
	proxy.Object
}

type objectManager struct {
	interfaceManager // interface org.freedesktop.NetworkManager
	proxy.ImplObject
}

func NewManager(conn *dbus.Conn) Manager {
	obj := new(objectManager)
	obj.ImplObject.Init_(conn, "org.freedesktop.NetworkManager", "/org/freedesktop/NetworkManager")
	return obj
}

type manager interface {
	GoReload(flags dbus.Flags, ch chan *dbus.Call, flags0 uint32) *dbus.Call
	Reload(flags dbus.Flags, flags0 uint32) error
	GoGetDevices(flags dbus.Flags, ch chan *dbus.Call) *dbus.Call
	GetDevices(flags dbus.Flags) ([]dbus.ObjectPath, error)
	GoGetAllDevices(flags dbus.Flags, ch chan *dbus.Call) *dbus.Call
	GetAllDevices(flags dbus.Flags) ([]dbus.ObjectPath, error)
	GoGetDeviceByIpIface(flags dbus.Flags, ch chan *dbus.Call, iface string) *dbus.Call
	GetDeviceByIpIface(flags dbus.Flags, iface string) (dbus.ObjectPath, error)
	GoActivateConnection(flags dbus.Flags, ch chan *dbus.Call, connection dbus.ObjectPath, device dbus.ObjectPath, specific_object dbus.ObjectPath) *dbus.Call
	ActivateConnection(flags dbus.Flags, connection dbus.ObjectPath, device dbus.ObjectPath, specific_object dbus.ObjectPath) (dbus.ObjectPath, error)
	GoAddAndActivateConnection(flags dbus.Flags, ch chan *dbus.Call, connection map[string]map[string]dbus.Variant, device dbus.ObjectPath, specific_object dbus.ObjectPath) *dbus.Call
	AddAndActivateConnection(flags dbus.Flags, connection map[string]map[string]dbus.Variant, device dbus.ObjectPath, specific_object dbus.ObjectPath) (dbus.ObjectPath, dbus.ObjectPath, error)
	GoDeactivateConnection(flags dbus.Flags, ch chan *dbus.Call, active_connection dbus.ObjectPath) *dbus.Call
	DeactivateConnection(flags dbus.Flags, active_connection dbus.ObjectPath) error
	GoSleep(flags dbus.Flags, ch chan *dbus.Call, sleep bool) *dbus.Call
	Sleep(flags dbus.Flags, sleep bool) error
	GoEnable(flags dbus.Flags, ch chan *dbus.Call, enable bool) *dbus.Call
	Enable(flags dbus.Flags, enable bool) error
	GoGetPermissions(flags dbus.Flags, ch chan *dbus.Call) *dbus.Call
	GetPermissions(flags dbus.Flags) (map[string]string, error)
	GoSetLogging(flags dbus.Flags, ch chan *dbus.Call, level string, domains string) *dbus.Call
	SetLogging(flags dbus.Flags, level string, domains string) error
	GoGetLogging(flags dbus.Flags, ch chan *dbus.Call) *dbus.Call
	GetLogging(flags dbus.Flags) (string, string, error)
	GoCheckConnectivity(flags dbus.Flags, ch chan *dbus.Call) *dbus.Call
	CheckConnectivity(flags dbus.Flags) (uint32, error)
	GoState(flags dbus.Flags, ch chan *dbus.Call) *dbus.Call
	State(flags dbus.Flags) (uint32, error)
	GoCheckpointCreate(flags dbus.Flags, ch chan *dbus.Call, devices []dbus.ObjectPath, rollback_timeout uint32, flags0 uint32) *dbus.Call
	CheckpointCreate(flags dbus.Flags, devices []dbus.ObjectPath, rollback_timeout uint32, flags0 uint32) (dbus.ObjectPath, error)
	GoCheckpointDestroy(flags dbus.Flags, ch chan *dbus.Call, checkpoint dbus.ObjectPath) *dbus.Call
	CheckpointDestroy(flags dbus.Flags, checkpoint dbus.ObjectPath) error
	GoCheckpointRollback(flags dbus.Flags, ch chan *dbus.Call, checkpoint dbus.ObjectPath) *dbus.Call
	CheckpointRollback(flags dbus.Flags, checkpoint dbus.ObjectPath) (map[string]uint32, error)
	ConnectCheckPermissions(cb func()) (dbusutil.SignalHandlerId, error)
	ConnectStateChanged(cb func(state uint32)) (dbusutil.SignalHandlerId, error)
	ConnectSignalPropertiesChanged(cb func(properties map[string]dbus.Variant)) (dbusutil.SignalHandlerId, error)
	ConnectDeviceAdded(cb func(device_path dbus.ObjectPath)) (dbusutil.SignalHandlerId, error)
	ConnectDeviceRemoved(cb func(device_path dbus.ObjectPath)) (dbusutil.SignalHandlerId, error)
	Devices() proxy.PropObjectPathArray
	AllDevices() proxy.PropObjectPathArray
	NetworkingEnabled() proxy.PropBool
	WirelessEnabled() proxy.PropBool
	WirelessHardwareEnabled() proxy.PropBool
	WwanEnabled() proxy.PropBool
	WwanHardwareEnabled() proxy.PropBool
	WimaxEnabled() proxy.PropBool
	WimaxHardwareEnabled() proxy.PropBool
	ActiveConnections() proxy.PropObjectPathArray
	PrimaryConnection() proxy.PropObjectPath
	PrimaryConnectionType() proxy.PropString
	Metered() proxy.PropUint32
	ActivatingConnection() proxy.PropObjectPath
	Startup() proxy.PropBool
	Version() proxy.PropString
	Capabilities() proxy.PropUint32Array
	PropState() proxy.PropUint32
	Connectivity() proxy.PropUint32
	GlobalDnsConfiguration() PropMapStringVariant
}

type interfaceManager struct{}

func (v *interfaceManager) GetObject_() *proxy.ImplObject {
	return (*proxy.ImplObject)(unsafe.Pointer(v))
}

func (*interfaceManager) GetInterfaceName_() string {
	return "org.freedesktop.NetworkManager"
}

// method Reload

func (v *interfaceManager) GoReload(flags dbus.Flags, ch chan *dbus.Call, flags0 uint32) *dbus.Call {
	return v.GetObject_().Go_(v.GetInterfaceName_()+".Reload", flags, ch, flags0)
}

func (v *interfaceManager) Reload(flags dbus.Flags, flags0 uint32) error {
	return (<-v.GoReload(flags, make(chan *dbus.Call, 1), flags0).Done).Err
}

// method GetDevices

func (v *interfaceManager) GoGetDevices(flags dbus.Flags, ch chan *dbus.Call) *dbus.Call {
	return v.GetObject_().Go_(v.GetInterfaceName_()+".GetDevices", flags, ch)
}

func (*interfaceManager) StoreGetDevices(call *dbus.Call) (devices []dbus.ObjectPath, err error) {
	err = call.Store(&devices)
	return
}

func (v *interfaceManager) GetDevices(flags dbus.Flags) ([]dbus.ObjectPath, error) {
	return v.StoreGetDevices(
		<-v.GoGetDevices(flags, make(chan *dbus.Call, 1)).Done)
}

// method GetAllDevices

func (v *interfaceManager) GoGetAllDevices(flags dbus.Flags, ch chan *dbus.Call) *dbus.Call {
	return v.GetObject_().Go_(v.GetInterfaceName_()+".GetAllDevices", flags, ch)
}

func (*interfaceManager) StoreGetAllDevices(call *dbus.Call) (devices []dbus.ObjectPath, err error) {
	err = call.Store(&devices)
	return
}

func (v *interfaceManager) GetAllDevices(flags dbus.Flags) ([]dbus.ObjectPath, error) {
	return v.StoreGetAllDevices(
		<-v.GoGetAllDevices(flags, make(chan *dbus.Call, 1)).Done)
}

// method GetDeviceByIpIface

func (v *interfaceManager) GoGetDeviceByIpIface(flags dbus.Flags, ch chan *dbus.Call, iface string) *dbus.Call {
	return v.GetObject_().Go_(v.GetInterfaceName_()+".GetDeviceByIpIface", flags, ch, iface)
}

func (*interfaceManager) StoreGetDeviceByIpIface(call *dbus.Call) (device dbus.ObjectPath, err error) {
	err = call.Store(&device)
	return
}

func (v *interfaceManager) GetDeviceByIpIface(flags dbus.Flags, iface string) (dbus.ObjectPath, error) {
	return v.StoreGetDeviceByIpIface(
		<-v.GoGetDeviceByIpIface(flags, make(chan *dbus.Call, 1), iface).Done)
}

// method ActivateConnection

func (v *interfaceManager) GoActivateConnection(flags dbus.Flags, ch chan *dbus.Call, connection dbus.ObjectPath, device dbus.ObjectPath, specific_object dbus.ObjectPath) *dbus.Call {
	return v.GetObject_().Go_(v.GetInterfaceName_()+".ActivateConnection", flags, ch, connection, device, specific_object)
}

func (*interfaceManager) StoreActivateConnection(call *dbus.Call) (active_connection dbus.ObjectPath, err error) {
	err = call.Store(&active_connection)
	return
}

func (v *interfaceManager) ActivateConnection(flags dbus.Flags, connection dbus.ObjectPath, device dbus.ObjectPath, specific_object dbus.ObjectPath) (dbus.ObjectPath, error) {
	return v.StoreActivateConnection(
		<-v.GoActivateConnection(flags, make(chan *dbus.Call, 1), connection, device, specific_object).Done)
}

// method AddAndActivateConnection

func (v *interfaceManager) GoAddAndActivateConnection(flags dbus.Flags, ch chan *dbus.Call, connection map[string]map[string]dbus.Variant, device dbus.ObjectPath, specific_object dbus.ObjectPath) *dbus.Call {
	return v.GetObject_().Go_(v.GetInterfaceName_()+".AddAndActivateConnection", flags, ch, connection, device, specific_object)
}

func (*interfaceManager) StoreAddAndActivateConnection(call *dbus.Call) (path dbus.ObjectPath, active_connection dbus.ObjectPath, err error) {
	err = call.Store(&path, &active_connection)
	return
}

func (v *interfaceManager) AddAndActivateConnection(flags dbus.Flags, connection map[string]map[string]dbus.Variant, device dbus.ObjectPath, specific_object dbus.ObjectPath) (dbus.ObjectPath, dbus.ObjectPath, error) {
	return v.StoreAddAndActivateConnection(
		<-v.GoAddAndActivateConnection(flags, make(chan *dbus.Call, 1), connection, device, specific_object).Done)
}

// method DeactivateConnection

func (v *interfaceManager) GoDeactivateConnection(flags dbus.Flags, ch chan *dbus.Call, active_connection dbus.ObjectPath) *dbus.Call {
	return v.GetObject_().Go_(v.GetInterfaceName_()+".DeactivateConnection", flags, ch, active_connection)
}

func (v *interfaceManager) DeactivateConnection(flags dbus.Flags, active_connection dbus.ObjectPath) error {
	return (<-v.GoDeactivateConnection(flags, make(chan *dbus.Call, 1), active_connection).Done).Err
}

// method Sleep

func (v *interfaceManager) GoSleep(flags dbus.Flags, ch chan *dbus.Call, sleep bool) *dbus.Call {
	return v.GetObject_().Go_(v.GetInterfaceName_()+".Sleep", flags, ch, sleep)
}

func (v *interfaceManager) Sleep(flags dbus.Flags, sleep bool) error {
	return (<-v.GoSleep(flags, make(chan *dbus.Call, 1), sleep).Done).Err
}

// method Enable

func (v *interfaceManager) GoEnable(flags dbus.Flags, ch chan *dbus.Call, enable bool) *dbus.Call {
	return v.GetObject_().Go_(v.GetInterfaceName_()+".Enable", flags, ch, enable)
}

func (v *interfaceManager) Enable(flags dbus.Flags, enable bool) error {
	return (<-v.GoEnable(flags, make(chan *dbus.Call, 1), enable).Done).Err
}

// method GetPermissions

func (v *interfaceManager) GoGetPermissions(flags dbus.Flags, ch chan *dbus.Call) *dbus.Call {
	return v.GetObject_().Go_(v.GetInterfaceName_()+".GetPermissions", flags, ch)
}

func (*interfaceManager) StoreGetPermissions(call *dbus.Call) (permissions map[string]string, err error) {
	err = call.Store(&permissions)
	return
}

func (v *interfaceManager) GetPermissions(flags dbus.Flags) (map[string]string, error) {
	return v.StoreGetPermissions(
		<-v.GoGetPermissions(flags, make(chan *dbus.Call, 1)).Done)
}

// method SetLogging

func (v *interfaceManager) GoSetLogging(flags dbus.Flags, ch chan *dbus.Call, level string, domains string) *dbus.Call {
	return v.GetObject_().Go_(v.GetInterfaceName_()+".SetLogging", flags, ch, level, domains)
}

func (v *interfaceManager) SetLogging(flags dbus.Flags, level string, domains string) error {
	return (<-v.GoSetLogging(flags, make(chan *dbus.Call, 1), level, domains).Done).Err
}

// method GetLogging

func (v *interfaceManager) GoGetLogging(flags dbus.Flags, ch chan *dbus.Call) *dbus.Call {
	return v.GetObject_().Go_(v.GetInterfaceName_()+".GetLogging", flags, ch)
}

func (*interfaceManager) StoreGetLogging(call *dbus.Call) (level string, domains string, err error) {
	err = call.Store(&level, &domains)
	return
}

func (v *interfaceManager) GetLogging(flags dbus.Flags) (string, string, error) {
	return v.StoreGetLogging(
		<-v.GoGetLogging(flags, make(chan *dbus.Call, 1)).Done)
}

// method CheckConnectivity

func (v *interfaceManager) GoCheckConnectivity(flags dbus.Flags, ch chan *dbus.Call) *dbus.Call {
	return v.GetObject_().Go_(v.GetInterfaceName_()+".CheckConnectivity", flags, ch)
}

func (*interfaceManager) StoreCheckConnectivity(call *dbus.Call) (connectivity uint32, err error) {
	err = call.Store(&connectivity)
	return
}

func (v *interfaceManager) CheckConnectivity(flags dbus.Flags) (uint32, error) {
	return v.StoreCheckConnectivity(
		<-v.GoCheckConnectivity(flags, make(chan *dbus.Call, 1)).Done)
}

// method state

func (v *interfaceManager) GoState(flags dbus.Flags, ch chan *dbus.Call) *dbus.Call {
	return v.GetObject_().Go_(v.GetInterfaceName_()+".state", flags, ch)
}

func (*interfaceManager) StoreState(call *dbus.Call) (state uint32, err error) {
	err = call.Store(&state)
	return
}

func (v *interfaceManager) State(flags dbus.Flags) (uint32, error) {
	return v.StoreState(
		<-v.GoState(flags, make(chan *dbus.Call, 1)).Done)
}

// method CheckpointCreate

func (v *interfaceManager) GoCheckpointCreate(flags dbus.Flags, ch chan *dbus.Call, devices []dbus.ObjectPath, rollback_timeout uint32, flags0 uint32) *dbus.Call {
	return v.GetObject_().Go_(v.GetInterfaceName_()+".CheckpointCreate", flags, ch, devices, rollback_timeout, flags0)
}

func (*interfaceManager) StoreCheckpointCreate(call *dbus.Call) (checkpoint dbus.ObjectPath, err error) {
	err = call.Store(&checkpoint)
	return
}

func (v *interfaceManager) CheckpointCreate(flags dbus.Flags, devices []dbus.ObjectPath, rollback_timeout uint32, flags0 uint32) (dbus.ObjectPath, error) {
	return v.StoreCheckpointCreate(
		<-v.GoCheckpointCreate(flags, make(chan *dbus.Call, 1), devices, rollback_timeout, flags0).Done)
}

// method CheckpointDestroy

func (v *interfaceManager) GoCheckpointDestroy(flags dbus.Flags, ch chan *dbus.Call, checkpoint dbus.ObjectPath) *dbus.Call {
	return v.GetObject_().Go_(v.GetInterfaceName_()+".CheckpointDestroy", flags, ch, checkpoint)
}

func (v *interfaceManager) CheckpointDestroy(flags dbus.Flags, checkpoint dbus.ObjectPath) error {
	return (<-v.GoCheckpointDestroy(flags, make(chan *dbus.Call, 1), checkpoint).Done).Err
}

// method CheckpointRollback

func (v *interfaceManager) GoCheckpointRollback(flags dbus.Flags, ch chan *dbus.Call, checkpoint dbus.ObjectPath) *dbus.Call {
	return v.GetObject_().Go_(v.GetInterfaceName_()+".CheckpointRollback", flags, ch, checkpoint)
}

func (*interfaceManager) StoreCheckpointRollback(call *dbus.Call) (result map[string]uint32, err error) {
	err = call.Store(&result)
	return
}

func (v *interfaceManager) CheckpointRollback(flags dbus.Flags, checkpoint dbus.ObjectPath) (map[string]uint32, error) {
	return v.StoreCheckpointRollback(
		<-v.GoCheckpointRollback(flags, make(chan *dbus.Call, 1), checkpoint).Done)
}

// signal CheckPermissions

func (v *interfaceManager) ConnectCheckPermissions(cb func()) (dbusutil.SignalHandlerId, error) {
	if cb == nil {
		return 0, errors.New("nil callback")
	}
	obj := v.GetObject_()
	rule := fmt.Sprintf(
		"type='signal',interface='%s',member='%s',path='%s',sender='%s'",
		v.GetInterfaceName_(), "CheckPermissions", obj.Path_(), obj.ServiceName_())

	sigRule := &dbusutil.SignalRule{
		Path: obj.Path_(),
		Name: v.GetInterfaceName_() + ".CheckPermissions",
	}
	handlerFunc := func(sig *dbus.Signal) {
		cb()
	}

	return obj.ConnectSignal_(rule, sigRule, handlerFunc)
}

// signal StateChanged

func (v *interfaceManager) ConnectStateChanged(cb func(state uint32)) (dbusutil.SignalHandlerId, error) {
	if cb == nil {
		return 0, errors.New("nil callback")
	}
	obj := v.GetObject_()
	rule := fmt.Sprintf(
		"type='signal',interface='%s',member='%s',path='%s',sender='%s'",
		v.GetInterfaceName_(), "StateChanged", obj.Path_(), obj.ServiceName_())

	sigRule := &dbusutil.SignalRule{
		Path: obj.Path_(),
		Name: v.GetInterfaceName_() + ".StateChanged",
	}
	handlerFunc := func(sig *dbus.Signal) {
		var state uint32
		err := dbus.Store(sig.Body, &state)
		if err == nil {
			cb(state)
		}
	}

	return obj.ConnectSignal_(rule, sigRule, handlerFunc)
}

// signal PropertiesChanged

func (v *interfaceManager) ConnectSignalPropertiesChanged(cb func(properties map[string]dbus.Variant)) (dbusutil.SignalHandlerId, error) {
	if cb == nil {
		return 0, errors.New("nil callback")
	}
	obj := v.GetObject_()
	rule := fmt.Sprintf(
		"type='signal',interface='%s',member='%s',path='%s',sender='%s'",
		v.GetInterfaceName_(), "PropertiesChanged", obj.Path_(), obj.ServiceName_())

	sigRule := &dbusutil.SignalRule{
		Path: obj.Path_(),
		Name: v.GetInterfaceName_() + ".PropertiesChanged",
	}
	handlerFunc := func(sig *dbus.Signal) {
		var properties map[string]dbus.Variant
		err := dbus.Store(sig.Body, &properties)
		if err == nil {
			cb(properties)
		}
	}

	return obj.ConnectSignal_(rule, sigRule, handlerFunc)
}

// signal DeviceAdded

func (v *interfaceManager) ConnectDeviceAdded(cb func(device_path dbus.ObjectPath)) (dbusutil.SignalHandlerId, error) {
	if cb == nil {
		return 0, errors.New("nil callback")
	}
	obj := v.GetObject_()
	rule := fmt.Sprintf(
		"type='signal',interface='%s',member='%s',path='%s',sender='%s'",
		v.GetInterfaceName_(), "DeviceAdded", obj.Path_(), obj.ServiceName_())

	sigRule := &dbusutil.SignalRule{
		Path: obj.Path_(),
		Name: v.GetInterfaceName_() + ".DeviceAdded",
	}
	handlerFunc := func(sig *dbus.Signal) {
		var device_path dbus.ObjectPath
		err := dbus.Store(sig.Body, &device_path)
		if err == nil {
			cb(device_path)
		}
	}

	return obj.ConnectSignal_(rule, sigRule, handlerFunc)
}

// signal DeviceRemoved

func (v *interfaceManager) ConnectDeviceRemoved(cb func(device_path dbus.ObjectPath)) (dbusutil.SignalHandlerId, error) {
	if cb == nil {
		return 0, errors.New("nil callback")
	}
	obj := v.GetObject_()
	rule := fmt.Sprintf(
		"type='signal',interface='%s',member='%s',path='%s',sender='%s'",
		v.GetInterfaceName_(), "DeviceRemoved", obj.Path_(), obj.ServiceName_())

	sigRule := &dbusutil.SignalRule{
		Path: obj.Path_(),
		Name: v.GetInterfaceName_() + ".DeviceRemoved",
	}
	handlerFunc := func(sig *dbus.Signal) {
		var device_path dbus.ObjectPath
		err := dbus.Store(sig.Body, &device_path)
		if err == nil {
			cb(device_path)
		}
	}

	return obj.ConnectSignal_(rule, sigRule, handlerFunc)
}

// property Devices ao

func (v *interfaceManager) Devices() proxy.PropObjectPathArray {
	return &proxy.ImplPropObjectPathArray{
		Impl: v,
		Name: "Devices",
	}
}

// property AllDevices ao

func (v *interfaceManager) AllDevices() proxy.PropObjectPathArray {
	return &proxy.ImplPropObjectPathArray{
		Impl: v,
		Name: "AllDevices",
	}
}

// property NetworkingEnabled b

func (v *interfaceManager) NetworkingEnabled() proxy.PropBool {
	return &proxy.ImplPropBool{
		Impl: v,
		Name: "NetworkingEnabled",
	}
}

// property WirelessEnabled b

func (v *interfaceManager) WirelessEnabled() proxy.PropBool {
	return &proxy.ImplPropBool{
		Impl: v,
		Name: "WirelessEnabled",
	}
}

// property WirelessHardwareEnabled b

func (v *interfaceManager) WirelessHardwareEnabled() proxy.PropBool {
	return &proxy.ImplPropBool{
		Impl: v,
		Name: "WirelessHardwareEnabled",
	}
}

// property WwanEnabled b

func (v *interfaceManager) WwanEnabled() proxy.PropBool {
	return &proxy.ImplPropBool{
		Impl: v,
		Name: "WwanEnabled",
	}
}

// property WwanHardwareEnabled b

func (v *interfaceManager) WwanHardwareEnabled() proxy.PropBool {
	return &proxy.ImplPropBool{
		Impl: v,
		Name: "WwanHardwareEnabled",
	}
}

// property WimaxEnabled b

func (v *interfaceManager) WimaxEnabled() proxy.PropBool {
	return &proxy.ImplPropBool{
		Impl: v,
		Name: "WimaxEnabled",
	}
}

// property WimaxHardwareEnabled b

func (v *interfaceManager) WimaxHardwareEnabled() proxy.PropBool {
	return &proxy.ImplPropBool{
		Impl: v,
		Name: "WimaxHardwareEnabled",
	}
}

// property ActiveConnections ao

func (v *interfaceManager) ActiveConnections() proxy.PropObjectPathArray {
	return &proxy.ImplPropObjectPathArray{
		Impl: v,
		Name: "ActiveConnections",
	}
}

// property PrimaryConnection o

func (v *interfaceManager) PrimaryConnection() proxy.PropObjectPath {
	return &proxy.ImplPropObjectPath{
		Impl: v,
		Name: "PrimaryConnection",
	}
}

// property PrimaryConnectionType s

func (v *interfaceManager) PrimaryConnectionType() proxy.PropString {
	return &proxy.ImplPropString{
		Impl: v,
		Name: "PrimaryConnectionType",
	}
}

// property Metered u

func (v *interfaceManager) Metered() proxy.PropUint32 {
	return &proxy.ImplPropUint32{
		Impl: v,
		Name: "Metered",
	}
}

// property ActivatingConnection o

func (v *interfaceManager) ActivatingConnection() proxy.PropObjectPath {
	return &proxy.ImplPropObjectPath{
		Impl: v,
		Name: "ActivatingConnection",
	}
}

// property Startup b

func (v *interfaceManager) Startup() proxy.PropBool {
	return &proxy.ImplPropBool{
		Impl: v,
		Name: "Startup",
	}
}

// property Version s

func (v *interfaceManager) Version() proxy.PropString {
	return &proxy.ImplPropString{
		Impl: v,
		Name: "Version",
	}
}

// property Capabilities au

func (v *interfaceManager) Capabilities() proxy.PropUint32Array {
	return &proxy.ImplPropUint32Array{
		Impl: v,
		Name: "Capabilities",
	}
}

// property State u

func (v *interfaceManager) PropState() proxy.PropUint32 {
	return &proxy.ImplPropUint32{
		Impl: v,
		Name: "State",
	}
}

// property Connectivity u

func (v *interfaceManager) Connectivity() proxy.PropUint32 {
	return &proxy.ImplPropUint32{
		Impl: v,
		Name: "Connectivity",
	}
}

// property GlobalDnsConfiguration a{sv}

func (v *interfaceManager) GlobalDnsConfiguration() PropMapStringVariant {
	return &implPropMapStringVariant{
		Impl: v,
		Name: "GlobalDnsConfiguration",
	}
}

type PPP interface {
	ppp // interface org.freedesktop.NetworkManager.PPP
	proxy.Object
}

type objectPPP struct {
	interfacePpp // interface org.freedesktop.NetworkManager.PPP
	proxy.ImplObject
}

func NewPPP(conn *dbus.Conn, path dbus.ObjectPath) (PPP, error) {
	if !path.IsValid() {
		return nil, errors.New("path is invalid")
	}
	obj := new(objectPPP)
	obj.ImplObject.Init_(conn, "org.freedesktop.NetworkManager", path)
	return obj, nil
}

type ppp interface {
	GoNeedSecrets(flags dbus.Flags, ch chan *dbus.Call) *dbus.Call
	NeedSecrets(flags dbus.Flags) (string, string, error)
	GoSetIp4Config(flags dbus.Flags, ch chan *dbus.Call, config map[string]dbus.Variant) *dbus.Call
	SetIp4Config(flags dbus.Flags, config map[string]dbus.Variant) error
	GoSetIp6Config(flags dbus.Flags, ch chan *dbus.Call, config map[string]dbus.Variant) *dbus.Call
	SetIp6Config(flags dbus.Flags, config map[string]dbus.Variant) error
	GoSetState(flags dbus.Flags, ch chan *dbus.Call, state uint32) *dbus.Call
	SetState(flags dbus.Flags, state uint32) error
}

type interfacePpp struct{}

func (v *interfacePpp) GetObject_() *proxy.ImplObject {
	return (*proxy.ImplObject)(unsafe.Pointer(v))
}

func (*interfacePpp) GetInterfaceName_() string {
	return "org.freedesktop.NetworkManager.PPP"
}

// method NeedSecrets

func (v *interfacePpp) GoNeedSecrets(flags dbus.Flags, ch chan *dbus.Call) *dbus.Call {
	return v.GetObject_().Go_(v.GetInterfaceName_()+".NeedSecrets", flags, ch)
}

func (*interfacePpp) StoreNeedSecrets(call *dbus.Call) (username string, password string, err error) {
	err = call.Store(&username, &password)
	return
}

func (v *interfacePpp) NeedSecrets(flags dbus.Flags) (string, string, error) {
	return v.StoreNeedSecrets(
		<-v.GoNeedSecrets(flags, make(chan *dbus.Call, 1)).Done)
}

// method SetIp4Config

func (v *interfacePpp) GoSetIp4Config(flags dbus.Flags, ch chan *dbus.Call, config map[string]dbus.Variant) *dbus.Call {
	return v.GetObject_().Go_(v.GetInterfaceName_()+".SetIp4Config", flags, ch, config)
}

func (v *interfacePpp) SetIp4Config(flags dbus.Flags, config map[string]dbus.Variant) error {
	return (<-v.GoSetIp4Config(flags, make(chan *dbus.Call, 1), config).Done).Err
}

// method SetIp6Config

func (v *interfacePpp) GoSetIp6Config(flags dbus.Flags, ch chan *dbus.Call, config map[string]dbus.Variant) *dbus.Call {
	return v.GetObject_().Go_(v.GetInterfaceName_()+".SetIp6Config", flags, ch, config)
}

func (v *interfacePpp) SetIp6Config(flags dbus.Flags, config map[string]dbus.Variant) error {
	return (<-v.GoSetIp6Config(flags, make(chan *dbus.Call, 1), config).Done).Err
}

// method SetState

func (v *interfacePpp) GoSetState(flags dbus.Flags, ch chan *dbus.Call, state uint32) *dbus.Call {
	return v.GetObject_().Go_(v.GetInterfaceName_()+".SetState", flags, ch, state)
}

func (v *interfacePpp) SetState(flags dbus.Flags, state uint32) error {
	return (<-v.GoSetState(flags, make(chan *dbus.Call, 1), state).Done).Err
}

type SecretAgent interface {
	secretAgent // interface org.freedesktop.NetworkManager.SecretAgent
	proxy.Object
}

type objectSecretAgent struct {
	interfaceSecretAgent // interface org.freedesktop.NetworkManager.SecretAgent
	proxy.ImplObject
}

func NewSecretAgent(conn *dbus.Conn, path dbus.ObjectPath) (SecretAgent, error) {
	if !path.IsValid() {
		return nil, errors.New("path is invalid")
	}
	obj := new(objectSecretAgent)
	obj.ImplObject.Init_(conn, "org.freedesktop.NetworkManager", path)
	return obj, nil
}

type secretAgent interface {
	GoGetSecrets(flags dbus.Flags, ch chan *dbus.Call, connection map[string]map[string]dbus.Variant, connection_path dbus.ObjectPath, setting_name string, hints []string, flags0 uint32) *dbus.Call
	GetSecrets(flags dbus.Flags, connection map[string]map[string]dbus.Variant, connection_path dbus.ObjectPath, setting_name string, hints []string, flags0 uint32) (map[string]map[string]dbus.Variant, error)
	GoCancelGetSecrets(flags dbus.Flags, ch chan *dbus.Call, connection_path dbus.ObjectPath, setting_name string) *dbus.Call
	CancelGetSecrets(flags dbus.Flags, connection_path dbus.ObjectPath, setting_name string) error
	GoSaveSecrets(flags dbus.Flags, ch chan *dbus.Call, connection map[string]map[string]dbus.Variant, connection_path dbus.ObjectPath) *dbus.Call
	SaveSecrets(flags dbus.Flags, connection map[string]map[string]dbus.Variant, connection_path dbus.ObjectPath) error
	GoDeleteSecrets(flags dbus.Flags, ch chan *dbus.Call, connection map[string]map[string]dbus.Variant, connection_path dbus.ObjectPath) *dbus.Call
	DeleteSecrets(flags dbus.Flags, connection map[string]map[string]dbus.Variant, connection_path dbus.ObjectPath) error
}

type interfaceSecretAgent struct{}

func (v *interfaceSecretAgent) GetObject_() *proxy.ImplObject {
	return (*proxy.ImplObject)(unsafe.Pointer(v))
}

func (*interfaceSecretAgent) GetInterfaceName_() string {
	return "org.freedesktop.NetworkManager.SecretAgent"
}

// method GetSecrets

func (v *interfaceSecretAgent) GoGetSecrets(flags dbus.Flags, ch chan *dbus.Call, connection map[string]map[string]dbus.Variant, connection_path dbus.ObjectPath, setting_name string, hints []string, flags0 uint32) *dbus.Call {
	return v.GetObject_().Go_(v.GetInterfaceName_()+".GetSecrets", flags, ch, connection, connection_path, setting_name, hints, flags0)
}

func (*interfaceSecretAgent) StoreGetSecrets(call *dbus.Call) (secrets map[string]map[string]dbus.Variant, err error) {
	err = call.Store(&secrets)
	return
}

func (v *interfaceSecretAgent) GetSecrets(flags dbus.Flags, connection map[string]map[string]dbus.Variant, connection_path dbus.ObjectPath, setting_name string, hints []string, flags0 uint32) (map[string]map[string]dbus.Variant, error) {
	return v.StoreGetSecrets(
		<-v.GoGetSecrets(flags, make(chan *dbus.Call, 1), connection, connection_path, setting_name, hints, flags0).Done)
}

// method CancelGetSecrets

func (v *interfaceSecretAgent) GoCancelGetSecrets(flags dbus.Flags, ch chan *dbus.Call, connection_path dbus.ObjectPath, setting_name string) *dbus.Call {
	return v.GetObject_().Go_(v.GetInterfaceName_()+".CancelGetSecrets", flags, ch, connection_path, setting_name)
}

func (v *interfaceSecretAgent) CancelGetSecrets(flags dbus.Flags, connection_path dbus.ObjectPath, setting_name string) error {
	return (<-v.GoCancelGetSecrets(flags, make(chan *dbus.Call, 1), connection_path, setting_name).Done).Err
}

// method SaveSecrets

func (v *interfaceSecretAgent) GoSaveSecrets(flags dbus.Flags, ch chan *dbus.Call, connection map[string]map[string]dbus.Variant, connection_path dbus.ObjectPath) *dbus.Call {
	return v.GetObject_().Go_(v.GetInterfaceName_()+".SaveSecrets", flags, ch, connection, connection_path)
}

func (v *interfaceSecretAgent) SaveSecrets(flags dbus.Flags, connection map[string]map[string]dbus.Variant, connection_path dbus.ObjectPath) error {
	return (<-v.GoSaveSecrets(flags, make(chan *dbus.Call, 1), connection, connection_path).Done).Err
}

// method DeleteSecrets

func (v *interfaceSecretAgent) GoDeleteSecrets(flags dbus.Flags, ch chan *dbus.Call, connection map[string]map[string]dbus.Variant, connection_path dbus.ObjectPath) *dbus.Call {
	return v.GetObject_().Go_(v.GetInterfaceName_()+".DeleteSecrets", flags, ch, connection, connection_path)
}

func (v *interfaceSecretAgent) DeleteSecrets(flags dbus.Flags, connection map[string]map[string]dbus.Variant, connection_path dbus.ObjectPath) error {
	return (<-v.GoDeleteSecrets(flags, make(chan *dbus.Call, 1), connection, connection_path).Done).Err
}

type ConnectionSettings interface {
	connectionSettings // interface org.freedesktop.NetworkManager.Settings.Connection
	proxy.Object
}

type objectConnectionSettings struct {
	interfaceConnectionSettings // interface org.freedesktop.NetworkManager.Settings.Connection
	proxy.ImplObject
}

func NewConnectionSettings(conn *dbus.Conn, path dbus.ObjectPath) (ConnectionSettings, error) {
	if !path.IsValid() {
		return nil, errors.New("path is invalid")
	}
	obj := new(objectConnectionSettings)
	obj.ImplObject.Init_(conn, "org.freedesktop.NetworkManager", path)
	return obj, nil
}

type connectionSettings interface {
	GoUpdate(flags dbus.Flags, ch chan *dbus.Call, properties map[string]map[string]dbus.Variant) *dbus.Call
	Update(flags dbus.Flags, properties map[string]map[string]dbus.Variant) error
	GoUpdateUnsaved(flags dbus.Flags, ch chan *dbus.Call, properties map[string]map[string]dbus.Variant) *dbus.Call
	UpdateUnsaved(flags dbus.Flags, properties map[string]map[string]dbus.Variant) error
	GoDelete(flags dbus.Flags, ch chan *dbus.Call) *dbus.Call
	Delete(flags dbus.Flags) error
	GoGetSettings(flags dbus.Flags, ch chan *dbus.Call) *dbus.Call
	GetSettings(flags dbus.Flags) (map[string]map[string]dbus.Variant, error)
	GoGetSecrets(flags dbus.Flags, ch chan *dbus.Call, setting_name string) *dbus.Call
	GetSecrets(flags dbus.Flags, setting_name string) (map[string]map[string]dbus.Variant, error)
	GoClearSecrets(flags dbus.Flags, ch chan *dbus.Call) *dbus.Call
	ClearSecrets(flags dbus.Flags) error
	GoSave(flags dbus.Flags, ch chan *dbus.Call) *dbus.Call
	Save(flags dbus.Flags) error
	ConnectUpdated(cb func()) (dbusutil.SignalHandlerId, error)
	ConnectRemoved(cb func()) (dbusutil.SignalHandlerId, error)
	ConnectSignalPropertiesChanged(cb func(properties map[string]dbus.Variant)) (dbusutil.SignalHandlerId, error)
	Unsaved() proxy.PropBool
}

type interfaceConnectionSettings struct{}

func (v *interfaceConnectionSettings) GetObject_() *proxy.ImplObject {
	return (*proxy.ImplObject)(unsafe.Pointer(v))
}

func (*interfaceConnectionSettings) GetInterfaceName_() string {
	return "org.freedesktop.NetworkManager.Settings.Connection"
}

// method Update

func (v *interfaceConnectionSettings) GoUpdate(flags dbus.Flags, ch chan *dbus.Call, properties map[string]map[string]dbus.Variant) *dbus.Call {
	return v.GetObject_().Go_(v.GetInterfaceName_()+".Update", flags, ch, properties)
}

func (v *interfaceConnectionSettings) Update(flags dbus.Flags, properties map[string]map[string]dbus.Variant) error {
	return (<-v.GoUpdate(flags, make(chan *dbus.Call, 1), properties).Done).Err
}

// method UpdateUnsaved

func (v *interfaceConnectionSettings) GoUpdateUnsaved(flags dbus.Flags, ch chan *dbus.Call, properties map[string]map[string]dbus.Variant) *dbus.Call {
	return v.GetObject_().Go_(v.GetInterfaceName_()+".UpdateUnsaved", flags, ch, properties)
}

func (v *interfaceConnectionSettings) UpdateUnsaved(flags dbus.Flags, properties map[string]map[string]dbus.Variant) error {
	return (<-v.GoUpdateUnsaved(flags, make(chan *dbus.Call, 1), properties).Done).Err
}

// method Delete

func (v *interfaceConnectionSettings) GoDelete(flags dbus.Flags, ch chan *dbus.Call) *dbus.Call {
	return v.GetObject_().Go_(v.GetInterfaceName_()+".Delete", flags, ch)
}

func (v *interfaceConnectionSettings) Delete(flags dbus.Flags) error {
	return (<-v.GoDelete(flags, make(chan *dbus.Call, 1)).Done).Err
}

// method GetSettings

func (v *interfaceConnectionSettings) GoGetSettings(flags dbus.Flags, ch chan *dbus.Call) *dbus.Call {
	return v.GetObject_().Go_(v.GetInterfaceName_()+".GetSettings", flags, ch)
}

func (*interfaceConnectionSettings) StoreGetSettings(call *dbus.Call) (settings map[string]map[string]dbus.Variant, err error) {
	err = call.Store(&settings)
	return
}

func (v *interfaceConnectionSettings) GetSettings(flags dbus.Flags) (map[string]map[string]dbus.Variant, error) {
	return v.StoreGetSettings(
		<-v.GoGetSettings(flags, make(chan *dbus.Call, 1)).Done)
}

// method GetSecrets

func (v *interfaceConnectionSettings) GoGetSecrets(flags dbus.Flags, ch chan *dbus.Call, setting_name string) *dbus.Call {
	return v.GetObject_().Go_(v.GetInterfaceName_()+".GetSecrets", flags, ch, setting_name)
}

func (*interfaceConnectionSettings) StoreGetSecrets(call *dbus.Call) (secrets map[string]map[string]dbus.Variant, err error) {
	err = call.Store(&secrets)
	return
}

func (v *interfaceConnectionSettings) GetSecrets(flags dbus.Flags, setting_name string) (map[string]map[string]dbus.Variant, error) {
	return v.StoreGetSecrets(
		<-v.GoGetSecrets(flags, make(chan *dbus.Call, 1), setting_name).Done)
}

// method ClearSecrets

func (v *interfaceConnectionSettings) GoClearSecrets(flags dbus.Flags, ch chan *dbus.Call) *dbus.Call {
	return v.GetObject_().Go_(v.GetInterfaceName_()+".ClearSecrets", flags, ch)
}

func (v *interfaceConnectionSettings) ClearSecrets(flags dbus.Flags) error {
	return (<-v.GoClearSecrets(flags, make(chan *dbus.Call, 1)).Done).Err
}

// method Save

func (v *interfaceConnectionSettings) GoSave(flags dbus.Flags, ch chan *dbus.Call) *dbus.Call {
	return v.GetObject_().Go_(v.GetInterfaceName_()+".Save", flags, ch)
}

func (v *interfaceConnectionSettings) Save(flags dbus.Flags) error {
	return (<-v.GoSave(flags, make(chan *dbus.Call, 1)).Done).Err
}

// signal Updated

func (v *interfaceConnectionSettings) ConnectUpdated(cb func()) (dbusutil.SignalHandlerId, error) {
	if cb == nil {
		return 0, errors.New("nil callback")
	}
	obj := v.GetObject_()
	rule := fmt.Sprintf(
		"type='signal',interface='%s',member='%s',path='%s',sender='%s'",
		v.GetInterfaceName_(), "Updated", obj.Path_(), obj.ServiceName_())

	sigRule := &dbusutil.SignalRule{
		Path: obj.Path_(),
		Name: v.GetInterfaceName_() + ".Updated",
	}
	handlerFunc := func(sig *dbus.Signal) {
		cb()
	}

	return obj.ConnectSignal_(rule, sigRule, handlerFunc)
}

// signal Removed

func (v *interfaceConnectionSettings) ConnectRemoved(cb func()) (dbusutil.SignalHandlerId, error) {
	if cb == nil {
		return 0, errors.New("nil callback")
	}
	obj := v.GetObject_()
	rule := fmt.Sprintf(
		"type='signal',interface='%s',member='%s',path='%s',sender='%s'",
		v.GetInterfaceName_(), "Removed", obj.Path_(), obj.ServiceName_())

	sigRule := &dbusutil.SignalRule{
		Path: obj.Path_(),
		Name: v.GetInterfaceName_() + ".Removed",
	}
	handlerFunc := func(sig *dbus.Signal) {
		cb()
	}

	return obj.ConnectSignal_(rule, sigRule, handlerFunc)
}

// signal PropertiesChanged

func (v *interfaceConnectionSettings) ConnectSignalPropertiesChanged(cb func(properties map[string]dbus.Variant)) (dbusutil.SignalHandlerId, error) {
	if cb == nil {
		return 0, errors.New("nil callback")
	}
	obj := v.GetObject_()
	rule := fmt.Sprintf(
		"type='signal',interface='%s',member='%s',path='%s',sender='%s'",
		v.GetInterfaceName_(), "PropertiesChanged", obj.Path_(), obj.ServiceName_())

	sigRule := &dbusutil.SignalRule{
		Path: obj.Path_(),
		Name: v.GetInterfaceName_() + ".PropertiesChanged",
	}
	handlerFunc := func(sig *dbus.Signal) {
		var properties map[string]dbus.Variant
		err := dbus.Store(sig.Body, &properties)
		if err == nil {
			cb(properties)
		}
	}

	return obj.ConnectSignal_(rule, sigRule, handlerFunc)
}

// property Unsaved b

func (v *interfaceConnectionSettings) Unsaved() proxy.PropBool {
	return &proxy.ImplPropBool{
		Impl: v,
		Name: "Unsaved",
	}
}

type Settings interface {
	settings // interface org.freedesktop.NetworkManager.Settings
	proxy.Object
}

type objectSettings struct {
	interfaceSettings // interface org.freedesktop.NetworkManager.Settings
	proxy.ImplObject
}

func NewSettings(conn *dbus.Conn) Settings {
	obj := new(objectSettings)
	obj.ImplObject.Init_(conn, "org.freedesktop.NetworkManager", "/org/freedesktop/NetworkManager/Settings")
	return obj
}

type settings interface {
	GoListConnections(flags dbus.Flags, ch chan *dbus.Call) *dbus.Call
	ListConnections(flags dbus.Flags) ([]dbus.ObjectPath, error)
	GoGetConnectionByUuid(flags dbus.Flags, ch chan *dbus.Call, uuid string) *dbus.Call
	GetConnectionByUuid(flags dbus.Flags, uuid string) (dbus.ObjectPath, error)
	GoAddConnection(flags dbus.Flags, ch chan *dbus.Call, connection map[string]map[string]dbus.Variant) *dbus.Call
	AddConnection(flags dbus.Flags, connection map[string]map[string]dbus.Variant) (dbus.ObjectPath, error)
	GoAddConnectionUnsaved(flags dbus.Flags, ch chan *dbus.Call, connection map[string]map[string]dbus.Variant) *dbus.Call
	AddConnectionUnsaved(flags dbus.Flags, connection map[string]map[string]dbus.Variant) (dbus.ObjectPath, error)
	GoLoadConnections(flags dbus.Flags, ch chan *dbus.Call, filenames []string) *dbus.Call
	LoadConnections(flags dbus.Flags, filenames []string) (bool, []string, error)
	GoReloadConnections(flags dbus.Flags, ch chan *dbus.Call) *dbus.Call
	ReloadConnections(flags dbus.Flags) (bool, error)
	GoSaveHostname(flags dbus.Flags, ch chan *dbus.Call, hostname string) *dbus.Call
	SaveHostname(flags dbus.Flags, hostname string) error
	ConnectSignalPropertiesChanged(cb func(properties map[string]dbus.Variant)) (dbusutil.SignalHandlerId, error)
	ConnectNewConnection(cb func(connection dbus.ObjectPath)) (dbusutil.SignalHandlerId, error)
	ConnectConnectionRemoved(cb func(connection dbus.ObjectPath)) (dbusutil.SignalHandlerId, error)
	Connections() proxy.PropObjectPathArray
	Hostname() proxy.PropString
	CanModify() proxy.PropBool
}

type interfaceSettings struct{}

func (v *interfaceSettings) GetObject_() *proxy.ImplObject {
	return (*proxy.ImplObject)(unsafe.Pointer(v))
}

func (*interfaceSettings) GetInterfaceName_() string {
	return "org.freedesktop.NetworkManager.Settings"
}

// method ListConnections

func (v *interfaceSettings) GoListConnections(flags dbus.Flags, ch chan *dbus.Call) *dbus.Call {
	return v.GetObject_().Go_(v.GetInterfaceName_()+".ListConnections", flags, ch)
}

func (*interfaceSettings) StoreListConnections(call *dbus.Call) (connections []dbus.ObjectPath, err error) {
	err = call.Store(&connections)
	return
}

func (v *interfaceSettings) ListConnections(flags dbus.Flags) ([]dbus.ObjectPath, error) {
	return v.StoreListConnections(
		<-v.GoListConnections(flags, make(chan *dbus.Call, 1)).Done)
}

// method GetConnectionByUuid

func (v *interfaceSettings) GoGetConnectionByUuid(flags dbus.Flags, ch chan *dbus.Call, uuid string) *dbus.Call {
	return v.GetObject_().Go_(v.GetInterfaceName_()+".GetConnectionByUuid", flags, ch, uuid)
}

func (*interfaceSettings) StoreGetConnectionByUuid(call *dbus.Call) (connection dbus.ObjectPath, err error) {
	err = call.Store(&connection)
	return
}

func (v *interfaceSettings) GetConnectionByUuid(flags dbus.Flags, uuid string) (dbus.ObjectPath, error) {
	return v.StoreGetConnectionByUuid(
		<-v.GoGetConnectionByUuid(flags, make(chan *dbus.Call, 1), uuid).Done)
}

// method AddConnection

func (v *interfaceSettings) GoAddConnection(flags dbus.Flags, ch chan *dbus.Call, connection map[string]map[string]dbus.Variant) *dbus.Call {
	return v.GetObject_().Go_(v.GetInterfaceName_()+".AddConnection", flags, ch, connection)
}

func (*interfaceSettings) StoreAddConnection(call *dbus.Call) (path dbus.ObjectPath, err error) {
	err = call.Store(&path)
	return
}

func (v *interfaceSettings) AddConnection(flags dbus.Flags, connection map[string]map[string]dbus.Variant) (dbus.ObjectPath, error) {
	return v.StoreAddConnection(
		<-v.GoAddConnection(flags, make(chan *dbus.Call, 1), connection).Done)
}

// method AddConnectionUnsaved

func (v *interfaceSettings) GoAddConnectionUnsaved(flags dbus.Flags, ch chan *dbus.Call, connection map[string]map[string]dbus.Variant) *dbus.Call {
	return v.GetObject_().Go_(v.GetInterfaceName_()+".AddConnectionUnsaved", flags, ch, connection)
}

func (*interfaceSettings) StoreAddConnectionUnsaved(call *dbus.Call) (path dbus.ObjectPath, err error) {
	err = call.Store(&path)
	return
}

func (v *interfaceSettings) AddConnectionUnsaved(flags dbus.Flags, connection map[string]map[string]dbus.Variant) (dbus.ObjectPath, error) {
	return v.StoreAddConnectionUnsaved(
		<-v.GoAddConnectionUnsaved(flags, make(chan *dbus.Call, 1), connection).Done)
}

// method LoadConnections

func (v *interfaceSettings) GoLoadConnections(flags dbus.Flags, ch chan *dbus.Call, filenames []string) *dbus.Call {
	return v.GetObject_().Go_(v.GetInterfaceName_()+".LoadConnections", flags, ch, filenames)
}

func (*interfaceSettings) StoreLoadConnections(call *dbus.Call) (status bool, failures []string, err error) {
	err = call.Store(&status, &failures)
	return
}

func (v *interfaceSettings) LoadConnections(flags dbus.Flags, filenames []string) (bool, []string, error) {
	return v.StoreLoadConnections(
		<-v.GoLoadConnections(flags, make(chan *dbus.Call, 1), filenames).Done)
}

// method ReloadConnections

func (v *interfaceSettings) GoReloadConnections(flags dbus.Flags, ch chan *dbus.Call) *dbus.Call {
	return v.GetObject_().Go_(v.GetInterfaceName_()+".ReloadConnections", flags, ch)
}

func (*interfaceSettings) StoreReloadConnections(call *dbus.Call) (status bool, err error) {
	err = call.Store(&status)
	return
}

func (v *interfaceSettings) ReloadConnections(flags dbus.Flags) (bool, error) {
	return v.StoreReloadConnections(
		<-v.GoReloadConnections(flags, make(chan *dbus.Call, 1)).Done)
}

// method SaveHostname

func (v *interfaceSettings) GoSaveHostname(flags dbus.Flags, ch chan *dbus.Call, hostname string) *dbus.Call {
	return v.GetObject_().Go_(v.GetInterfaceName_()+".SaveHostname", flags, ch, hostname)
}

func (v *interfaceSettings) SaveHostname(flags dbus.Flags, hostname string) error {
	return (<-v.GoSaveHostname(flags, make(chan *dbus.Call, 1), hostname).Done).Err
}

// signal PropertiesChanged

func (v *interfaceSettings) ConnectSignalPropertiesChanged(cb func(properties map[string]dbus.Variant)) (dbusutil.SignalHandlerId, error) {
	if cb == nil {
		return 0, errors.New("nil callback")
	}
	obj := v.GetObject_()
	rule := fmt.Sprintf(
		"type='signal',interface='%s',member='%s',path='%s',sender='%s'",
		v.GetInterfaceName_(), "PropertiesChanged", obj.Path_(), obj.ServiceName_())

	sigRule := &dbusutil.SignalRule{
		Path: obj.Path_(),
		Name: v.GetInterfaceName_() + ".PropertiesChanged",
	}
	handlerFunc := func(sig *dbus.Signal) {
		var properties map[string]dbus.Variant
		err := dbus.Store(sig.Body, &properties)
		if err == nil {
			cb(properties)
		}
	}

	return obj.ConnectSignal_(rule, sigRule, handlerFunc)
}

// signal NewConnection

func (v *interfaceSettings) ConnectNewConnection(cb func(connection dbus.ObjectPath)) (dbusutil.SignalHandlerId, error) {
	if cb == nil {
		return 0, errors.New("nil callback")
	}
	obj := v.GetObject_()
	rule := fmt.Sprintf(
		"type='signal',interface='%s',member='%s',path='%s',sender='%s'",
		v.GetInterfaceName_(), "NewConnection", obj.Path_(), obj.ServiceName_())

	sigRule := &dbusutil.SignalRule{
		Path: obj.Path_(),
		Name: v.GetInterfaceName_() + ".NewConnection",
	}
	handlerFunc := func(sig *dbus.Signal) {
		var connection dbus.ObjectPath
		err := dbus.Store(sig.Body, &connection)
		if err == nil {
			cb(connection)
		}
	}

	return obj.ConnectSignal_(rule, sigRule, handlerFunc)
}

// signal ConnectionRemoved

func (v *interfaceSettings) ConnectConnectionRemoved(cb func(connection dbus.ObjectPath)) (dbusutil.SignalHandlerId, error) {
	if cb == nil {
		return 0, errors.New("nil callback")
	}
	obj := v.GetObject_()
	rule := fmt.Sprintf(
		"type='signal',interface='%s',member='%s',path='%s',sender='%s'",
		v.GetInterfaceName_(), "ConnectionRemoved", obj.Path_(), obj.ServiceName_())

	sigRule := &dbusutil.SignalRule{
		Path: obj.Path_(),
		Name: v.GetInterfaceName_() + ".ConnectionRemoved",
	}
	handlerFunc := func(sig *dbus.Signal) {
		var connection dbus.ObjectPath
		err := dbus.Store(sig.Body, &connection)
		if err == nil {
			cb(connection)
		}
	}

	return obj.ConnectSignal_(rule, sigRule, handlerFunc)
}

// property Connections ao

func (v *interfaceSettings) Connections() proxy.PropObjectPathArray {
	return &proxy.ImplPropObjectPathArray{
		Impl: v,
		Name: "Connections",
	}
}

// property Hostname s

func (v *interfaceSettings) Hostname() proxy.PropString {
	return &proxy.ImplPropString{
		Impl: v,
		Name: "Hostname",
	}
}

// property CanModify b

func (v *interfaceSettings) CanModify() proxy.PropBool {
	return &proxy.ImplPropBool{
		Impl: v,
		Name: "CanModify",
	}
}

type VpnConnection interface {
	vpnConnection // interface org.freedesktop.NetworkManager.VPN.Connection
	proxy.Object
}

type objectVpnConnection struct {
	interfaceVpnConnection // interface org.freedesktop.NetworkManager.VPN.Connection
	proxy.ImplObject
}

func NewVpnConnection(conn *dbus.Conn, path dbus.ObjectPath) (VpnConnection, error) {
	if !path.IsValid() {
		return nil, errors.New("path is invalid")
	}
	obj := new(objectVpnConnection)
	obj.ImplObject.Init_(conn, "org.freedesktop.NetworkManager", path)
	return obj, nil
}

type vpnConnection interface {
	ConnectSignalPropertiesChanged(cb func(properties map[string]dbus.Variant)) (dbusutil.SignalHandlerId, error)
	ConnectVpnStateChanged(cb func(state uint32, reason uint32)) (dbusutil.SignalHandlerId, error)
	VpnState() proxy.PropUint32
	Banner() proxy.PropString
}

type interfaceVpnConnection struct{}

func (v *interfaceVpnConnection) GetObject_() *proxy.ImplObject {
	return (*proxy.ImplObject)(unsafe.Pointer(v))
}

func (*interfaceVpnConnection) GetInterfaceName_() string {
	return "org.freedesktop.NetworkManager.VPN.Connection"
}

// signal PropertiesChanged

func (v *interfaceVpnConnection) ConnectSignalPropertiesChanged(cb func(properties map[string]dbus.Variant)) (dbusutil.SignalHandlerId, error) {
	if cb == nil {
		return 0, errors.New("nil callback")
	}
	obj := v.GetObject_()
	rule := fmt.Sprintf(
		"type='signal',interface='%s',member='%s',path='%s',sender='%s'",
		v.GetInterfaceName_(), "PropertiesChanged", obj.Path_(), obj.ServiceName_())

	sigRule := &dbusutil.SignalRule{
		Path: obj.Path_(),
		Name: v.GetInterfaceName_() + ".PropertiesChanged",
	}
	handlerFunc := func(sig *dbus.Signal) {
		var properties map[string]dbus.Variant
		err := dbus.Store(sig.Body, &properties)
		if err == nil {
			cb(properties)
		}
	}

	return obj.ConnectSignal_(rule, sigRule, handlerFunc)
}

// signal VpnStateChanged

func (v *interfaceVpnConnection) ConnectVpnStateChanged(cb func(state uint32, reason uint32)) (dbusutil.SignalHandlerId, error) {
	if cb == nil {
		return 0, errors.New("nil callback")
	}
	obj := v.GetObject_()
	rule := fmt.Sprintf(
		"type='signal',interface='%s',member='%s',path='%s',sender='%s'",
		v.GetInterfaceName_(), "VpnStateChanged", obj.Path_(), obj.ServiceName_())

	sigRule := &dbusutil.SignalRule{
		Path: obj.Path_(),
		Name: v.GetInterfaceName_() + ".VpnStateChanged",
	}
	handlerFunc := func(sig *dbus.Signal) {
		var state uint32
		var reason uint32
		err := dbus.Store(sig.Body, &state, &reason)
		if err == nil {
			cb(state, reason)
		}
	}

	return obj.ConnectSignal_(rule, sigRule, handlerFunc)
}

// property VpnState u

func (v *interfaceVpnConnection) VpnState() proxy.PropUint32 {
	return &proxy.ImplPropUint32{
		Impl: v,
		Name: "VpnState",
	}
}

// property Banner s

func (v *interfaceVpnConnection) Banner() proxy.PropString {
	return &proxy.ImplPropString{
		Impl: v,
		Name: "Banner",
	}
}

type VpnPlugin interface {
	vpnPlugin // interface org.freedesktop.NetworkManager.VPN.Plugin
	proxy.Object
}

type objectVpnPlugin struct {
	interfaceVpnPlugin // interface org.freedesktop.NetworkManager.VPN.Plugin
	proxy.ImplObject
}

func NewVpnPlugin(conn *dbus.Conn, path dbus.ObjectPath) (VpnPlugin, error) {
	if !path.IsValid() {
		return nil, errors.New("path is invalid")
	}
	obj := new(objectVpnPlugin)
	obj.ImplObject.Init_(conn, "org.freedesktop.NetworkManager", path)
	return obj, nil
}

type vpnPlugin interface {
	GoConnect(flags dbus.Flags, ch chan *dbus.Call, connection map[string]map[string]dbus.Variant) *dbus.Call
	Connect(flags dbus.Flags, connection map[string]map[string]dbus.Variant) error
	GoConnectInteractive(flags dbus.Flags, ch chan *dbus.Call, connection map[string]map[string]dbus.Variant, details map[string]dbus.Variant) *dbus.Call
	ConnectInteractive(flags dbus.Flags, connection map[string]map[string]dbus.Variant, details map[string]dbus.Variant) error
	GoNeedSecrets(flags dbus.Flags, ch chan *dbus.Call, settings map[string]map[string]dbus.Variant) *dbus.Call
	NeedSecrets(flags dbus.Flags, settings map[string]map[string]dbus.Variant) (string, error)
	GoDisconnect(flags dbus.Flags, ch chan *dbus.Call) *dbus.Call
	Disconnect(flags dbus.Flags) error
	GoSetConfig(flags dbus.Flags, ch chan *dbus.Call, config map[string]dbus.Variant) *dbus.Call
	SetConfig(flags dbus.Flags, config map[string]dbus.Variant) error
	GoSetIp4Config(flags dbus.Flags, ch chan *dbus.Call, config map[string]dbus.Variant) *dbus.Call
	SetIp4Config(flags dbus.Flags, config map[string]dbus.Variant) error
	GoSetIp6Config(flags dbus.Flags, ch chan *dbus.Call, config map[string]dbus.Variant) *dbus.Call
	SetIp6Config(flags dbus.Flags, config map[string]dbus.Variant) error
	GoSetFailure(flags dbus.Flags, ch chan *dbus.Call, reason string) *dbus.Call
	SetFailure(flags dbus.Flags, reason string) error
	GoNewSecrets(flags dbus.Flags, ch chan *dbus.Call, connection map[string]map[string]dbus.Variant) *dbus.Call
	NewSecrets(flags dbus.Flags, connection map[string]map[string]dbus.Variant) error
	ConnectStateChanged(cb func(state uint32)) (dbusutil.SignalHandlerId, error)
	ConnectSecretsRequired(cb func(message string, secrets []string)) (dbusutil.SignalHandlerId, error)
	ConnectConfig(cb func(config map[string]dbus.Variant)) (dbusutil.SignalHandlerId, error)
	ConnectIp4Config(cb func(ip4config map[string]dbus.Variant)) (dbusutil.SignalHandlerId, error)
	ConnectIp6Config(cb func(ip6config map[string]dbus.Variant)) (dbusutil.SignalHandlerId, error)
	ConnectLoginBanner(cb func(banner string)) (dbusutil.SignalHandlerId, error)
	ConnectFailure(cb func(reason uint32)) (dbusutil.SignalHandlerId, error)
	State() proxy.PropUint32
}

type interfaceVpnPlugin struct{}

func (v *interfaceVpnPlugin) GetObject_() *proxy.ImplObject {
	return (*proxy.ImplObject)(unsafe.Pointer(v))
}

func (*interfaceVpnPlugin) GetInterfaceName_() string {
	return "org.freedesktop.NetworkManager.VPN.Plugin"
}

// method Connect

func (v *interfaceVpnPlugin) GoConnect(flags dbus.Flags, ch chan *dbus.Call, connection map[string]map[string]dbus.Variant) *dbus.Call {
	return v.GetObject_().Go_(v.GetInterfaceName_()+".Connect", flags, ch, connection)
}

func (v *interfaceVpnPlugin) Connect(flags dbus.Flags, connection map[string]map[string]dbus.Variant) error {
	return (<-v.GoConnect(flags, make(chan *dbus.Call, 1), connection).Done).Err
}

// method ConnectInteractive

func (v *interfaceVpnPlugin) GoConnectInteractive(flags dbus.Flags, ch chan *dbus.Call, connection map[string]map[string]dbus.Variant, details map[string]dbus.Variant) *dbus.Call {
	return v.GetObject_().Go_(v.GetInterfaceName_()+".ConnectInteractive", flags, ch, connection, details)
}

func (v *interfaceVpnPlugin) ConnectInteractive(flags dbus.Flags, connection map[string]map[string]dbus.Variant, details map[string]dbus.Variant) error {
	return (<-v.GoConnectInteractive(flags, make(chan *dbus.Call, 1), connection, details).Done).Err
}

// method NeedSecrets

func (v *interfaceVpnPlugin) GoNeedSecrets(flags dbus.Flags, ch chan *dbus.Call, settings map[string]map[string]dbus.Variant) *dbus.Call {
	return v.GetObject_().Go_(v.GetInterfaceName_()+".NeedSecrets", flags, ch, settings)
}

func (*interfaceVpnPlugin) StoreNeedSecrets(call *dbus.Call) (setting_name string, err error) {
	err = call.Store(&setting_name)
	return
}

func (v *interfaceVpnPlugin) NeedSecrets(flags dbus.Flags, settings map[string]map[string]dbus.Variant) (string, error) {
	return v.StoreNeedSecrets(
		<-v.GoNeedSecrets(flags, make(chan *dbus.Call, 1), settings).Done)
}

// method Disconnect

func (v *interfaceVpnPlugin) GoDisconnect(flags dbus.Flags, ch chan *dbus.Call) *dbus.Call {
	return v.GetObject_().Go_(v.GetInterfaceName_()+".Disconnect", flags, ch)
}

func (v *interfaceVpnPlugin) Disconnect(flags dbus.Flags) error {
	return (<-v.GoDisconnect(flags, make(chan *dbus.Call, 1)).Done).Err
}

// method SetConfig

func (v *interfaceVpnPlugin) GoSetConfig(flags dbus.Flags, ch chan *dbus.Call, config map[string]dbus.Variant) *dbus.Call {
	return v.GetObject_().Go_(v.GetInterfaceName_()+".SetConfig", flags, ch, config)
}

func (v *interfaceVpnPlugin) SetConfig(flags dbus.Flags, config map[string]dbus.Variant) error {
	return (<-v.GoSetConfig(flags, make(chan *dbus.Call, 1), config).Done).Err
}

// method SetIp4Config

func (v *interfaceVpnPlugin) GoSetIp4Config(flags dbus.Flags, ch chan *dbus.Call, config map[string]dbus.Variant) *dbus.Call {
	return v.GetObject_().Go_(v.GetInterfaceName_()+".SetIp4Config", flags, ch, config)
}

func (v *interfaceVpnPlugin) SetIp4Config(flags dbus.Flags, config map[string]dbus.Variant) error {
	return (<-v.GoSetIp4Config(flags, make(chan *dbus.Call, 1), config).Done).Err
}

// method SetIp6Config

func (v *interfaceVpnPlugin) GoSetIp6Config(flags dbus.Flags, ch chan *dbus.Call, config map[string]dbus.Variant) *dbus.Call {
	return v.GetObject_().Go_(v.GetInterfaceName_()+".SetIp6Config", flags, ch, config)
}

func (v *interfaceVpnPlugin) SetIp6Config(flags dbus.Flags, config map[string]dbus.Variant) error {
	return (<-v.GoSetIp6Config(flags, make(chan *dbus.Call, 1), config).Done).Err
}

// method SetFailure

func (v *interfaceVpnPlugin) GoSetFailure(flags dbus.Flags, ch chan *dbus.Call, reason string) *dbus.Call {
	return v.GetObject_().Go_(v.GetInterfaceName_()+".SetFailure", flags, ch, reason)
}

func (v *interfaceVpnPlugin) SetFailure(flags dbus.Flags, reason string) error {
	return (<-v.GoSetFailure(flags, make(chan *dbus.Call, 1), reason).Done).Err
}

// method NewSecrets

func (v *interfaceVpnPlugin) GoNewSecrets(flags dbus.Flags, ch chan *dbus.Call, connection map[string]map[string]dbus.Variant) *dbus.Call {
	return v.GetObject_().Go_(v.GetInterfaceName_()+".NewSecrets", flags, ch, connection)
}

func (v *interfaceVpnPlugin) NewSecrets(flags dbus.Flags, connection map[string]map[string]dbus.Variant) error {
	return (<-v.GoNewSecrets(flags, make(chan *dbus.Call, 1), connection).Done).Err
}

// signal StateChanged

func (v *interfaceVpnPlugin) ConnectStateChanged(cb func(state uint32)) (dbusutil.SignalHandlerId, error) {
	if cb == nil {
		return 0, errors.New("nil callback")
	}
	obj := v.GetObject_()
	rule := fmt.Sprintf(
		"type='signal',interface='%s',member='%s',path='%s',sender='%s'",
		v.GetInterfaceName_(), "StateChanged", obj.Path_(), obj.ServiceName_())

	sigRule := &dbusutil.SignalRule{
		Path: obj.Path_(),
		Name: v.GetInterfaceName_() + ".StateChanged",
	}
	handlerFunc := func(sig *dbus.Signal) {
		var state uint32
		err := dbus.Store(sig.Body, &state)
		if err == nil {
			cb(state)
		}
	}

	return obj.ConnectSignal_(rule, sigRule, handlerFunc)
}

// signal SecretsRequired

func (v *interfaceVpnPlugin) ConnectSecretsRequired(cb func(message string, secrets []string)) (dbusutil.SignalHandlerId, error) {
	if cb == nil {
		return 0, errors.New("nil callback")
	}
	obj := v.GetObject_()
	rule := fmt.Sprintf(
		"type='signal',interface='%s',member='%s',path='%s',sender='%s'",
		v.GetInterfaceName_(), "SecretsRequired", obj.Path_(), obj.ServiceName_())

	sigRule := &dbusutil.SignalRule{
		Path: obj.Path_(),
		Name: v.GetInterfaceName_() + ".SecretsRequired",
	}
	handlerFunc := func(sig *dbus.Signal) {
		var message string
		var secrets []string
		err := dbus.Store(sig.Body, &message, &secrets)
		if err == nil {
			cb(message, secrets)
		}
	}

	return obj.ConnectSignal_(rule, sigRule, handlerFunc)
}

// signal Config

func (v *interfaceVpnPlugin) ConnectConfig(cb func(config map[string]dbus.Variant)) (dbusutil.SignalHandlerId, error) {
	if cb == nil {
		return 0, errors.New("nil callback")
	}
	obj := v.GetObject_()
	rule := fmt.Sprintf(
		"type='signal',interface='%s',member='%s',path='%s',sender='%s'",
		v.GetInterfaceName_(), "Config", obj.Path_(), obj.ServiceName_())

	sigRule := &dbusutil.SignalRule{
		Path: obj.Path_(),
		Name: v.GetInterfaceName_() + ".Config",
	}
	handlerFunc := func(sig *dbus.Signal) {
		var config map[string]dbus.Variant
		err := dbus.Store(sig.Body, &config)
		if err == nil {
			cb(config)
		}
	}

	return obj.ConnectSignal_(rule, sigRule, handlerFunc)
}

// signal Ip4Config

func (v *interfaceVpnPlugin) ConnectIp4Config(cb func(ip4config map[string]dbus.Variant)) (dbusutil.SignalHandlerId, error) {
	if cb == nil {
		return 0, errors.New("nil callback")
	}
	obj := v.GetObject_()
	rule := fmt.Sprintf(
		"type='signal',interface='%s',member='%s',path='%s',sender='%s'",
		v.GetInterfaceName_(), "Ip4Config", obj.Path_(), obj.ServiceName_())

	sigRule := &dbusutil.SignalRule{
		Path: obj.Path_(),
		Name: v.GetInterfaceName_() + ".Ip4Config",
	}
	handlerFunc := func(sig *dbus.Signal) {
		var ip4config map[string]dbus.Variant
		err := dbus.Store(sig.Body, &ip4config)
		if err == nil {
			cb(ip4config)
		}
	}

	return obj.ConnectSignal_(rule, sigRule, handlerFunc)
}

// signal Ip6Config

func (v *interfaceVpnPlugin) ConnectIp6Config(cb func(ip6config map[string]dbus.Variant)) (dbusutil.SignalHandlerId, error) {
	if cb == nil {
		return 0, errors.New("nil callback")
	}
	obj := v.GetObject_()
	rule := fmt.Sprintf(
		"type='signal',interface='%s',member='%s',path='%s',sender='%s'",
		v.GetInterfaceName_(), "Ip6Config", obj.Path_(), obj.ServiceName_())

	sigRule := &dbusutil.SignalRule{
		Path: obj.Path_(),
		Name: v.GetInterfaceName_() + ".Ip6Config",
	}
	handlerFunc := func(sig *dbus.Signal) {
		var ip6config map[string]dbus.Variant
		err := dbus.Store(sig.Body, &ip6config)
		if err == nil {
			cb(ip6config)
		}
	}

	return obj.ConnectSignal_(rule, sigRule, handlerFunc)
}

// signal LoginBanner

func (v *interfaceVpnPlugin) ConnectLoginBanner(cb func(banner string)) (dbusutil.SignalHandlerId, error) {
	if cb == nil {
		return 0, errors.New("nil callback")
	}
	obj := v.GetObject_()
	rule := fmt.Sprintf(
		"type='signal',interface='%s',member='%s',path='%s',sender='%s'",
		v.GetInterfaceName_(), "LoginBanner", obj.Path_(), obj.ServiceName_())

	sigRule := &dbusutil.SignalRule{
		Path: obj.Path_(),
		Name: v.GetInterfaceName_() + ".LoginBanner",
	}
	handlerFunc := func(sig *dbus.Signal) {
		var banner string
		err := dbus.Store(sig.Body, &banner)
		if err == nil {
			cb(banner)
		}
	}

	return obj.ConnectSignal_(rule, sigRule, handlerFunc)
}

// signal Failure

func (v *interfaceVpnPlugin) ConnectFailure(cb func(reason uint32)) (dbusutil.SignalHandlerId, error) {
	if cb == nil {
		return 0, errors.New("nil callback")
	}
	obj := v.GetObject_()
	rule := fmt.Sprintf(
		"type='signal',interface='%s',member='%s',path='%s',sender='%s'",
		v.GetInterfaceName_(), "Failure", obj.Path_(), obj.ServiceName_())

	sigRule := &dbusutil.SignalRule{
		Path: obj.Path_(),
		Name: v.GetInterfaceName_() + ".Failure",
	}
	handlerFunc := func(sig *dbus.Signal) {
		var reason uint32
		err := dbus.Store(sig.Body, &reason)
		if err == nil {
			cb(reason)
		}
	}

	return obj.ConnectSignal_(rule, sigRule, handlerFunc)
}

// property State u

func (v *interfaceVpnPlugin) State() proxy.PropUint32 {
	return &proxy.ImplPropUint32{
		Impl: v,
		Name: "State",
	}
}

type Device interface {
	Device() device               // interface org.freedesktop.NetworkManager.Device
	Adsl() deviceAdsl             // interface org.freedesktop.NetworkManager.Device.Adsl
	Bluetooth() deviceBluetooth   // interface org.freedesktop.NetworkManager.Device.Bluetooth
	Bond() deviceBond             // interface org.freedesktop.NetworkManager.Device.Bond
	Bridge() deviceBridge         // interface org.freedesktop.NetworkManager.Device.Bridge
	Generic() deviceGeneric       // interface org.freedesktop.NetworkManager.Device.Generic
	Infiniband() deviceInfiniband // interface org.freedesktop.NetworkManager.Device.Infiniband
	IPTunnel() deviceIPTunnel     // interface org.freedesktop.NetworkManager.Device.IPTunnel
	Macsec() deviceMacsec         // interface org.freedesktop.NetworkManager.Device.Macsec
	Macvlan() deviceMacvlan       // interface org.freedesktop.NetworkManager.Device.Macvlan
	Modem() deviceModem           // interface org.freedesktop.NetworkManager.Device.Modem
	OlpcMesh() deviceOlpcMesh     // interface org.freedesktop.NetworkManager.Device.OlpcMesh
	Statistics() deviceStatistics // interface org.freedesktop.NetworkManager.Device.Statistics
	Team() deviceTeam             // interface org.freedesktop.NetworkManager.Device.Team
	Tun() deviceTun               // interface org.freedesktop.NetworkManager.Device.Tun
	Veth() deviceVeth             // interface org.freedesktop.NetworkManager.Device.Veth
	Vlan() deviceVlan             // interface org.freedesktop.NetworkManager.Device.Vlan
	Vxlan() deviceVxlan           // interface org.freedesktop.NetworkManager.Device.Vxlan
	WiMax() deviceWiMax           // interface org.freedesktop.NetworkManager.Device.WiMax
	Wired() deviceWired           // interface org.freedesktop.NetworkManager.Device.Wired
	Wireless() deviceWireless     // interface org.freedesktop.NetworkManager.Device.Wireless
	proxy.Object
}

type objectDevice struct {
	interfaceDevice           // interface org.freedesktop.NetworkManager.Device
	interfaceDeviceAdsl       // interface org.freedesktop.NetworkManager.Device.Adsl
	interfaceDeviceBluetooth  // interface org.freedesktop.NetworkManager.Device.Bluetooth
	interfaceDeviceBond       // interface org.freedesktop.NetworkManager.Device.Bond
	interfaceDeviceBridge     // interface org.freedesktop.NetworkManager.Device.Bridge
	interfaceDeviceGeneric    // interface org.freedesktop.NetworkManager.Device.Generic
	interfaceDeviceInfiniband // interface org.freedesktop.NetworkManager.Device.Infiniband
	interfaceDeviceIPTunnel   // interface org.freedesktop.NetworkManager.Device.IPTunnel
	interfaceDeviceMacsec     // interface org.freedesktop.NetworkManager.Device.Macsec
	interfaceDeviceMacvlan    // interface org.freedesktop.NetworkManager.Device.Macvlan
	interfaceDeviceModem      // interface org.freedesktop.NetworkManager.Device.Modem
	interfaceDeviceOlpcMesh   // interface org.freedesktop.NetworkManager.Device.OlpcMesh
	interfaceDeviceStatistics // interface org.freedesktop.NetworkManager.Device.Statistics
	interfaceDeviceTeam       // interface org.freedesktop.NetworkManager.Device.Team
	interfaceDeviceTun        // interface org.freedesktop.NetworkManager.Device.Tun
	interfaceDeviceVeth       // interface org.freedesktop.NetworkManager.Device.Veth
	interfaceDeviceVlan       // interface org.freedesktop.NetworkManager.Device.Vlan
	interfaceDeviceVxlan      // interface org.freedesktop.NetworkManager.Device.Vxlan
	interfaceDeviceWiMax      // interface org.freedesktop.NetworkManager.Device.WiMax
	interfaceDeviceWired      // interface org.freedesktop.NetworkManager.Device.Wired
	interfaceDeviceWireless   // interface org.freedesktop.NetworkManager.Device.Wireless
	proxy.ImplObject
}

func NewDevice(conn *dbus.Conn, path dbus.ObjectPath) (Device, error) {
	if !path.IsValid() {
		return nil, errors.New("path is invalid")
	}
	obj := new(objectDevice)
	obj.ImplObject.Init_(conn, "org.freedesktop.NetworkManager", path)
	return obj, nil
}

func (obj *objectDevice) Device() device {
	return &obj.interfaceDevice
}

type device interface {
	GoReapply(flags dbus.Flags, ch chan *dbus.Call, connection map[string]map[string]dbus.Variant, version_id uint64, flags0 uint32) *dbus.Call
	Reapply(flags dbus.Flags, connection map[string]map[string]dbus.Variant, version_id uint64, flags0 uint32) error
	GoGetAppliedConnection(flags dbus.Flags, ch chan *dbus.Call, flags0 uint32) *dbus.Call
	GetAppliedConnection(flags dbus.Flags, flags0 uint32) (map[string]map[string]dbus.Variant, uint64, error)
	GoDisconnect(flags dbus.Flags, ch chan *dbus.Call) *dbus.Call
	Disconnect(flags dbus.Flags) error
	GoDelete(flags dbus.Flags, ch chan *dbus.Call) *dbus.Call
	Delete(flags dbus.Flags) error
	ConnectStateChanged(cb func(new_state uint32, old_state uint32, reason uint32)) (dbusutil.SignalHandlerId, error)
	Udi() proxy.PropString
	Interface() proxy.PropString
	InterfaceFlags() proxy.PropUint32
	IpInterface() proxy.PropString
	Driver() proxy.PropString
	DriverVersion() proxy.PropString
	FirmwareVersion() proxy.PropString
	Capabilities() proxy.PropUint32
	Ip4Address() proxy.PropUint32
	State() proxy.PropUint32
	StateReason() PropDeviceStateReason
	ActiveConnection() proxy.PropObjectPath
	Ip4Config() proxy.PropObjectPath
	Dhcp4Config() proxy.PropObjectPath
	Ip6Config() proxy.PropObjectPath
	Dhcp6Config() proxy.PropObjectPath
	Managed() proxy.PropBool
	Autoconnect() proxy.PropBool
	FirmwareMissing() proxy.PropBool
	NmPluginMissing() proxy.PropBool
	DeviceType() proxy.PropUint32
	AvailableConnections() proxy.PropObjectPathArray
	PhysicalPortId() proxy.PropString
	Mtu() proxy.PropUint32
	Metered() proxy.PropUint32
	LldpNeighbors() PropMapSVSlice
	Real() proxy.PropBool
}

type interfaceDevice struct{}

func (v *interfaceDevice) GetObject_() *proxy.ImplObject {
	return (*proxy.ImplObject)(unsafe.Pointer(v))
}

func (*interfaceDevice) GetInterfaceName_() string {
	return "org.freedesktop.NetworkManager.Device"
}

// method Reapply

func (v *interfaceDevice) GoReapply(flags dbus.Flags, ch chan *dbus.Call, connection map[string]map[string]dbus.Variant, version_id uint64, flags0 uint32) *dbus.Call {
	return v.GetObject_().Go_(v.GetInterfaceName_()+".Reapply", flags, ch, connection, version_id, flags0)
}

func (v *interfaceDevice) Reapply(flags dbus.Flags, connection map[string]map[string]dbus.Variant, version_id uint64, flags0 uint32) error {
	return (<-v.GoReapply(flags, make(chan *dbus.Call, 1), connection, version_id, flags0).Done).Err
}

// method GetAppliedConnection

func (v *interfaceDevice) GoGetAppliedConnection(flags dbus.Flags, ch chan *dbus.Call, flags0 uint32) *dbus.Call {
	return v.GetObject_().Go_(v.GetInterfaceName_()+".GetAppliedConnection", flags, ch, flags0)
}

func (*interfaceDevice) StoreGetAppliedConnection(call *dbus.Call) (connection map[string]map[string]dbus.Variant, version_id uint64, err error) {
	err = call.Store(&connection, &version_id)
	return
}

func (v *interfaceDevice) GetAppliedConnection(flags dbus.Flags, flags0 uint32) (map[string]map[string]dbus.Variant, uint64, error) {
	return v.StoreGetAppliedConnection(
		<-v.GoGetAppliedConnection(flags, make(chan *dbus.Call, 1), flags0).Done)
}

// method Disconnect

func (v *interfaceDevice) GoDisconnect(flags dbus.Flags, ch chan *dbus.Call) *dbus.Call {
	return v.GetObject_().Go_(v.GetInterfaceName_()+".Disconnect", flags, ch)
}

func (v *interfaceDevice) Disconnect(flags dbus.Flags) error {
	return (<-v.GoDisconnect(flags, make(chan *dbus.Call, 1)).Done).Err
}

// method Delete

func (v *interfaceDevice) GoDelete(flags dbus.Flags, ch chan *dbus.Call) *dbus.Call {
	return v.GetObject_().Go_(v.GetInterfaceName_()+".Delete", flags, ch)
}

func (v *interfaceDevice) Delete(flags dbus.Flags) error {
	return (<-v.GoDelete(flags, make(chan *dbus.Call, 1)).Done).Err
}

// signal StateChanged

func (v *interfaceDevice) ConnectStateChanged(cb func(new_state uint32, old_state uint32, reason uint32)) (dbusutil.SignalHandlerId, error) {
	if cb == nil {
		return 0, errors.New("nil callback")
	}
	obj := v.GetObject_()
	rule := fmt.Sprintf(
		"type='signal',interface='%s',member='%s',path='%s',sender='%s'",
		v.GetInterfaceName_(), "StateChanged", obj.Path_(), obj.ServiceName_())

	sigRule := &dbusutil.SignalRule{
		Path: obj.Path_(),
		Name: v.GetInterfaceName_() + ".StateChanged",
	}
	handlerFunc := func(sig *dbus.Signal) {
		var new_state uint32
		var old_state uint32
		var reason uint32
		err := dbus.Store(sig.Body, &new_state, &old_state, &reason)
		if err == nil {
			cb(new_state, old_state, reason)
		}
	}

	return obj.ConnectSignal_(rule, sigRule, handlerFunc)
}

// property Udi s

func (v *interfaceDevice) Udi() proxy.PropString {
	return &proxy.ImplPropString{
		Impl: v,
		Name: "Udi",
	}
}

// property Interface s

func (v *interfaceDevice) Interface() proxy.PropString {
	return &proxy.ImplPropString{
		Impl: v,
		Name: "Interface",
	}
}

// property InterfaceFlags u

func (v *interfaceDevice) InterfaceFlags() proxy.PropUint32 {
	return &proxy.ImplPropUint32{
		Impl: v,
		Name: "InterfaceFlags",
	}
}

// property IpInterface s

func (v *interfaceDevice) IpInterface() proxy.PropString {
	return &proxy.ImplPropString{
		Impl: v,
		Name: "IpInterface",
	}
}

// property Driver s

func (v *interfaceDevice) Driver() proxy.PropString {
	return &proxy.ImplPropString{
		Impl: v,
		Name: "Driver",
	}
}

// property DriverVersion s

func (v *interfaceDevice) DriverVersion() proxy.PropString {
	return &proxy.ImplPropString{
		Impl: v,
		Name: "DriverVersion",
	}
}

// property FirmwareVersion s

func (v *interfaceDevice) FirmwareVersion() proxy.PropString {
	return &proxy.ImplPropString{
		Impl: v,
		Name: "FirmwareVersion",
	}
}

// property Capabilities u

func (v *interfaceDevice) Capabilities() proxy.PropUint32 {
	return &proxy.ImplPropUint32{
		Impl: v,
		Name: "Capabilities",
	}
}

// property Ip4Address u

func (v *interfaceDevice) Ip4Address() proxy.PropUint32 {
	return &proxy.ImplPropUint32{
		Impl: v,
		Name: "Ip4Address",
	}
}

// property State u

func (v *interfaceDevice) State() proxy.PropUint32 {
	return &proxy.ImplPropUint32{
		Impl: v,
		Name: "State",
	}
}

type PropDeviceStateReason interface {
	Get(flags dbus.Flags) (value DeviceStateReason, err error)
	Set(flags dbus.Flags, value DeviceStateReason) error
	ConnectChanged(cb func(hasValue bool, value DeviceStateReason)) error
}

type implPropDeviceStateReason struct {
	Impl proxy.Implementer
	Name string
}

func (p implPropDeviceStateReason) Get(flags dbus.Flags) (value DeviceStateReason, err error) {
	err = p.Impl.GetObject_().GetProperty_(flags, p.Impl.GetInterfaceName_(),
		p.Name, &value)
	return
}

func (p implPropDeviceStateReason) Set(flags dbus.Flags, value DeviceStateReason) error {
	return p.Impl.GetObject_().SetProperty_(flags, p.Impl.GetInterfaceName_(), p.Name, value)
}

func (p implPropDeviceStateReason) ConnectChanged(cb func(hasValue bool, value DeviceStateReason)) error {
	if cb == nil {
		return errors.New("nil callback")
	}
	cb0 := func(hasValue bool, value interface{}) {
		if hasValue {
			var v DeviceStateReason
			err := dbus.Store([]interface{}{value}, &v)
			if err != nil {
				return
			}
			cb(true, v)
		} else {
			cb(false, DeviceStateReason{})
		}
	}
	return p.Impl.GetObject_().ConnectPropertyChanged_(p.Impl.GetInterfaceName_(),
		p.Name, cb0)
}

// property StateReason (uu)

func (v *interfaceDevice) StateReason() PropDeviceStateReason {
	return &implPropDeviceStateReason{
		Impl: v,
		Name: "StateReason",
	}
}

// property ActiveConnection o

func (v *interfaceDevice) ActiveConnection() proxy.PropObjectPath {
	return &proxy.ImplPropObjectPath{
		Impl: v,
		Name: "ActiveConnection",
	}
}

// property Ip4Config o

func (v *interfaceDevice) Ip4Config() proxy.PropObjectPath {
	return &proxy.ImplPropObjectPath{
		Impl: v,
		Name: "Ip4Config",
	}
}

// property Dhcp4Config o

func (v *interfaceDevice) Dhcp4Config() proxy.PropObjectPath {
	return &proxy.ImplPropObjectPath{
		Impl: v,
		Name: "Dhcp4Config",
	}
}

// property Ip6Config o

func (v *interfaceDevice) Ip6Config() proxy.PropObjectPath {
	return &proxy.ImplPropObjectPath{
		Impl: v,
		Name: "Ip6Config",
	}
}

// property Dhcp6Config o

func (v *interfaceDevice) Dhcp6Config() proxy.PropObjectPath {
	return &proxy.ImplPropObjectPath{
		Impl: v,
		Name: "Dhcp6Config",
	}
}

// property Managed b

func (v *interfaceDevice) Managed() proxy.PropBool {
	return &proxy.ImplPropBool{
		Impl: v,
		Name: "Managed",
	}
}

// property Autoconnect b

func (v *interfaceDevice) Autoconnect() proxy.PropBool {
	return &proxy.ImplPropBool{
		Impl: v,
		Name: "Autoconnect",
	}
}

// property FirmwareMissing b

func (v *interfaceDevice) FirmwareMissing() proxy.PropBool {
	return &proxy.ImplPropBool{
		Impl: v,
		Name: "FirmwareMissing",
	}
}

// property NmPluginMissing b

func (v *interfaceDevice) NmPluginMissing() proxy.PropBool {
	return &proxy.ImplPropBool{
		Impl: v,
		Name: "NmPluginMissing",
	}
}

// property DeviceType u

func (v *interfaceDevice) DeviceType() proxy.PropUint32 {
	return &proxy.ImplPropUint32{
		Impl: v,
		Name: "DeviceType",
	}
}

// property AvailableConnections ao

func (v *interfaceDevice) AvailableConnections() proxy.PropObjectPathArray {
	return &proxy.ImplPropObjectPathArray{
		Impl: v,
		Name: "AvailableConnections",
	}
}

// property PhysicalPortId s

func (v *interfaceDevice) PhysicalPortId() proxy.PropString {
	return &proxy.ImplPropString{
		Impl: v,
		Name: "PhysicalPortId",
	}
}

// property Mtu u

func (v *interfaceDevice) Mtu() proxy.PropUint32 {
	return &proxy.ImplPropUint32{
		Impl: v,
		Name: "Mtu",
	}
}

// property Metered u

func (v *interfaceDevice) Metered() proxy.PropUint32 {
	return &proxy.ImplPropUint32{
		Impl: v,
		Name: "Metered",
	}
}

// property LldpNeighbors aa{sv}

func (v *interfaceDevice) LldpNeighbors() PropMapSVSlice {
	return &implPropMapSVSlice{
		Impl: v,
		Name: "LldpNeighbors",
	}
}

// property Real b

func (v *interfaceDevice) Real() proxy.PropBool {
	return &proxy.ImplPropBool{
		Impl: v,
		Name: "Real",
	}
}

func (obj *objectDevice) Adsl() deviceAdsl {
	return &obj.interfaceDeviceAdsl
}

type deviceAdsl interface {
	ConnectSignalPropertiesChanged(cb func(properties map[string]dbus.Variant)) (dbusutil.SignalHandlerId, error)
	Carrier() proxy.PropBool
}

type interfaceDeviceAdsl struct{}

func (v *interfaceDeviceAdsl) GetObject_() *proxy.ImplObject {
	return (*proxy.ImplObject)(unsafe.Pointer(v))
}

func (*interfaceDeviceAdsl) GetInterfaceName_() string {
	return "org.freedesktop.NetworkManager.Device.Adsl"
}

// signal PropertiesChanged

func (v *interfaceDeviceAdsl) ConnectSignalPropertiesChanged(cb func(properties map[string]dbus.Variant)) (dbusutil.SignalHandlerId, error) {
	if cb == nil {
		return 0, errors.New("nil callback")
	}
	obj := v.GetObject_()
	rule := fmt.Sprintf(
		"type='signal',interface='%s',member='%s',path='%s',sender='%s'",
		v.GetInterfaceName_(), "PropertiesChanged", obj.Path_(), obj.ServiceName_())

	sigRule := &dbusutil.SignalRule{
		Path: obj.Path_(),
		Name: v.GetInterfaceName_() + ".PropertiesChanged",
	}
	handlerFunc := func(sig *dbus.Signal) {
		var properties map[string]dbus.Variant
		err := dbus.Store(sig.Body, &properties)
		if err == nil {
			cb(properties)
		}
	}

	return obj.ConnectSignal_(rule, sigRule, handlerFunc)
}

// property Carrier b

func (v *interfaceDeviceAdsl) Carrier() proxy.PropBool {
	return &proxy.ImplPropBool{
		Impl: v,
		Name: "Carrier",
	}
}

func (obj *objectDevice) Bluetooth() deviceBluetooth {
	return &obj.interfaceDeviceBluetooth
}

type deviceBluetooth interface {
	ConnectSignalPropertiesChanged(cb func(properties map[string]dbus.Variant)) (dbusutil.SignalHandlerId, error)
	HwAddress() proxy.PropString
	Name() proxy.PropString
	BtCapabilities() proxy.PropUint32
}

type interfaceDeviceBluetooth struct{}

func (v *interfaceDeviceBluetooth) GetObject_() *proxy.ImplObject {
	return (*proxy.ImplObject)(unsafe.Pointer(v))
}

func (*interfaceDeviceBluetooth) GetInterfaceName_() string {
	return "org.freedesktop.NetworkManager.Device.Bluetooth"
}

// signal PropertiesChanged

func (v *interfaceDeviceBluetooth) ConnectSignalPropertiesChanged(cb func(properties map[string]dbus.Variant)) (dbusutil.SignalHandlerId, error) {
	if cb == nil {
		return 0, errors.New("nil callback")
	}
	obj := v.GetObject_()
	rule := fmt.Sprintf(
		"type='signal',interface='%s',member='%s',path='%s',sender='%s'",
		v.GetInterfaceName_(), "PropertiesChanged", obj.Path_(), obj.ServiceName_())

	sigRule := &dbusutil.SignalRule{
		Path: obj.Path_(),
		Name: v.GetInterfaceName_() + ".PropertiesChanged",
	}
	handlerFunc := func(sig *dbus.Signal) {
		var properties map[string]dbus.Variant
		err := dbus.Store(sig.Body, &properties)
		if err == nil {
			cb(properties)
		}
	}

	return obj.ConnectSignal_(rule, sigRule, handlerFunc)
}

// property HwAddress s

func (v *interfaceDeviceBluetooth) HwAddress() proxy.PropString {
	return &proxy.ImplPropString{
		Impl: v,
		Name: "HwAddress",
	}
}

// property Name s

func (v *interfaceDeviceBluetooth) Name() proxy.PropString {
	return &proxy.ImplPropString{
		Impl: v,
		Name: "Name",
	}
}

// property BtCapabilities u

func (v *interfaceDeviceBluetooth) BtCapabilities() proxy.PropUint32 {
	return &proxy.ImplPropUint32{
		Impl: v,
		Name: "BtCapabilities",
	}
}

func (obj *objectDevice) Bond() deviceBond {
	return &obj.interfaceDeviceBond
}

type deviceBond interface {
	ConnectSignalPropertiesChanged(cb func(properties map[string]dbus.Variant)) (dbusutil.SignalHandlerId, error)
	HwAddress() proxy.PropString
	Carrier() proxy.PropBool
	Slaves() proxy.PropObjectPathArray
}

type interfaceDeviceBond struct{}

func (v *interfaceDeviceBond) GetObject_() *proxy.ImplObject {
	return (*proxy.ImplObject)(unsafe.Pointer(v))
}

func (*interfaceDeviceBond) GetInterfaceName_() string {
	return "org.freedesktop.NetworkManager.Device.Bond"
}

// signal PropertiesChanged

func (v *interfaceDeviceBond) ConnectSignalPropertiesChanged(cb func(properties map[string]dbus.Variant)) (dbusutil.SignalHandlerId, error) {
	if cb == nil {
		return 0, errors.New("nil callback")
	}
	obj := v.GetObject_()
	rule := fmt.Sprintf(
		"type='signal',interface='%s',member='%s',path='%s',sender='%s'",
		v.GetInterfaceName_(), "PropertiesChanged", obj.Path_(), obj.ServiceName_())

	sigRule := &dbusutil.SignalRule{
		Path: obj.Path_(),
		Name: v.GetInterfaceName_() + ".PropertiesChanged",
	}
	handlerFunc := func(sig *dbus.Signal) {
		var properties map[string]dbus.Variant
		err := dbus.Store(sig.Body, &properties)
		if err == nil {
			cb(properties)
		}
	}

	return obj.ConnectSignal_(rule, sigRule, handlerFunc)
}

// property HwAddress s

func (v *interfaceDeviceBond) HwAddress() proxy.PropString {
	return &proxy.ImplPropString{
		Impl: v,
		Name: "HwAddress",
	}
}

// property Carrier b

func (v *interfaceDeviceBond) Carrier() proxy.PropBool {
	return &proxy.ImplPropBool{
		Impl: v,
		Name: "Carrier",
	}
}

// property Slaves ao

func (v *interfaceDeviceBond) Slaves() proxy.PropObjectPathArray {
	return &proxy.ImplPropObjectPathArray{
		Impl: v,
		Name: "Slaves",
	}
}

func (obj *objectDevice) Bridge() deviceBridge {
	return &obj.interfaceDeviceBridge
}

type deviceBridge interface {
	ConnectSignalPropertiesChanged(cb func(properties map[string]dbus.Variant)) (dbusutil.SignalHandlerId, error)
	HwAddress() proxy.PropString
	Carrier() proxy.PropBool
	Slaves() proxy.PropObjectPathArray
}

type interfaceDeviceBridge struct{}

func (v *interfaceDeviceBridge) GetObject_() *proxy.ImplObject {
	return (*proxy.ImplObject)(unsafe.Pointer(v))
}

func (*interfaceDeviceBridge) GetInterfaceName_() string {
	return "org.freedesktop.NetworkManager.Device.Bridge"
}

// signal PropertiesChanged

func (v *interfaceDeviceBridge) ConnectSignalPropertiesChanged(cb func(properties map[string]dbus.Variant)) (dbusutil.SignalHandlerId, error) {
	if cb == nil {
		return 0, errors.New("nil callback")
	}
	obj := v.GetObject_()
	rule := fmt.Sprintf(
		"type='signal',interface='%s',member='%s',path='%s',sender='%s'",
		v.GetInterfaceName_(), "PropertiesChanged", obj.Path_(), obj.ServiceName_())

	sigRule := &dbusutil.SignalRule{
		Path: obj.Path_(),
		Name: v.GetInterfaceName_() + ".PropertiesChanged",
	}
	handlerFunc := func(sig *dbus.Signal) {
		var properties map[string]dbus.Variant
		err := dbus.Store(sig.Body, &properties)
		if err == nil {
			cb(properties)
		}
	}

	return obj.ConnectSignal_(rule, sigRule, handlerFunc)
}

// property HwAddress s

func (v *interfaceDeviceBridge) HwAddress() proxy.PropString {
	return &proxy.ImplPropString{
		Impl: v,
		Name: "HwAddress",
	}
}

// property Carrier b

func (v *interfaceDeviceBridge) Carrier() proxy.PropBool {
	return &proxy.ImplPropBool{
		Impl: v,
		Name: "Carrier",
	}
}

// property Slaves ao

func (v *interfaceDeviceBridge) Slaves() proxy.PropObjectPathArray {
	return &proxy.ImplPropObjectPathArray{
		Impl: v,
		Name: "Slaves",
	}
}

func (obj *objectDevice) Generic() deviceGeneric {
	return &obj.interfaceDeviceGeneric
}

type deviceGeneric interface {
	ConnectSignalPropertiesChanged(cb func(properties map[string]dbus.Variant)) (dbusutil.SignalHandlerId, error)
	HwAddress() proxy.PropString
	TypeDescription() proxy.PropString
}

type interfaceDeviceGeneric struct{}

func (v *interfaceDeviceGeneric) GetObject_() *proxy.ImplObject {
	return (*proxy.ImplObject)(unsafe.Pointer(v))
}

func (*interfaceDeviceGeneric) GetInterfaceName_() string {
	return "org.freedesktop.NetworkManager.Device.Generic"
}

// signal PropertiesChanged

func (v *interfaceDeviceGeneric) ConnectSignalPropertiesChanged(cb func(properties map[string]dbus.Variant)) (dbusutil.SignalHandlerId, error) {
	if cb == nil {
		return 0, errors.New("nil callback")
	}
	obj := v.GetObject_()
	rule := fmt.Sprintf(
		"type='signal',interface='%s',member='%s',path='%s',sender='%s'",
		v.GetInterfaceName_(), "PropertiesChanged", obj.Path_(), obj.ServiceName_())

	sigRule := &dbusutil.SignalRule{
		Path: obj.Path_(),
		Name: v.GetInterfaceName_() + ".PropertiesChanged",
	}
	handlerFunc := func(sig *dbus.Signal) {
		var properties map[string]dbus.Variant
		err := dbus.Store(sig.Body, &properties)
		if err == nil {
			cb(properties)
		}
	}

	return obj.ConnectSignal_(rule, sigRule, handlerFunc)
}

// property HwAddress s

func (v *interfaceDeviceGeneric) HwAddress() proxy.PropString {
	return &proxy.ImplPropString{
		Impl: v,
		Name: "HwAddress",
	}
}

// property TypeDescription s

func (v *interfaceDeviceGeneric) TypeDescription() proxy.PropString {
	return &proxy.ImplPropString{
		Impl: v,
		Name: "TypeDescription",
	}
}

func (obj *objectDevice) Infiniband() deviceInfiniband {
	return &obj.interfaceDeviceInfiniband
}

type deviceInfiniband interface {
	ConnectSignalPropertiesChanged(cb func(properties map[string]dbus.Variant)) (dbusutil.SignalHandlerId, error)
	HwAddress() proxy.PropString
	Carrier() proxy.PropBool
}

type interfaceDeviceInfiniband struct{}

func (v *interfaceDeviceInfiniband) GetObject_() *proxy.ImplObject {
	return (*proxy.ImplObject)(unsafe.Pointer(v))
}

func (*interfaceDeviceInfiniband) GetInterfaceName_() string {
	return "org.freedesktop.NetworkManager.Device.Infiniband"
}

// signal PropertiesChanged

func (v *interfaceDeviceInfiniband) ConnectSignalPropertiesChanged(cb func(properties map[string]dbus.Variant)) (dbusutil.SignalHandlerId, error) {
	if cb == nil {
		return 0, errors.New("nil callback")
	}
	obj := v.GetObject_()
	rule := fmt.Sprintf(
		"type='signal',interface='%s',member='%s',path='%s',sender='%s'",
		v.GetInterfaceName_(), "PropertiesChanged", obj.Path_(), obj.ServiceName_())

	sigRule := &dbusutil.SignalRule{
		Path: obj.Path_(),
		Name: v.GetInterfaceName_() + ".PropertiesChanged",
	}
	handlerFunc := func(sig *dbus.Signal) {
		var properties map[string]dbus.Variant
		err := dbus.Store(sig.Body, &properties)
		if err == nil {
			cb(properties)
		}
	}

	return obj.ConnectSignal_(rule, sigRule, handlerFunc)
}

// property HwAddress s

func (v *interfaceDeviceInfiniband) HwAddress() proxy.PropString {
	return &proxy.ImplPropString{
		Impl: v,
		Name: "HwAddress",
	}
}

// property Carrier b

func (v *interfaceDeviceInfiniband) Carrier() proxy.PropBool {
	return &proxy.ImplPropBool{
		Impl: v,
		Name: "Carrier",
	}
}

func (obj *objectDevice) IPTunnel() deviceIPTunnel {
	return &obj.interfaceDeviceIPTunnel
}

type deviceIPTunnel interface {
	ConnectSignalPropertiesChanged(cb func(properties map[string]dbus.Variant)) (dbusutil.SignalHandlerId, error)
	Mode() proxy.PropUint32
	Parent() proxy.PropObjectPath
	Local() proxy.PropString
	Remote() proxy.PropString
	Ttl() proxy.PropByte
	Tos() proxy.PropByte
	PathMtuDiscovery() proxy.PropBool
	InputKey() proxy.PropString
	OutputKey() proxy.PropString
	EncapsulationLimit() proxy.PropByte
	FlowLabel() proxy.PropUint32
}

type interfaceDeviceIPTunnel struct{}

func (v *interfaceDeviceIPTunnel) GetObject_() *proxy.ImplObject {
	return (*proxy.ImplObject)(unsafe.Pointer(v))
}

func (*interfaceDeviceIPTunnel) GetInterfaceName_() string {
	return "org.freedesktop.NetworkManager.Device.IPTunnel"
}

// signal PropertiesChanged

func (v *interfaceDeviceIPTunnel) ConnectSignalPropertiesChanged(cb func(properties map[string]dbus.Variant)) (dbusutil.SignalHandlerId, error) {
	if cb == nil {
		return 0, errors.New("nil callback")
	}
	obj := v.GetObject_()
	rule := fmt.Sprintf(
		"type='signal',interface='%s',member='%s',path='%s',sender='%s'",
		v.GetInterfaceName_(), "PropertiesChanged", obj.Path_(), obj.ServiceName_())

	sigRule := &dbusutil.SignalRule{
		Path: obj.Path_(),
		Name: v.GetInterfaceName_() + ".PropertiesChanged",
	}
	handlerFunc := func(sig *dbus.Signal) {
		var properties map[string]dbus.Variant
		err := dbus.Store(sig.Body, &properties)
		if err == nil {
			cb(properties)
		}
	}

	return obj.ConnectSignal_(rule, sigRule, handlerFunc)
}

// property Mode u

func (v *interfaceDeviceIPTunnel) Mode() proxy.PropUint32 {
	return &proxy.ImplPropUint32{
		Impl: v,
		Name: "Mode",
	}
}

// property Parent o

func (v *interfaceDeviceIPTunnel) Parent() proxy.PropObjectPath {
	return &proxy.ImplPropObjectPath{
		Impl: v,
		Name: "Parent",
	}
}

// property Local s

func (v *interfaceDeviceIPTunnel) Local() proxy.PropString {
	return &proxy.ImplPropString{
		Impl: v,
		Name: "Local",
	}
}

// property Remote s

func (v *interfaceDeviceIPTunnel) Remote() proxy.PropString {
	return &proxy.ImplPropString{
		Impl: v,
		Name: "Remote",
	}
}

// property Ttl y

func (v *interfaceDeviceIPTunnel) Ttl() proxy.PropByte {
	return &proxy.ImplPropByte{
		Impl: v,
		Name: "Ttl",
	}
}

// property Tos y

func (v *interfaceDeviceIPTunnel) Tos() proxy.PropByte {
	return &proxy.ImplPropByte{
		Impl: v,
		Name: "Tos",
	}
}

// property PathMtuDiscovery b

func (v *interfaceDeviceIPTunnel) PathMtuDiscovery() proxy.PropBool {
	return &proxy.ImplPropBool{
		Impl: v,
		Name: "PathMtuDiscovery",
	}
}

// property InputKey s

func (v *interfaceDeviceIPTunnel) InputKey() proxy.PropString {
	return &proxy.ImplPropString{
		Impl: v,
		Name: "InputKey",
	}
}

// property OutputKey s

func (v *interfaceDeviceIPTunnel) OutputKey() proxy.PropString {
	return &proxy.ImplPropString{
		Impl: v,
		Name: "OutputKey",
	}
}

// property EncapsulationLimit y

func (v *interfaceDeviceIPTunnel) EncapsulationLimit() proxy.PropByte {
	return &proxy.ImplPropByte{
		Impl: v,
		Name: "EncapsulationLimit",
	}
}

// property FlowLabel u

func (v *interfaceDeviceIPTunnel) FlowLabel() proxy.PropUint32 {
	return &proxy.ImplPropUint32{
		Impl: v,
		Name: "FlowLabel",
	}
}

func (obj *objectDevice) Macsec() deviceMacsec {
	return &obj.interfaceDeviceMacsec
}

type deviceMacsec interface {
	ConnectSignalPropertiesChanged(cb func(properties map[string]dbus.Variant)) (dbusutil.SignalHandlerId, error)
	Parent() proxy.PropObjectPath
	Sci() proxy.PropUint64
	IcvLength() proxy.PropByte
	CipherSuite() proxy.PropUint64
	Window() proxy.PropUint32
	EncodingSa() proxy.PropByte
	Validation() proxy.PropString
	Encrypt() proxy.PropBool
	Protect() proxy.PropBool
	IncludeSci() proxy.PropBool
	Es() proxy.PropBool
	Scb() proxy.PropBool
	ReplayProtect() proxy.PropBool
}

type interfaceDeviceMacsec struct{}

func (v *interfaceDeviceMacsec) GetObject_() *proxy.ImplObject {
	return (*proxy.ImplObject)(unsafe.Pointer(v))
}

func (*interfaceDeviceMacsec) GetInterfaceName_() string {
	return "org.freedesktop.NetworkManager.Device.Macsec"
}

// signal PropertiesChanged

func (v *interfaceDeviceMacsec) ConnectSignalPropertiesChanged(cb func(properties map[string]dbus.Variant)) (dbusutil.SignalHandlerId, error) {
	if cb == nil {
		return 0, errors.New("nil callback")
	}
	obj := v.GetObject_()
	rule := fmt.Sprintf(
		"type='signal',interface='%s',member='%s',path='%s',sender='%s'",
		v.GetInterfaceName_(), "PropertiesChanged", obj.Path_(), obj.ServiceName_())

	sigRule := &dbusutil.SignalRule{
		Path: obj.Path_(),
		Name: v.GetInterfaceName_() + ".PropertiesChanged",
	}
	handlerFunc := func(sig *dbus.Signal) {
		var properties map[string]dbus.Variant
		err := dbus.Store(sig.Body, &properties)
		if err == nil {
			cb(properties)
		}
	}

	return obj.ConnectSignal_(rule, sigRule, handlerFunc)
}

// property Parent o

func (v *interfaceDeviceMacsec) Parent() proxy.PropObjectPath {
	return &proxy.ImplPropObjectPath{
		Impl: v,
		Name: "Parent",
	}
}

// property Sci t

func (v *interfaceDeviceMacsec) Sci() proxy.PropUint64 {
	return &proxy.ImplPropUint64{
		Impl: v,
		Name: "Sci",
	}
}

// property IcvLength y

func (v *interfaceDeviceMacsec) IcvLength() proxy.PropByte {
	return &proxy.ImplPropByte{
		Impl: v,
		Name: "IcvLength",
	}
}

// property CipherSuite t

func (v *interfaceDeviceMacsec) CipherSuite() proxy.PropUint64 {
	return &proxy.ImplPropUint64{
		Impl: v,
		Name: "CipherSuite",
	}
}

// property Window u

func (v *interfaceDeviceMacsec) Window() proxy.PropUint32 {
	return &proxy.ImplPropUint32{
		Impl: v,
		Name: "Window",
	}
}

// property EncodingSa y

func (v *interfaceDeviceMacsec) EncodingSa() proxy.PropByte {
	return &proxy.ImplPropByte{
		Impl: v,
		Name: "EncodingSa",
	}
}

// property Validation s

func (v *interfaceDeviceMacsec) Validation() proxy.PropString {
	return &proxy.ImplPropString{
		Impl: v,
		Name: "Validation",
	}
}

// property Encrypt b

func (v *interfaceDeviceMacsec) Encrypt() proxy.PropBool {
	return &proxy.ImplPropBool{
		Impl: v,
		Name: "Encrypt",
	}
}

// property Protect b

func (v *interfaceDeviceMacsec) Protect() proxy.PropBool {
	return &proxy.ImplPropBool{
		Impl: v,
		Name: "Protect",
	}
}

// property IncludeSci b

func (v *interfaceDeviceMacsec) IncludeSci() proxy.PropBool {
	return &proxy.ImplPropBool{
		Impl: v,
		Name: "IncludeSci",
	}
}

// property Es b

func (v *interfaceDeviceMacsec) Es() proxy.PropBool {
	return &proxy.ImplPropBool{
		Impl: v,
		Name: "Es",
	}
}

// property Scb b

func (v *interfaceDeviceMacsec) Scb() proxy.PropBool {
	return &proxy.ImplPropBool{
		Impl: v,
		Name: "Scb",
	}
}

// property ReplayProtect b

func (v *interfaceDeviceMacsec) ReplayProtect() proxy.PropBool {
	return &proxy.ImplPropBool{
		Impl: v,
		Name: "ReplayProtect",
	}
}

func (obj *objectDevice) Macvlan() deviceMacvlan {
	return &obj.interfaceDeviceMacvlan
}

type deviceMacvlan interface {
	ConnectSignalPropertiesChanged(cb func(properties map[string]dbus.Variant)) (dbusutil.SignalHandlerId, error)
	Parent() proxy.PropObjectPath
	Mode() proxy.PropString
	NoPromisc() proxy.PropBool
	Tap() proxy.PropBool
}

type interfaceDeviceMacvlan struct{}

func (v *interfaceDeviceMacvlan) GetObject_() *proxy.ImplObject {
	return (*proxy.ImplObject)(unsafe.Pointer(v))
}

func (*interfaceDeviceMacvlan) GetInterfaceName_() string {
	return "org.freedesktop.NetworkManager.Device.Macvlan"
}

// signal PropertiesChanged

func (v *interfaceDeviceMacvlan) ConnectSignalPropertiesChanged(cb func(properties map[string]dbus.Variant)) (dbusutil.SignalHandlerId, error) {
	if cb == nil {
		return 0, errors.New("nil callback")
	}
	obj := v.GetObject_()
	rule := fmt.Sprintf(
		"type='signal',interface='%s',member='%s',path='%s',sender='%s'",
		v.GetInterfaceName_(), "PropertiesChanged", obj.Path_(), obj.ServiceName_())

	sigRule := &dbusutil.SignalRule{
		Path: obj.Path_(),
		Name: v.GetInterfaceName_() + ".PropertiesChanged",
	}
	handlerFunc := func(sig *dbus.Signal) {
		var properties map[string]dbus.Variant
		err := dbus.Store(sig.Body, &properties)
		if err == nil {
			cb(properties)
		}
	}

	return obj.ConnectSignal_(rule, sigRule, handlerFunc)
}

// property Parent o

func (v *interfaceDeviceMacvlan) Parent() proxy.PropObjectPath {
	return &proxy.ImplPropObjectPath{
		Impl: v,
		Name: "Parent",
	}
}

// property Mode s

func (v *interfaceDeviceMacvlan) Mode() proxy.PropString {
	return &proxy.ImplPropString{
		Impl: v,
		Name: "Mode",
	}
}

// property NoPromisc b

func (v *interfaceDeviceMacvlan) NoPromisc() proxy.PropBool {
	return &proxy.ImplPropBool{
		Impl: v,
		Name: "NoPromisc",
	}
}

// property Tap b

func (v *interfaceDeviceMacvlan) Tap() proxy.PropBool {
	return &proxy.ImplPropBool{
		Impl: v,
		Name: "Tap",
	}
}

func (obj *objectDevice) Modem() deviceModem {
	return &obj.interfaceDeviceModem
}

type deviceModem interface {
	ConnectSignalPropertiesChanged(cb func(properties map[string]dbus.Variant)) (dbusutil.SignalHandlerId, error)
	ModemCapabilities() proxy.PropUint32
	CurrentCapabilities() proxy.PropUint32
}

type interfaceDeviceModem struct{}

func (v *interfaceDeviceModem) GetObject_() *proxy.ImplObject {
	return (*proxy.ImplObject)(unsafe.Pointer(v))
}

func (*interfaceDeviceModem) GetInterfaceName_() string {
	return "org.freedesktop.NetworkManager.Device.Modem"
}

// signal PropertiesChanged

func (v *interfaceDeviceModem) ConnectSignalPropertiesChanged(cb func(properties map[string]dbus.Variant)) (dbusutil.SignalHandlerId, error) {
	if cb == nil {
		return 0, errors.New("nil callback")
	}
	obj := v.GetObject_()
	rule := fmt.Sprintf(
		"type='signal',interface='%s',member='%s',path='%s',sender='%s'",
		v.GetInterfaceName_(), "PropertiesChanged", obj.Path_(), obj.ServiceName_())

	sigRule := &dbusutil.SignalRule{
		Path: obj.Path_(),
		Name: v.GetInterfaceName_() + ".PropertiesChanged",
	}
	handlerFunc := func(sig *dbus.Signal) {
		var properties map[string]dbus.Variant
		err := dbus.Store(sig.Body, &properties)
		if err == nil {
			cb(properties)
		}
	}

	return obj.ConnectSignal_(rule, sigRule, handlerFunc)
}

// property ModemCapabilities u

func (v *interfaceDeviceModem) ModemCapabilities() proxy.PropUint32 {
	return &proxy.ImplPropUint32{
		Impl: v,
		Name: "ModemCapabilities",
	}
}

// property CurrentCapabilities u

func (v *interfaceDeviceModem) CurrentCapabilities() proxy.PropUint32 {
	return &proxy.ImplPropUint32{
		Impl: v,
		Name: "CurrentCapabilities",
	}
}

func (obj *objectDevice) OlpcMesh() deviceOlpcMesh {
	return &obj.interfaceDeviceOlpcMesh
}

type deviceOlpcMesh interface {
	ConnectSignalPropertiesChanged(cb func(properties map[string]dbus.Variant)) (dbusutil.SignalHandlerId, error)
	HwAddress() proxy.PropString
	Companion() proxy.PropObjectPath
	ActiveChannel() proxy.PropUint32
}

type interfaceDeviceOlpcMesh struct{}

func (v *interfaceDeviceOlpcMesh) GetObject_() *proxy.ImplObject {
	return (*proxy.ImplObject)(unsafe.Pointer(v))
}

func (*interfaceDeviceOlpcMesh) GetInterfaceName_() string {
	return "org.freedesktop.NetworkManager.Device.OlpcMesh"
}

// signal PropertiesChanged

func (v *interfaceDeviceOlpcMesh) ConnectSignalPropertiesChanged(cb func(properties map[string]dbus.Variant)) (dbusutil.SignalHandlerId, error) {
	if cb == nil {
		return 0, errors.New("nil callback")
	}
	obj := v.GetObject_()
	rule := fmt.Sprintf(
		"type='signal',interface='%s',member='%s',path='%s',sender='%s'",
		v.GetInterfaceName_(), "PropertiesChanged", obj.Path_(), obj.ServiceName_())

	sigRule := &dbusutil.SignalRule{
		Path: obj.Path_(),
		Name: v.GetInterfaceName_() + ".PropertiesChanged",
	}
	handlerFunc := func(sig *dbus.Signal) {
		var properties map[string]dbus.Variant
		err := dbus.Store(sig.Body, &properties)
		if err == nil {
			cb(properties)
		}
	}

	return obj.ConnectSignal_(rule, sigRule, handlerFunc)
}

// property HwAddress s

func (v *interfaceDeviceOlpcMesh) HwAddress() proxy.PropString {
	return &proxy.ImplPropString{
		Impl: v,
		Name: "HwAddress",
	}
}

// property Companion o

func (v *interfaceDeviceOlpcMesh) Companion() proxy.PropObjectPath {
	return &proxy.ImplPropObjectPath{
		Impl: v,
		Name: "Companion",
	}
}

// property ActiveChannel u

func (v *interfaceDeviceOlpcMesh) ActiveChannel() proxy.PropUint32 {
	return &proxy.ImplPropUint32{
		Impl: v,
		Name: "ActiveChannel",
	}
}

func (obj *objectDevice) Statistics() deviceStatistics {
	return &obj.interfaceDeviceStatistics
}

type deviceStatistics interface {
	ConnectSignalPropertiesChanged(cb func(properties map[string]dbus.Variant)) (dbusutil.SignalHandlerId, error)
	RefreshRateMs() proxy.PropUint32
	TxBytes() proxy.PropUint64
	RxBytes() proxy.PropUint64
}

type interfaceDeviceStatistics struct{}

func (v *interfaceDeviceStatistics) GetObject_() *proxy.ImplObject {
	return (*proxy.ImplObject)(unsafe.Pointer(v))
}

func (*interfaceDeviceStatistics) GetInterfaceName_() string {
	return "org.freedesktop.NetworkManager.Device.Statistics"
}

// signal PropertiesChanged

func (v *interfaceDeviceStatistics) ConnectSignalPropertiesChanged(cb func(properties map[string]dbus.Variant)) (dbusutil.SignalHandlerId, error) {
	if cb == nil {
		return 0, errors.New("nil callback")
	}
	obj := v.GetObject_()
	rule := fmt.Sprintf(
		"type='signal',interface='%s',member='%s',path='%s',sender='%s'",
		v.GetInterfaceName_(), "PropertiesChanged", obj.Path_(), obj.ServiceName_())

	sigRule := &dbusutil.SignalRule{
		Path: obj.Path_(),
		Name: v.GetInterfaceName_() + ".PropertiesChanged",
	}
	handlerFunc := func(sig *dbus.Signal) {
		var properties map[string]dbus.Variant
		err := dbus.Store(sig.Body, &properties)
		if err == nil {
			cb(properties)
		}
	}

	return obj.ConnectSignal_(rule, sigRule, handlerFunc)
}

// property RefreshRateMs u

func (v *interfaceDeviceStatistics) RefreshRateMs() proxy.PropUint32 {
	return &proxy.ImplPropUint32{
		Impl: v,
		Name: "RefreshRateMs",
	}
}

// property TxBytes t

func (v *interfaceDeviceStatistics) TxBytes() proxy.PropUint64 {
	return &proxy.ImplPropUint64{
		Impl: v,
		Name: "TxBytes",
	}
}

// property RxBytes t

func (v *interfaceDeviceStatistics) RxBytes() proxy.PropUint64 {
	return &proxy.ImplPropUint64{
		Impl: v,
		Name: "RxBytes",
	}
}

func (obj *objectDevice) Team() deviceTeam {
	return &obj.interfaceDeviceTeam
}

type deviceTeam interface {
	ConnectSignalPropertiesChanged(cb func(properties map[string]dbus.Variant)) (dbusutil.SignalHandlerId, error)
	HwAddress() proxy.PropString
	Carrier() proxy.PropBool
	Slaves() proxy.PropObjectPathArray
	Config() proxy.PropString
}

type interfaceDeviceTeam struct{}

func (v *interfaceDeviceTeam) GetObject_() *proxy.ImplObject {
	return (*proxy.ImplObject)(unsafe.Pointer(v))
}

func (*interfaceDeviceTeam) GetInterfaceName_() string {
	return "org.freedesktop.NetworkManager.Device.Team"
}

// signal PropertiesChanged

func (v *interfaceDeviceTeam) ConnectSignalPropertiesChanged(cb func(properties map[string]dbus.Variant)) (dbusutil.SignalHandlerId, error) {
	if cb == nil {
		return 0, errors.New("nil callback")
	}
	obj := v.GetObject_()
	rule := fmt.Sprintf(
		"type='signal',interface='%s',member='%s',path='%s',sender='%s'",
		v.GetInterfaceName_(), "PropertiesChanged", obj.Path_(), obj.ServiceName_())

	sigRule := &dbusutil.SignalRule{
		Path: obj.Path_(),
		Name: v.GetInterfaceName_() + ".PropertiesChanged",
	}
	handlerFunc := func(sig *dbus.Signal) {
		var properties map[string]dbus.Variant
		err := dbus.Store(sig.Body, &properties)
		if err == nil {
			cb(properties)
		}
	}

	return obj.ConnectSignal_(rule, sigRule, handlerFunc)
}

// property HwAddress s

func (v *interfaceDeviceTeam) HwAddress() proxy.PropString {
	return &proxy.ImplPropString{
		Impl: v,
		Name: "HwAddress",
	}
}

// property Carrier b

func (v *interfaceDeviceTeam) Carrier() proxy.PropBool {
	return &proxy.ImplPropBool{
		Impl: v,
		Name: "Carrier",
	}
}

// property Slaves ao

func (v *interfaceDeviceTeam) Slaves() proxy.PropObjectPathArray {
	return &proxy.ImplPropObjectPathArray{
		Impl: v,
		Name: "Slaves",
	}
}

// property Config s

func (v *interfaceDeviceTeam) Config() proxy.PropString {
	return &proxy.ImplPropString{
		Impl: v,
		Name: "Config",
	}
}

func (obj *objectDevice) Tun() deviceTun {
	return &obj.interfaceDeviceTun
}

type deviceTun interface {
	ConnectSignalPropertiesChanged(cb func(properties map[string]dbus.Variant)) (dbusutil.SignalHandlerId, error)
	Owner() proxy.PropInt64
	Group() proxy.PropInt64
	Mode() proxy.PropString
	NoPi() proxy.PropBool
	VnetHdr() proxy.PropBool
	MultiQueue() proxy.PropBool
	HwAddress() proxy.PropString
}

type interfaceDeviceTun struct{}

func (v *interfaceDeviceTun) GetObject_() *proxy.ImplObject {
	return (*proxy.ImplObject)(unsafe.Pointer(v))
}

func (*interfaceDeviceTun) GetInterfaceName_() string {
	return "org.freedesktop.NetworkManager.Device.Tun"
}

// signal PropertiesChanged

func (v *interfaceDeviceTun) ConnectSignalPropertiesChanged(cb func(properties map[string]dbus.Variant)) (dbusutil.SignalHandlerId, error) {
	if cb == nil {
		return 0, errors.New("nil callback")
	}
	obj := v.GetObject_()
	rule := fmt.Sprintf(
		"type='signal',interface='%s',member='%s',path='%s',sender='%s'",
		v.GetInterfaceName_(), "PropertiesChanged", obj.Path_(), obj.ServiceName_())

	sigRule := &dbusutil.SignalRule{
		Path: obj.Path_(),
		Name: v.GetInterfaceName_() + ".PropertiesChanged",
	}
	handlerFunc := func(sig *dbus.Signal) {
		var properties map[string]dbus.Variant
		err := dbus.Store(sig.Body, &properties)
		if err == nil {
			cb(properties)
		}
	}

	return obj.ConnectSignal_(rule, sigRule, handlerFunc)
}

// property Owner x

func (v *interfaceDeviceTun) Owner() proxy.PropInt64 {
	return &proxy.ImplPropInt64{
		Impl: v,
		Name: "Owner",
	}
}

// property Group x

func (v *interfaceDeviceTun) Group() proxy.PropInt64 {
	return &proxy.ImplPropInt64{
		Impl: v,
		Name: "Group",
	}
}

// property Mode s

func (v *interfaceDeviceTun) Mode() proxy.PropString {
	return &proxy.ImplPropString{
		Impl: v,
		Name: "Mode",
	}
}

// property NoPi b

func (v *interfaceDeviceTun) NoPi() proxy.PropBool {
	return &proxy.ImplPropBool{
		Impl: v,
		Name: "NoPi",
	}
}

// property VnetHdr b

func (v *interfaceDeviceTun) VnetHdr() proxy.PropBool {
	return &proxy.ImplPropBool{
		Impl: v,
		Name: "VnetHdr",
	}
}

// property MultiQueue b

func (v *interfaceDeviceTun) MultiQueue() proxy.PropBool {
	return &proxy.ImplPropBool{
		Impl: v,
		Name: "MultiQueue",
	}
}

// property HwAddress s

func (v *interfaceDeviceTun) HwAddress() proxy.PropString {
	return &proxy.ImplPropString{
		Impl: v,
		Name: "HwAddress",
	}
}

func (obj *objectDevice) Veth() deviceVeth {
	return &obj.interfaceDeviceVeth
}

type deviceVeth interface {
	ConnectSignalPropertiesChanged(cb func(properties map[string]dbus.Variant)) (dbusutil.SignalHandlerId, error)
	Peer() proxy.PropObjectPath
}

type interfaceDeviceVeth struct{}

func (v *interfaceDeviceVeth) GetObject_() *proxy.ImplObject {
	return (*proxy.ImplObject)(unsafe.Pointer(v))
}

func (*interfaceDeviceVeth) GetInterfaceName_() string {
	return "org.freedesktop.NetworkManager.Device.Veth"
}

// signal PropertiesChanged

func (v *interfaceDeviceVeth) ConnectSignalPropertiesChanged(cb func(properties map[string]dbus.Variant)) (dbusutil.SignalHandlerId, error) {
	if cb == nil {
		return 0, errors.New("nil callback")
	}
	obj := v.GetObject_()
	rule := fmt.Sprintf(
		"type='signal',interface='%s',member='%s',path='%s',sender='%s'",
		v.GetInterfaceName_(), "PropertiesChanged", obj.Path_(), obj.ServiceName_())

	sigRule := &dbusutil.SignalRule{
		Path: obj.Path_(),
		Name: v.GetInterfaceName_() + ".PropertiesChanged",
	}
	handlerFunc := func(sig *dbus.Signal) {
		var properties map[string]dbus.Variant
		err := dbus.Store(sig.Body, &properties)
		if err == nil {
			cb(properties)
		}
	}

	return obj.ConnectSignal_(rule, sigRule, handlerFunc)
}

// property Peer o

func (v *interfaceDeviceVeth) Peer() proxy.PropObjectPath {
	return &proxy.ImplPropObjectPath{
		Impl: v,
		Name: "Peer",
	}
}

func (obj *objectDevice) Vlan() deviceVlan {
	return &obj.interfaceDeviceVlan
}

type deviceVlan interface {
	ConnectSignalPropertiesChanged(cb func(properties map[string]dbus.Variant)) (dbusutil.SignalHandlerId, error)
	HwAddress() proxy.PropString
	Carrier() proxy.PropBool
	Parent() proxy.PropObjectPath
	VlanId() proxy.PropUint32
}

type interfaceDeviceVlan struct{}

func (v *interfaceDeviceVlan) GetObject_() *proxy.ImplObject {
	return (*proxy.ImplObject)(unsafe.Pointer(v))
}

func (*interfaceDeviceVlan) GetInterfaceName_() string {
	return "org.freedesktop.NetworkManager.Device.Vlan"
}

// signal PropertiesChanged

func (v *interfaceDeviceVlan) ConnectSignalPropertiesChanged(cb func(properties map[string]dbus.Variant)) (dbusutil.SignalHandlerId, error) {
	if cb == nil {
		return 0, errors.New("nil callback")
	}
	obj := v.GetObject_()
	rule := fmt.Sprintf(
		"type='signal',interface='%s',member='%s',path='%s',sender='%s'",
		v.GetInterfaceName_(), "PropertiesChanged", obj.Path_(), obj.ServiceName_())

	sigRule := &dbusutil.SignalRule{
		Path: obj.Path_(),
		Name: v.GetInterfaceName_() + ".PropertiesChanged",
	}
	handlerFunc := func(sig *dbus.Signal) {
		var properties map[string]dbus.Variant
		err := dbus.Store(sig.Body, &properties)
		if err == nil {
			cb(properties)
		}
	}

	return obj.ConnectSignal_(rule, sigRule, handlerFunc)
}

// property HwAddress s

func (v *interfaceDeviceVlan) HwAddress() proxy.PropString {
	return &proxy.ImplPropString{
		Impl: v,
		Name: "HwAddress",
	}
}

// property Carrier b

func (v *interfaceDeviceVlan) Carrier() proxy.PropBool {
	return &proxy.ImplPropBool{
		Impl: v,
		Name: "Carrier",
	}
}

// property Parent o

func (v *interfaceDeviceVlan) Parent() proxy.PropObjectPath {
	return &proxy.ImplPropObjectPath{
		Impl: v,
		Name: "Parent",
	}
}

// property VlanId u

func (v *interfaceDeviceVlan) VlanId() proxy.PropUint32 {
	return &proxy.ImplPropUint32{
		Impl: v,
		Name: "VlanId",
	}
}

func (obj *objectDevice) Vxlan() deviceVxlan {
	return &obj.interfaceDeviceVxlan
}

type deviceVxlan interface {
	ConnectSignalPropertiesChanged(cb func(properties map[string]dbus.Variant)) (dbusutil.SignalHandlerId, error)
	Parent() proxy.PropObjectPath
	HwAddress() proxy.PropString
	Id() proxy.PropUint32
	Group() proxy.PropString
	Local() proxy.PropString
	Tos() proxy.PropByte
	Ttl() proxy.PropByte
	Learning() proxy.PropBool
	Ageing() proxy.PropUint32
	Limit() proxy.PropUint32
	DstPort() proxy.PropUint16
	SrcPortMin() proxy.PropUint16
	SrcPortMax() proxy.PropUint16
	Proxy() proxy.PropBool
	Rsc() proxy.PropBool
	L2miss() proxy.PropBool
	L3miss() proxy.PropBool
}

type interfaceDeviceVxlan struct{}

func (v *interfaceDeviceVxlan) GetObject_() *proxy.ImplObject {
	return (*proxy.ImplObject)(unsafe.Pointer(v))
}

func (*interfaceDeviceVxlan) GetInterfaceName_() string {
	return "org.freedesktop.NetworkManager.Device.Vxlan"
}

// signal PropertiesChanged

func (v *interfaceDeviceVxlan) ConnectSignalPropertiesChanged(cb func(properties map[string]dbus.Variant)) (dbusutil.SignalHandlerId, error) {
	if cb == nil {
		return 0, errors.New("nil callback")
	}
	obj := v.GetObject_()
	rule := fmt.Sprintf(
		"type='signal',interface='%s',member='%s',path='%s',sender='%s'",
		v.GetInterfaceName_(), "PropertiesChanged", obj.Path_(), obj.ServiceName_())

	sigRule := &dbusutil.SignalRule{
		Path: obj.Path_(),
		Name: v.GetInterfaceName_() + ".PropertiesChanged",
	}
	handlerFunc := func(sig *dbus.Signal) {
		var properties map[string]dbus.Variant
		err := dbus.Store(sig.Body, &properties)
		if err == nil {
			cb(properties)
		}
	}

	return obj.ConnectSignal_(rule, sigRule, handlerFunc)
}

// property Parent o

func (v *interfaceDeviceVxlan) Parent() proxy.PropObjectPath {
	return &proxy.ImplPropObjectPath{
		Impl: v,
		Name: "Parent",
	}
}

// property HwAddress s

func (v *interfaceDeviceVxlan) HwAddress() proxy.PropString {
	return &proxy.ImplPropString{
		Impl: v,
		Name: "HwAddress",
	}
}

// property Id u

func (v *interfaceDeviceVxlan) Id() proxy.PropUint32 {
	return &proxy.ImplPropUint32{
		Impl: v,
		Name: "Id",
	}
}

// property Group s

func (v *interfaceDeviceVxlan) Group() proxy.PropString {
	return &proxy.ImplPropString{
		Impl: v,
		Name: "Group",
	}
}

// property Local s

func (v *interfaceDeviceVxlan) Local() proxy.PropString {
	return &proxy.ImplPropString{
		Impl: v,
		Name: "Local",
	}
}

// property Tos y

func (v *interfaceDeviceVxlan) Tos() proxy.PropByte {
	return &proxy.ImplPropByte{
		Impl: v,
		Name: "Tos",
	}
}

// property Ttl y

func (v *interfaceDeviceVxlan) Ttl() proxy.PropByte {
	return &proxy.ImplPropByte{
		Impl: v,
		Name: "Ttl",
	}
}

// property Learning b

func (v *interfaceDeviceVxlan) Learning() proxy.PropBool {
	return &proxy.ImplPropBool{
		Impl: v,
		Name: "Learning",
	}
}

// property Ageing u

func (v *interfaceDeviceVxlan) Ageing() proxy.PropUint32 {
	return &proxy.ImplPropUint32{
		Impl: v,
		Name: "Ageing",
	}
}

// property Limit u

func (v *interfaceDeviceVxlan) Limit() proxy.PropUint32 {
	return &proxy.ImplPropUint32{
		Impl: v,
		Name: "Limit",
	}
}

// property DstPort q

func (v *interfaceDeviceVxlan) DstPort() proxy.PropUint16 {
	return &proxy.ImplPropUint16{
		Impl: v,
		Name: "DstPort",
	}
}

// property SrcPortMin q

func (v *interfaceDeviceVxlan) SrcPortMin() proxy.PropUint16 {
	return &proxy.ImplPropUint16{
		Impl: v,
		Name: "SrcPortMin",
	}
}

// property SrcPortMax q

func (v *interfaceDeviceVxlan) SrcPortMax() proxy.PropUint16 {
	return &proxy.ImplPropUint16{
		Impl: v,
		Name: "SrcPortMax",
	}
}

// property Proxy b

func (v *interfaceDeviceVxlan) Proxy() proxy.PropBool {
	return &proxy.ImplPropBool{
		Impl: v,
		Name: "Proxy",
	}
}

// property Rsc b

func (v *interfaceDeviceVxlan) Rsc() proxy.PropBool {
	return &proxy.ImplPropBool{
		Impl: v,
		Name: "Rsc",
	}
}

// property L2miss b

func (v *interfaceDeviceVxlan) L2miss() proxy.PropBool {
	return &proxy.ImplPropBool{
		Impl: v,
		Name: "L2miss",
	}
}

// property L3miss b

func (v *interfaceDeviceVxlan) L3miss() proxy.PropBool {
	return &proxy.ImplPropBool{
		Impl: v,
		Name: "L3miss",
	}
}

func (obj *objectDevice) WiMax() deviceWiMax {
	return &obj.interfaceDeviceWiMax
}

type deviceWiMax interface {
	GoGetNspList(flags dbus.Flags, ch chan *dbus.Call) *dbus.Call
	GetNspList(flags dbus.Flags) ([]dbus.ObjectPath, error)
	ConnectSignalPropertiesChanged(cb func(properties map[string]dbus.Variant)) (dbusutil.SignalHandlerId, error)
	ConnectNspAdded(cb func(nsp dbus.ObjectPath)) (dbusutil.SignalHandlerId, error)
	ConnectNspRemoved(cb func(nsp dbus.ObjectPath)) (dbusutil.SignalHandlerId, error)
	Nsps() proxy.PropObjectPathArray
	HwAddress() proxy.PropString
	CenterFrequency() proxy.PropUint32
	Rssi() proxy.PropInt32
	Cinr() proxy.PropInt32
	TxPower() proxy.PropInt32
	Bsid() proxy.PropString
	ActiveNsp() proxy.PropObjectPath
}

type interfaceDeviceWiMax struct{}

func (v *interfaceDeviceWiMax) GetObject_() *proxy.ImplObject {
	return (*proxy.ImplObject)(unsafe.Pointer(v))
}

func (*interfaceDeviceWiMax) GetInterfaceName_() string {
	return "org.freedesktop.NetworkManager.Device.WiMax"
}

// method GetNspList

func (v *interfaceDeviceWiMax) GoGetNspList(flags dbus.Flags, ch chan *dbus.Call) *dbus.Call {
	return v.GetObject_().Go_(v.GetInterfaceName_()+".GetNspList", flags, ch)
}

func (*interfaceDeviceWiMax) StoreGetNspList(call *dbus.Call) (nsps []dbus.ObjectPath, err error) {
	err = call.Store(&nsps)
	return
}

func (v *interfaceDeviceWiMax) GetNspList(flags dbus.Flags) ([]dbus.ObjectPath, error) {
	return v.StoreGetNspList(
		<-v.GoGetNspList(flags, make(chan *dbus.Call, 1)).Done)
}

// signal PropertiesChanged

func (v *interfaceDeviceWiMax) ConnectSignalPropertiesChanged(cb func(properties map[string]dbus.Variant)) (dbusutil.SignalHandlerId, error) {
	if cb == nil {
		return 0, errors.New("nil callback")
	}
	obj := v.GetObject_()
	rule := fmt.Sprintf(
		"type='signal',interface='%s',member='%s',path='%s',sender='%s'",
		v.GetInterfaceName_(), "PropertiesChanged", obj.Path_(), obj.ServiceName_())

	sigRule := &dbusutil.SignalRule{
		Path: obj.Path_(),
		Name: v.GetInterfaceName_() + ".PropertiesChanged",
	}
	handlerFunc := func(sig *dbus.Signal) {
		var properties map[string]dbus.Variant
		err := dbus.Store(sig.Body, &properties)
		if err == nil {
			cb(properties)
		}
	}

	return obj.ConnectSignal_(rule, sigRule, handlerFunc)
}

// signal NspAdded

func (v *interfaceDeviceWiMax) ConnectNspAdded(cb func(nsp dbus.ObjectPath)) (dbusutil.SignalHandlerId, error) {
	if cb == nil {
		return 0, errors.New("nil callback")
	}
	obj := v.GetObject_()
	rule := fmt.Sprintf(
		"type='signal',interface='%s',member='%s',path='%s',sender='%s'",
		v.GetInterfaceName_(), "NspAdded", obj.Path_(), obj.ServiceName_())

	sigRule := &dbusutil.SignalRule{
		Path: obj.Path_(),
		Name: v.GetInterfaceName_() + ".NspAdded",
	}
	handlerFunc := func(sig *dbus.Signal) {
		var nsp dbus.ObjectPath
		err := dbus.Store(sig.Body, &nsp)
		if err == nil {
			cb(nsp)
		}
	}

	return obj.ConnectSignal_(rule, sigRule, handlerFunc)
}

// signal NspRemoved

func (v *interfaceDeviceWiMax) ConnectNspRemoved(cb func(nsp dbus.ObjectPath)) (dbusutil.SignalHandlerId, error) {
	if cb == nil {
		return 0, errors.New("nil callback")
	}
	obj := v.GetObject_()
	rule := fmt.Sprintf(
		"type='signal',interface='%s',member='%s',path='%s',sender='%s'",
		v.GetInterfaceName_(), "NspRemoved", obj.Path_(), obj.ServiceName_())

	sigRule := &dbusutil.SignalRule{
		Path: obj.Path_(),
		Name: v.GetInterfaceName_() + ".NspRemoved",
	}
	handlerFunc := func(sig *dbus.Signal) {
		var nsp dbus.ObjectPath
		err := dbus.Store(sig.Body, &nsp)
		if err == nil {
			cb(nsp)
		}
	}

	return obj.ConnectSignal_(rule, sigRule, handlerFunc)
}

// property Nsps ao

func (v *interfaceDeviceWiMax) Nsps() proxy.PropObjectPathArray {
	return &proxy.ImplPropObjectPathArray{
		Impl: v,
		Name: "Nsps",
	}
}

// property HwAddress s

func (v *interfaceDeviceWiMax) HwAddress() proxy.PropString {
	return &proxy.ImplPropString{
		Impl: v,
		Name: "HwAddress",
	}
}

// property CenterFrequency u

func (v *interfaceDeviceWiMax) CenterFrequency() proxy.PropUint32 {
	return &proxy.ImplPropUint32{
		Impl: v,
		Name: "CenterFrequency",
	}
}

// property Rssi i

func (v *interfaceDeviceWiMax) Rssi() proxy.PropInt32 {
	return &proxy.ImplPropInt32{
		Impl: v,
		Name: "Rssi",
	}
}

// property Cinr i

func (v *interfaceDeviceWiMax) Cinr() proxy.PropInt32 {
	return &proxy.ImplPropInt32{
		Impl: v,
		Name: "Cinr",
	}
}

// property TxPower i

func (v *interfaceDeviceWiMax) TxPower() proxy.PropInt32 {
	return &proxy.ImplPropInt32{
		Impl: v,
		Name: "TxPower",
	}
}

// property Bsid s

func (v *interfaceDeviceWiMax) Bsid() proxy.PropString {
	return &proxy.ImplPropString{
		Impl: v,
		Name: "Bsid",
	}
}

// property ActiveNsp o

func (v *interfaceDeviceWiMax) ActiveNsp() proxy.PropObjectPath {
	return &proxy.ImplPropObjectPath{
		Impl: v,
		Name: "ActiveNsp",
	}
}

func (obj *objectDevice) Wired() deviceWired {
	return &obj.interfaceDeviceWired
}

type deviceWired interface {
	ConnectSignalPropertiesChanged(cb func(properties map[string]dbus.Variant)) (dbusutil.SignalHandlerId, error)
	HwAddress() proxy.PropString
	PermHwAddress() proxy.PropString
	Speed() proxy.PropUint32
	S390Subchannels() proxy.PropStringArray
	Carrier() proxy.PropBool
}

type interfaceDeviceWired struct{}

func (v *interfaceDeviceWired) GetObject_() *proxy.ImplObject {
	return (*proxy.ImplObject)(unsafe.Pointer(v))
}

func (*interfaceDeviceWired) GetInterfaceName_() string {
	return "org.freedesktop.NetworkManager.Device.Wired"
}

// signal PropertiesChanged

func (v *interfaceDeviceWired) ConnectSignalPropertiesChanged(cb func(properties map[string]dbus.Variant)) (dbusutil.SignalHandlerId, error) {
	if cb == nil {
		return 0, errors.New("nil callback")
	}
	obj := v.GetObject_()
	rule := fmt.Sprintf(
		"type='signal',interface='%s',member='%s',path='%s',sender='%s'",
		v.GetInterfaceName_(), "PropertiesChanged", obj.Path_(), obj.ServiceName_())

	sigRule := &dbusutil.SignalRule{
		Path: obj.Path_(),
		Name: v.GetInterfaceName_() + ".PropertiesChanged",
	}
	handlerFunc := func(sig *dbus.Signal) {
		var properties map[string]dbus.Variant
		err := dbus.Store(sig.Body, &properties)
		if err == nil {
			cb(properties)
		}
	}

	return obj.ConnectSignal_(rule, sigRule, handlerFunc)
}

// property HwAddress s

func (v *interfaceDeviceWired) HwAddress() proxy.PropString {
	return &proxy.ImplPropString{
		Impl: v,
		Name: "HwAddress",
	}
}

// property PermHwAddress s

func (v *interfaceDeviceWired) PermHwAddress() proxy.PropString {
	return &proxy.ImplPropString{
		Impl: v,
		Name: "PermHwAddress",
	}
}

// property Speed u

func (v *interfaceDeviceWired) Speed() proxy.PropUint32 {
	return &proxy.ImplPropUint32{
		Impl: v,
		Name: "Speed",
	}
}

// property S390Subchannels as

func (v *interfaceDeviceWired) S390Subchannels() proxy.PropStringArray {
	return &proxy.ImplPropStringArray{
		Impl: v,
		Name: "S390Subchannels",
	}
}

// property Carrier b

func (v *interfaceDeviceWired) Carrier() proxy.PropBool {
	return &proxy.ImplPropBool{
		Impl: v,
		Name: "Carrier",
	}
}

func (obj *objectDevice) Wireless() deviceWireless {
	return &obj.interfaceDeviceWireless
}

type deviceWireless interface {
	GoGetAccessPoints(flags dbus.Flags, ch chan *dbus.Call) *dbus.Call
	GetAccessPoints(flags dbus.Flags) ([]dbus.ObjectPath, error)
	GoGetAllAccessPoints(flags dbus.Flags, ch chan *dbus.Call) *dbus.Call
	GetAllAccessPoints(flags dbus.Flags) ([]dbus.ObjectPath, error)
	GoRequestScan(flags dbus.Flags, ch chan *dbus.Call, options map[string]dbus.Variant) *dbus.Call
	RequestScan(flags dbus.Flags, options map[string]dbus.Variant) error
	ConnectSignalPropertiesChanged(cb func(properties map[string]dbus.Variant)) (dbusutil.SignalHandlerId, error)
	ConnectAccessPointAdded(cb func(access_point dbus.ObjectPath)) (dbusutil.SignalHandlerId, error)
	ConnectAccessPointRemoved(cb func(access_point dbus.ObjectPath)) (dbusutil.SignalHandlerId, error)
	HwAddress() proxy.PropString
	PermHwAddress() proxy.PropString
	Mode() proxy.PropUint32
	Bitrate() proxy.PropUint32
	AccessPoints() proxy.PropObjectPathArray
	ActiveAccessPoint() proxy.PropObjectPath
	LastScan() proxy.PropInt64
	WirelessCapabilities() proxy.PropUint32
}

type interfaceDeviceWireless struct{}

func (v *interfaceDeviceWireless) GetObject_() *proxy.ImplObject {
	return (*proxy.ImplObject)(unsafe.Pointer(v))
}

func (*interfaceDeviceWireless) GetInterfaceName_() string {
	return "org.freedesktop.NetworkManager.Device.Wireless"
}

// method GetAccessPoints

func (v *interfaceDeviceWireless) GoGetAccessPoints(flags dbus.Flags, ch chan *dbus.Call) *dbus.Call {
	return v.GetObject_().Go_(v.GetInterfaceName_()+".GetAccessPoints", flags, ch)
}

func (*interfaceDeviceWireless) StoreGetAccessPoints(call *dbus.Call) (access_points []dbus.ObjectPath, err error) {
	err = call.Store(&access_points)
	return
}

func (v *interfaceDeviceWireless) GetAccessPoints(flags dbus.Flags) ([]dbus.ObjectPath, error) {
	return v.StoreGetAccessPoints(
		<-v.GoGetAccessPoints(flags, make(chan *dbus.Call, 1)).Done)
}

// method GetAllAccessPoints

func (v *interfaceDeviceWireless) GoGetAllAccessPoints(flags dbus.Flags, ch chan *dbus.Call) *dbus.Call {
	return v.GetObject_().Go_(v.GetInterfaceName_()+".GetAllAccessPoints", flags, ch)
}

func (*interfaceDeviceWireless) StoreGetAllAccessPoints(call *dbus.Call) (access_points []dbus.ObjectPath, err error) {
	err = call.Store(&access_points)
	return
}

func (v *interfaceDeviceWireless) GetAllAccessPoints(flags dbus.Flags) ([]dbus.ObjectPath, error) {
	return v.StoreGetAllAccessPoints(
		<-v.GoGetAllAccessPoints(flags, make(chan *dbus.Call, 1)).Done)
}

// method RequestScan

func (v *interfaceDeviceWireless) GoRequestScan(flags dbus.Flags, ch chan *dbus.Call, options map[string]dbus.Variant) *dbus.Call {
	return v.GetObject_().Go_(v.GetInterfaceName_()+".RequestScan", flags, ch, options)
}

func (v *interfaceDeviceWireless) RequestScan(flags dbus.Flags, options map[string]dbus.Variant) error {
	return (<-v.GoRequestScan(flags, make(chan *dbus.Call, 1), options).Done).Err
}

// signal PropertiesChanged

func (v *interfaceDeviceWireless) ConnectSignalPropertiesChanged(cb func(properties map[string]dbus.Variant)) (dbusutil.SignalHandlerId, error) {
	if cb == nil {
		return 0, errors.New("nil callback")
	}
	obj := v.GetObject_()
	rule := fmt.Sprintf(
		"type='signal',interface='%s',member='%s',path='%s',sender='%s'",
		v.GetInterfaceName_(), "PropertiesChanged", obj.Path_(), obj.ServiceName_())

	sigRule := &dbusutil.SignalRule{
		Path: obj.Path_(),
		Name: v.GetInterfaceName_() + ".PropertiesChanged",
	}
	handlerFunc := func(sig *dbus.Signal) {
		var properties map[string]dbus.Variant
		err := dbus.Store(sig.Body, &properties)
		if err == nil {
			cb(properties)
		}
	}

	return obj.ConnectSignal_(rule, sigRule, handlerFunc)
}

// signal AccessPointAdded

func (v *interfaceDeviceWireless) ConnectAccessPointAdded(cb func(access_point dbus.ObjectPath)) (dbusutil.SignalHandlerId, error) {
	if cb == nil {
		return 0, errors.New("nil callback")
	}
	obj := v.GetObject_()
	rule := fmt.Sprintf(
		"type='signal',interface='%s',member='%s',path='%s',sender='%s'",
		v.GetInterfaceName_(), "AccessPointAdded", obj.Path_(), obj.ServiceName_())

	sigRule := &dbusutil.SignalRule{
		Path: obj.Path_(),
		Name: v.GetInterfaceName_() + ".AccessPointAdded",
	}
	handlerFunc := func(sig *dbus.Signal) {
		var access_point dbus.ObjectPath
		err := dbus.Store(sig.Body, &access_point)
		if err == nil {
			cb(access_point)
		}
	}

	return obj.ConnectSignal_(rule, sigRule, handlerFunc)
}

// signal AccessPointRemoved

func (v *interfaceDeviceWireless) ConnectAccessPointRemoved(cb func(access_point dbus.ObjectPath)) (dbusutil.SignalHandlerId, error) {
	if cb == nil {
		return 0, errors.New("nil callback")
	}
	obj := v.GetObject_()
	rule := fmt.Sprintf(
		"type='signal',interface='%s',member='%s',path='%s',sender='%s'",
		v.GetInterfaceName_(), "AccessPointRemoved", obj.Path_(), obj.ServiceName_())

	sigRule := &dbusutil.SignalRule{
		Path: obj.Path_(),
		Name: v.GetInterfaceName_() + ".AccessPointRemoved",
	}
	handlerFunc := func(sig *dbus.Signal) {
		var access_point dbus.ObjectPath
		err := dbus.Store(sig.Body, &access_point)
		if err == nil {
			cb(access_point)
		}
	}

	return obj.ConnectSignal_(rule, sigRule, handlerFunc)
}

// property HwAddress s

func (v *interfaceDeviceWireless) HwAddress() proxy.PropString {
	return &proxy.ImplPropString{
		Impl: v,
		Name: "HwAddress",
	}
}

// property PermHwAddress s

func (v *interfaceDeviceWireless) PermHwAddress() proxy.PropString {
	return &proxy.ImplPropString{
		Impl: v,
		Name: "PermHwAddress",
	}
}

// property Mode u

func (v *interfaceDeviceWireless) Mode() proxy.PropUint32 {
	return &proxy.ImplPropUint32{
		Impl: v,
		Name: "Mode",
	}
}

// property Bitrate u

func (v *interfaceDeviceWireless) Bitrate() proxy.PropUint32 {
	return &proxy.ImplPropUint32{
		Impl: v,
		Name: "Bitrate",
	}
}

// property AccessPoints ao

func (v *interfaceDeviceWireless) AccessPoints() proxy.PropObjectPathArray {
	return &proxy.ImplPropObjectPathArray{
		Impl: v,
		Name: "AccessPoints",
	}
}

// property ActiveAccessPoint o

func (v *interfaceDeviceWireless) ActiveAccessPoint() proxy.PropObjectPath {
	return &proxy.ImplPropObjectPath{
		Impl: v,
		Name: "ActiveAccessPoint",
	}
}

// property LastScan x

func (v *interfaceDeviceWireless) LastScan() proxy.PropInt64 {
	return &proxy.ImplPropInt64{
		Impl: v,
		Name: "LastScan",
	}
}

// property WirelessCapabilities u

func (v *interfaceDeviceWireless) WirelessCapabilities() proxy.PropUint32 {
	return &proxy.ImplPropUint32{
		Impl: v,
		Name: "WirelessCapabilities",
	}
}

type WiMaxNsp interface {
	wiMaxNsp // interface org.freedesktop.NetworkManager.WiMax.Nsp
	proxy.Object
}

type objectWiMaxNsp struct {
	interfaceWiMaxNsp // interface org.freedesktop.NetworkManager.WiMax.Nsp
	proxy.ImplObject
}

func NewWiMaxNsp(conn *dbus.Conn, path dbus.ObjectPath) (WiMaxNsp, error) {
	if !path.IsValid() {
		return nil, errors.New("path is invalid")
	}
	obj := new(objectWiMaxNsp)
	obj.ImplObject.Init_(conn, "org.freedesktop.NetworkManager", path)
	return obj, nil
}

type wiMaxNsp interface {
	ConnectSignalPropertiesChanged(cb func(properties map[string]dbus.Variant)) (dbusutil.SignalHandlerId, error)
	Name() proxy.PropString
	SignalQuality() proxy.PropUint32
	NetworkType() proxy.PropUint32
}

type interfaceWiMaxNsp struct{}

func (v *interfaceWiMaxNsp) GetObject_() *proxy.ImplObject {
	return (*proxy.ImplObject)(unsafe.Pointer(v))
}

func (*interfaceWiMaxNsp) GetInterfaceName_() string {
	return "org.freedesktop.NetworkManager.WiMax.Nsp"
}

// signal PropertiesChanged

func (v *interfaceWiMaxNsp) ConnectSignalPropertiesChanged(cb func(properties map[string]dbus.Variant)) (dbusutil.SignalHandlerId, error) {
	if cb == nil {
		return 0, errors.New("nil callback")
	}
	obj := v.GetObject_()
	rule := fmt.Sprintf(
		"type='signal',interface='%s',member='%s',path='%s',sender='%s'",
		v.GetInterfaceName_(), "PropertiesChanged", obj.Path_(), obj.ServiceName_())

	sigRule := &dbusutil.SignalRule{
		Path: obj.Path_(),
		Name: v.GetInterfaceName_() + ".PropertiesChanged",
	}
	handlerFunc := func(sig *dbus.Signal) {
		var properties map[string]dbus.Variant
		err := dbus.Store(sig.Body, &properties)
		if err == nil {
			cb(properties)
		}
	}

	return obj.ConnectSignal_(rule, sigRule, handlerFunc)
}

// property Name s

func (v *interfaceWiMaxNsp) Name() proxy.PropString {
	return &proxy.ImplPropString{
		Impl: v,
		Name: "Name",
	}
}

// property SignalQuality u

func (v *interfaceWiMaxNsp) SignalQuality() proxy.PropUint32 {
	return &proxy.ImplPropUint32{
		Impl: v,
		Name: "SignalQuality",
	}
}

// property NetworkType u

func (v *interfaceWiMaxNsp) NetworkType() proxy.PropUint32 {
	return &proxy.ImplPropUint32{
		Impl: v,
		Name: "NetworkType",
	}
}

type PropMapStringVariant interface {
	Get(flags dbus.Flags) (value map[string]dbus.Variant, err error)
	Set(flags dbus.Flags, value map[string]dbus.Variant) error
	ConnectChanged(cb func(hasValue bool, value map[string]dbus.Variant)) error
}

type implPropMapStringVariant struct {
	Impl proxy.Implementer
	Name string
}

func (p implPropMapStringVariant) Get(flags dbus.Flags) (value map[string]dbus.Variant, err error) {
	err = p.Impl.GetObject_().GetProperty_(flags, p.Impl.GetInterfaceName_(),
		p.Name, &value)
	return
}

func (p implPropMapStringVariant) Set(flags dbus.Flags, value map[string]dbus.Variant) error {
	return p.Impl.GetObject_().SetProperty_(flags, p.Impl.GetInterfaceName_(), p.Name, value)
}

func (p implPropMapStringVariant) ConnectChanged(cb func(hasValue bool, value map[string]dbus.Variant)) error {
	if cb == nil {
		return errors.New("nil callback")
	}
	cb0 := func(hasValue bool, value interface{}) {
		if hasValue {
			var v map[string]dbus.Variant
			err := dbus.Store([]interface{}{value}, &v)
			if err != nil {
				return
			}
			cb(true, v)
		} else {
			cb(false, nil)
		}
	}
	return p.Impl.GetObject_().ConnectPropertyChanged_(p.Impl.GetInterfaceName_(),
		p.Name, cb0)
}

type PropMapSVSlice interface {
	Get(flags dbus.Flags) (value []map[string]dbus.Variant, err error)
	Set(flags dbus.Flags, value []map[string]dbus.Variant) error
	ConnectChanged(cb func(hasValue bool, value []map[string]dbus.Variant)) error
}

type implPropMapSVSlice struct {
	Impl proxy.Implementer
	Name string
}

func (p implPropMapSVSlice) Get(flags dbus.Flags) (value []map[string]dbus.Variant, err error) {
	err = p.Impl.GetObject_().GetProperty_(flags, p.Impl.GetInterfaceName_(),
		p.Name, &value)
	return
}

func (p implPropMapSVSlice) Set(flags dbus.Flags, value []map[string]dbus.Variant) error {
	return p.Impl.GetObject_().SetProperty_(flags, p.Impl.GetInterfaceName_(), p.Name, value)
}

func (p implPropMapSVSlice) ConnectChanged(cb func(hasValue bool, value []map[string]dbus.Variant)) error {
	if cb == nil {
		return errors.New("nil callback")
	}
	cb0 := func(hasValue bool, value interface{}) {
		if hasValue {
			var v []map[string]dbus.Variant
			err := dbus.Store([]interface{}{value}, &v)
			if err != nil {
				return
			}
			cb(true, v)
		} else {
			cb(false, nil)
		}
	}
	return p.Impl.GetObject_().ConnectPropertyChanged_(p.Impl.GetInterfaceName_(),
		p.Name, cb0)
}

type PropUint32SliceSlice interface {
	Get(flags dbus.Flags) (value [][]uint32, err error)
	Set(flags dbus.Flags, value [][]uint32) error
	ConnectChanged(cb func(hasValue bool, value [][]uint32)) error
}

type implPropUint32SliceSlice struct {
	Impl proxy.Implementer
	Name string
}

func (p implPropUint32SliceSlice) Get(flags dbus.Flags) (value [][]uint32, err error) {
	err = p.Impl.GetObject_().GetProperty_(flags, p.Impl.GetInterfaceName_(),
		p.Name, &value)
	return
}

func (p implPropUint32SliceSlice) Set(flags dbus.Flags, value [][]uint32) error {
	return p.Impl.GetObject_().SetProperty_(flags, p.Impl.GetInterfaceName_(), p.Name, value)
}

func (p implPropUint32SliceSlice) ConnectChanged(cb func(hasValue bool, value [][]uint32)) error {
	if cb == nil {
		return errors.New("nil callback")
	}
	cb0 := func(hasValue bool, value interface{}) {
		if hasValue {
			var v [][]uint32
			err := dbus.Store([]interface{}{value}, &v)
			if err != nil {
				return
			}
			cb(true, v)
		} else {
			cb(false, nil)
		}
	}
	return p.Impl.GetObject_().ConnectPropertyChanged_(p.Impl.GetInterfaceName_(),
		p.Name, cb0)
}
