// Code generated by "./generator ./system/org.freedesktop.modemmanager1"; DO NOT EDIT.

// SPDX-FileCopyrightText: 2018 - 2023 UnionTech Software Technology Co., Ltd.
//
// SPDX-License-Identifier: GPL-3.0-or-later
package modemmanager1

import (
	"errors"
	"fmt"
	"unsafe"

	"github.com/godbus/dbus/v5"
	"github.com/linuxdeepin/go-dbus-factory/object_manager"
	"github.com/linuxdeepin/go-lib/dbusutil"
	"github.com/linuxdeepin/go-lib/dbusutil/proxy"
)

type Manager interface {
	ObjectManager() object_manager.ObjectManager // interface org.freedesktop.DBus.ObjectManager
	ModemManager1() manager                      // interface org.freedesktop.ModemManager1
	proxy.Object
}

type objectManager struct {
	object_manager.InterfaceObjectManager // interface org.freedesktop.DBus.ObjectManager
	interfaceManager                      // interface org.freedesktop.ModemManager1
	proxy.ImplObject
}

func NewManager(conn *dbus.Conn) Manager {
	obj := new(objectManager)
	obj.ImplObject.Init_(conn, "org.freedesktop.ModemManager1", "/org/freedesktop/ModemManager1")
	return obj
}

func (obj *objectManager) ObjectManager() object_manager.ObjectManager {
	return &obj.InterfaceObjectManager
}

func (obj *objectManager) ModemManager1() manager {
	return &obj.interfaceManager
}

type manager interface {
	GoScanDevices(flags dbus.Flags, ch chan *dbus.Call) *dbus.Call
	ScanDevices(flags dbus.Flags) error
	GoSetLogging(flags dbus.Flags, ch chan *dbus.Call, level string) *dbus.Call
	SetLogging(flags dbus.Flags, level string) error
}

type interfaceManager struct{}

func (v *interfaceManager) GetObject_() *proxy.ImplObject {
	return (*proxy.ImplObject)(unsafe.Pointer(v))
}

func (*interfaceManager) GetInterfaceName_() string {
	return "org.freedesktop.ModemManager1"
}

// method ScanDevices

func (v *interfaceManager) GoScanDevices(flags dbus.Flags, ch chan *dbus.Call) *dbus.Call {
	return v.GetObject_().Go_(v.GetInterfaceName_()+".ScanDevices", flags, ch)
}

func (v *interfaceManager) ScanDevices(flags dbus.Flags) error {
	return (<-v.GoScanDevices(flags, make(chan *dbus.Call, 1)).Done).Err
}

// method SetLogging

func (v *interfaceManager) GoSetLogging(flags dbus.Flags, ch chan *dbus.Call, level string) *dbus.Call {
	return v.GetObject_().Go_(v.GetInterfaceName_()+".SetLogging", flags, ch, level)
}

func (v *interfaceManager) SetLogging(flags dbus.Flags, level string) error {
	return (<-v.GoSetLogging(flags, make(chan *dbus.Call, 1), level).Done).Err
}

type Modem interface {
	Modem() modem                 // interface org.freedesktop.ModemManager1.Modem
	Firmware() modemFirmware      // interface org.freedesktop.ModemManager1.Modem.Firmware
	Location() modemLocation      // interface org.freedesktop.ModemManager1.Modem.Location
	Messaging() modemMessaging    // interface org.freedesktop.ModemManager1.Modem.Messaging
	Modem3gppUssd() modem3gppUssd // interface org.freedesktop.ModemManager1.Modem.Modem3gpp.Ussd
	Modem3gpp() modem3gpp         // interface org.freedesktop.ModemManager1.Modem.Modem3gpp
	Cdma() modemCdma              // interface org.freedesktop.ModemManager1.Modem.ModemCdma
	Oma() modemOma                // interface org.freedesktop.ModemManager1.Modem.Oma
	Signal() modemSignal          // interface org.freedesktop.ModemManager1.Modem.Signal
	Simple() modemSimple          // interface org.freedesktop.ModemManager1.Modem.Simple
	Time() modemTime              // interface org.freedesktop.ModemManager1.Modem.Time
	Voice() modemVoice            // interface org.freedesktop.ModemManager1.Modem.Voice
	proxy.Object
}

type objectModem struct {
	interfaceModem          // interface org.freedesktop.ModemManager1.Modem
	interfaceModemFirmware  // interface org.freedesktop.ModemManager1.Modem.Firmware
	interfaceModemLocation  // interface org.freedesktop.ModemManager1.Modem.Location
	interfaceModemMessaging // interface org.freedesktop.ModemManager1.Modem.Messaging
	interfaceModem3gppUssd  // interface org.freedesktop.ModemManager1.Modem.Modem3gpp.Ussd
	interfaceModem3gpp      // interface org.freedesktop.ModemManager1.Modem.Modem3gpp
	interfaceModemCdma      // interface org.freedesktop.ModemManager1.Modem.ModemCdma
	interfaceModemOma       // interface org.freedesktop.ModemManager1.Modem.Oma
	interfaceModemSignal    // interface org.freedesktop.ModemManager1.Modem.Signal
	interfaceModemSimple    // interface org.freedesktop.ModemManager1.Modem.Simple
	interfaceModemTime      // interface org.freedesktop.ModemManager1.Modem.Time
	interfaceModemVoice     // interface org.freedesktop.ModemManager1.Modem.Voice
	proxy.ImplObject
}

func NewModem(conn *dbus.Conn, path dbus.ObjectPath) (Modem, error) {
	if !path.IsValid() {
		return nil, errors.New("path is invalid")
	}
	obj := new(objectModem)
	obj.ImplObject.Init_(conn, "org.freedesktop.ModemManager1", path)
	return obj, nil
}

func (obj *objectModem) Modem() modem {
	return &obj.interfaceModem
}

type modem interface {
	GoEnable(flags dbus.Flags, ch chan *dbus.Call, enable bool) *dbus.Call
	Enable(flags dbus.Flags, enable bool) error
	GoListBearers(flags dbus.Flags, ch chan *dbus.Call) *dbus.Call
	ListBearers(flags dbus.Flags) ([]dbus.ObjectPath, error)
	GoCreateBearer(flags dbus.Flags, ch chan *dbus.Call, properties map[string]dbus.Variant) *dbus.Call
	CreateBearer(flags dbus.Flags, properties map[string]dbus.Variant) (dbus.ObjectPath, error)
	GoDeleteBearer(flags dbus.Flags, ch chan *dbus.Call, bearer dbus.ObjectPath) *dbus.Call
	DeleteBearer(flags dbus.Flags, bearer dbus.ObjectPath) error
	GoReset(flags dbus.Flags, ch chan *dbus.Call) *dbus.Call
	Reset(flags dbus.Flags) error
	GoFactoryReset(flags dbus.Flags, ch chan *dbus.Call, code string) *dbus.Call
	FactoryReset(flags dbus.Flags, code string) error
	GoSetPowerState(flags dbus.Flags, ch chan *dbus.Call, state uint32) *dbus.Call
	SetPowerState(flags dbus.Flags, state uint32) error
	GoSetCurrentCapabilities(flags dbus.Flags, ch chan *dbus.Call, capabilities uint32) *dbus.Call
	SetCurrentCapabilities(flags dbus.Flags, capabilities uint32) error
	GoSetCurrentModes(flags dbus.Flags, ch chan *dbus.Call, modes ModemModes) *dbus.Call
	SetCurrentModes(flags dbus.Flags, modes ModemModes) error
	GoSetCurrentBands(flags dbus.Flags, ch chan *dbus.Call, bands []uint32) *dbus.Call
	SetCurrentBands(flags dbus.Flags, bands []uint32) error
	GoCommand(flags dbus.Flags, ch chan *dbus.Call, cmd string, timeout uint32) *dbus.Call
	Command(flags dbus.Flags, cmd string, timeout uint32) (string, error)
	ConnectStateChanged(cb func(old int32, new int32, reason uint32)) (dbusutil.SignalHandlerId, error)
	Sim() proxy.PropObjectPath
	Bearers() proxy.PropObjectPathArray
	SupportedCapabilities() proxy.PropUint32Array
	CurrentCapabilities() proxy.PropUint32
	MaxBearers() proxy.PropUint32
	MaxActiveBearers() proxy.PropUint32
	Manufacturer() proxy.PropString
	Model() proxy.PropString
	Revision() proxy.PropString
	DeviceIdentifier() proxy.PropString
	Device() proxy.PropString
	Drivers() proxy.PropStringArray
	Plugin() proxy.PropString
	PrimaryPort() proxy.PropString
	Ports() PropModemPorts
	EquipmentIdentifier() proxy.PropString
	UnlockRequired() proxy.PropUint32
	UnlockRetries() PropModemUnlockRetries
	State() proxy.PropInt32
	StateFailedReason() proxy.PropUint32
	AccessTechnologies() proxy.PropUint32
	SignalQuality() PropModemSignalQuality
	OwnNumbers() proxy.PropStringArray
	PowerState() proxy.PropUint32
	SupportedModes() PropModemSupportedModes
	CurrentModes() PropModemCurrentModes
	SupportedBands() proxy.PropUint32Array
	CurrentBands() proxy.PropUint32Array
	SupportedIpFamilies() proxy.PropUint32
}

type interfaceModem struct{}

func (v *interfaceModem) GetObject_() *proxy.ImplObject {
	return (*proxy.ImplObject)(unsafe.Pointer(v))
}

func (*interfaceModem) GetInterfaceName_() string {
	return "org.freedesktop.ModemManager1.Modem"
}

// method Enable

func (v *interfaceModem) GoEnable(flags dbus.Flags, ch chan *dbus.Call, enable bool) *dbus.Call {
	return v.GetObject_().Go_(v.GetInterfaceName_()+".Enable", flags, ch, enable)
}

func (v *interfaceModem) Enable(flags dbus.Flags, enable bool) error {
	return (<-v.GoEnable(flags, make(chan *dbus.Call, 1), enable).Done).Err
}

// method ListBearers

func (v *interfaceModem) GoListBearers(flags dbus.Flags, ch chan *dbus.Call) *dbus.Call {
	return v.GetObject_().Go_(v.GetInterfaceName_()+".ListBearers", flags, ch)
}

func (*interfaceModem) StoreListBearers(call *dbus.Call) (bearers []dbus.ObjectPath, err error) {
	err = call.Store(&bearers)
	return
}

func (v *interfaceModem) ListBearers(flags dbus.Flags) ([]dbus.ObjectPath, error) {
	return v.StoreListBearers(
		<-v.GoListBearers(flags, make(chan *dbus.Call, 1)).Done)
}

// method CreateBearer

func (v *interfaceModem) GoCreateBearer(flags dbus.Flags, ch chan *dbus.Call, properties map[string]dbus.Variant) *dbus.Call {
	return v.GetObject_().Go_(v.GetInterfaceName_()+".CreateBearer", flags, ch, properties)
}

func (*interfaceModem) StoreCreateBearer(call *dbus.Call) (path dbus.ObjectPath, err error) {
	err = call.Store(&path)
	return
}

func (v *interfaceModem) CreateBearer(flags dbus.Flags, properties map[string]dbus.Variant) (dbus.ObjectPath, error) {
	return v.StoreCreateBearer(
		<-v.GoCreateBearer(flags, make(chan *dbus.Call, 1), properties).Done)
}

// method DeleteBearer

func (v *interfaceModem) GoDeleteBearer(flags dbus.Flags, ch chan *dbus.Call, bearer dbus.ObjectPath) *dbus.Call {
	return v.GetObject_().Go_(v.GetInterfaceName_()+".DeleteBearer", flags, ch, bearer)
}

func (v *interfaceModem) DeleteBearer(flags dbus.Flags, bearer dbus.ObjectPath) error {
	return (<-v.GoDeleteBearer(flags, make(chan *dbus.Call, 1), bearer).Done).Err
}

// method Reset

func (v *interfaceModem) GoReset(flags dbus.Flags, ch chan *dbus.Call) *dbus.Call {
	return v.GetObject_().Go_(v.GetInterfaceName_()+".Reset", flags, ch)
}

func (v *interfaceModem) Reset(flags dbus.Flags) error {
	return (<-v.GoReset(flags, make(chan *dbus.Call, 1)).Done).Err
}

// method FactoryReset

func (v *interfaceModem) GoFactoryReset(flags dbus.Flags, ch chan *dbus.Call, code string) *dbus.Call {
	return v.GetObject_().Go_(v.GetInterfaceName_()+".FactoryReset", flags, ch, code)
}

func (v *interfaceModem) FactoryReset(flags dbus.Flags, code string) error {
	return (<-v.GoFactoryReset(flags, make(chan *dbus.Call, 1), code).Done).Err
}

// method SetPowerState

func (v *interfaceModem) GoSetPowerState(flags dbus.Flags, ch chan *dbus.Call, state uint32) *dbus.Call {
	return v.GetObject_().Go_(v.GetInterfaceName_()+".SetPowerState", flags, ch, state)
}

func (v *interfaceModem) SetPowerState(flags dbus.Flags, state uint32) error {
	return (<-v.GoSetPowerState(flags, make(chan *dbus.Call, 1), state).Done).Err
}

// method SetCurrentCapabilities

func (v *interfaceModem) GoSetCurrentCapabilities(flags dbus.Flags, ch chan *dbus.Call, capabilities uint32) *dbus.Call {
	return v.GetObject_().Go_(v.GetInterfaceName_()+".SetCurrentCapabilities", flags, ch, capabilities)
}

func (v *interfaceModem) SetCurrentCapabilities(flags dbus.Flags, capabilities uint32) error {
	return (<-v.GoSetCurrentCapabilities(flags, make(chan *dbus.Call, 1), capabilities).Done).Err
}

// method SetCurrentModes

func (v *interfaceModem) GoSetCurrentModes(flags dbus.Flags, ch chan *dbus.Call, modes ModemModes) *dbus.Call {
	return v.GetObject_().Go_(v.GetInterfaceName_()+".SetCurrentModes", flags, ch, modes)
}

func (v *interfaceModem) SetCurrentModes(flags dbus.Flags, modes ModemModes) error {
	return (<-v.GoSetCurrentModes(flags, make(chan *dbus.Call, 1), modes).Done).Err
}

// method SetCurrentBands

func (v *interfaceModem) GoSetCurrentBands(flags dbus.Flags, ch chan *dbus.Call, bands []uint32) *dbus.Call {
	return v.GetObject_().Go_(v.GetInterfaceName_()+".SetCurrentBands", flags, ch, bands)
}

func (v *interfaceModem) SetCurrentBands(flags dbus.Flags, bands []uint32) error {
	return (<-v.GoSetCurrentBands(flags, make(chan *dbus.Call, 1), bands).Done).Err
}

// method Command

func (v *interfaceModem) GoCommand(flags dbus.Flags, ch chan *dbus.Call, cmd string, timeout uint32) *dbus.Call {
	return v.GetObject_().Go_(v.GetInterfaceName_()+".Command", flags, ch, cmd, timeout)
}

func (*interfaceModem) StoreCommand(call *dbus.Call) (response string, err error) {
	err = call.Store(&response)
	return
}

func (v *interfaceModem) Command(flags dbus.Flags, cmd string, timeout uint32) (string, error) {
	return v.StoreCommand(
		<-v.GoCommand(flags, make(chan *dbus.Call, 1), cmd, timeout).Done)
}

// signal StateChanged

func (v *interfaceModem) ConnectStateChanged(cb func(old int32, new int32, reason uint32)) (dbusutil.SignalHandlerId, error) {
	if cb == nil {
		return 0, errors.New("nil callback")
	}
	obj := v.GetObject_()
	rule := fmt.Sprintf(
		"type='signal',interface='%s',member='%s',path='%s',sender='%s'",
		v.GetInterfaceName_(), "StateChanged", obj.Path_(), obj.ServiceName_())

	sigRule := &dbusutil.SignalRule{
		Path: obj.Path_(),
		Name: v.GetInterfaceName_() + ".StateChanged",
	}
	handlerFunc := func(sig *dbus.Signal) {
		var old int32
		var new int32
		var reason uint32
		err := dbus.Store(sig.Body, &old, &new, &reason)
		if err == nil {
			cb(old, new, reason)
		}
	}

	return obj.ConnectSignal_(rule, sigRule, handlerFunc)
}

// property Sim o

func (v *interfaceModem) Sim() proxy.PropObjectPath {
	return &proxy.ImplPropObjectPath{
		Impl: v,
		Name: "Sim",
	}
}

// property Bearers ao

func (v *interfaceModem) Bearers() proxy.PropObjectPathArray {
	return &proxy.ImplPropObjectPathArray{
		Impl: v,
		Name: "Bearers",
	}
}

// property SupportedCapabilities au

func (v *interfaceModem) SupportedCapabilities() proxy.PropUint32Array {
	return &proxy.ImplPropUint32Array{
		Impl: v,
		Name: "SupportedCapabilities",
	}
}

// property CurrentCapabilities u

func (v *interfaceModem) CurrentCapabilities() proxy.PropUint32 {
	return &proxy.ImplPropUint32{
		Impl: v,
		Name: "CurrentCapabilities",
	}
}

// property MaxBearers u

func (v *interfaceModem) MaxBearers() proxy.PropUint32 {
	return &proxy.ImplPropUint32{
		Impl: v,
		Name: "MaxBearers",
	}
}

// property MaxActiveBearers u

func (v *interfaceModem) MaxActiveBearers() proxy.PropUint32 {
	return &proxy.ImplPropUint32{
		Impl: v,
		Name: "MaxActiveBearers",
	}
}

// property Manufacturer s

func (v *interfaceModem) Manufacturer() proxy.PropString {
	return &proxy.ImplPropString{
		Impl: v,
		Name: "Manufacturer",
	}
}

// property Model s

func (v *interfaceModem) Model() proxy.PropString {
	return &proxy.ImplPropString{
		Impl: v,
		Name: "Model",
	}
}

// property Revision s

func (v *interfaceModem) Revision() proxy.PropString {
	return &proxy.ImplPropString{
		Impl: v,
		Name: "Revision",
	}
}

// property DeviceIdentifier s

func (v *interfaceModem) DeviceIdentifier() proxy.PropString {
	return &proxy.ImplPropString{
		Impl: v,
		Name: "DeviceIdentifier",
	}
}

// property Device s

func (v *interfaceModem) Device() proxy.PropString {
	return &proxy.ImplPropString{
		Impl: v,
		Name: "Device",
	}
}

// property Drivers as

func (v *interfaceModem) Drivers() proxy.PropStringArray {
	return &proxy.ImplPropStringArray{
		Impl: v,
		Name: "Drivers",
	}
}

// property Plugin s

func (v *interfaceModem) Plugin() proxy.PropString {
	return &proxy.ImplPropString{
		Impl: v,
		Name: "Plugin",
	}
}

// property PrimaryPort s

func (v *interfaceModem) PrimaryPort() proxy.PropString {
	return &proxy.ImplPropString{
		Impl: v,
		Name: "PrimaryPort",
	}
}

type PropModemPorts interface {
	Get(flags dbus.Flags) (value []ModemPort, err error)
	Set(flags dbus.Flags, value []ModemPort) error
	ConnectChanged(cb func(hasValue bool, value []ModemPort)) error
}

type implPropModemPorts struct {
	Impl proxy.Implementer
	Name string
}

func (p implPropModemPorts) Get(flags dbus.Flags) (value []ModemPort, err error) {
	err = p.Impl.GetObject_().GetProperty_(flags, p.Impl.GetInterfaceName_(),
		p.Name, &value)
	return
}

func (p implPropModemPorts) Set(flags dbus.Flags, value []ModemPort) error {
	return p.Impl.GetObject_().SetProperty_(flags, p.Impl.GetInterfaceName_(), p.Name, value)
}

func (p implPropModemPorts) ConnectChanged(cb func(hasValue bool, value []ModemPort)) error {
	if cb == nil {
		return errors.New("nil callback")
	}
	cb0 := func(hasValue bool, value interface{}) {
		if hasValue {
			var v []ModemPort
			err := dbus.Store([]interface{}{value}, &v)
			if err != nil {
				return
			}
			cb(true, v)
		} else {
			cb(false, nil)
		}
	}
	return p.Impl.GetObject_().ConnectPropertyChanged_(p.Impl.GetInterfaceName_(),
		p.Name, cb0)
}

// property Ports a(su)

func (v *interfaceModem) Ports() PropModemPorts {
	return &implPropModemPorts{
		Impl: v,
		Name: "Ports",
	}
}

// property EquipmentIdentifier s

func (v *interfaceModem) EquipmentIdentifier() proxy.PropString {
	return &proxy.ImplPropString{
		Impl: v,
		Name: "EquipmentIdentifier",
	}
}

// property UnlockRequired u

func (v *interfaceModem) UnlockRequired() proxy.PropUint32 {
	return &proxy.ImplPropUint32{
		Impl: v,
		Name: "UnlockRequired",
	}
}

type PropModemUnlockRetries interface {
	Get(flags dbus.Flags) (value map[uint32]uint32, err error)
	Set(flags dbus.Flags, value map[uint32]uint32) error
	ConnectChanged(cb func(hasValue bool, value map[uint32]uint32)) error
}

type implPropModemUnlockRetries struct {
	Impl proxy.Implementer
	Name string
}

func (p implPropModemUnlockRetries) Get(flags dbus.Flags) (value map[uint32]uint32, err error) {
	err = p.Impl.GetObject_().GetProperty_(flags, p.Impl.GetInterfaceName_(),
		p.Name, &value)
	return
}

func (p implPropModemUnlockRetries) Set(flags dbus.Flags, value map[uint32]uint32) error {
	return p.Impl.GetObject_().SetProperty_(flags, p.Impl.GetInterfaceName_(), p.Name, value)
}

func (p implPropModemUnlockRetries) ConnectChanged(cb func(hasValue bool, value map[uint32]uint32)) error {
	if cb == nil {
		return errors.New("nil callback")
	}
	cb0 := func(hasValue bool, value interface{}) {
		if hasValue {
			var v map[uint32]uint32
			err := dbus.Store([]interface{}{value}, &v)
			if err != nil {
				return
			}
			cb(true, v)
		} else {
			cb(false, nil)
		}
	}
	return p.Impl.GetObject_().ConnectPropertyChanged_(p.Impl.GetInterfaceName_(),
		p.Name, cb0)
}

// property UnlockRetries a{uu}

func (v *interfaceModem) UnlockRetries() PropModemUnlockRetries {
	return &implPropModemUnlockRetries{
		Impl: v,
		Name: "UnlockRetries",
	}
}

// property State i

func (v *interfaceModem) State() proxy.PropInt32 {
	return &proxy.ImplPropInt32{
		Impl: v,
		Name: "State",
	}
}

// property StateFailedReason u

func (v *interfaceModem) StateFailedReason() proxy.PropUint32 {
	return &proxy.ImplPropUint32{
		Impl: v,
		Name: "StateFailedReason",
	}
}

// property AccessTechnologies u

func (v *interfaceModem) AccessTechnologies() proxy.PropUint32 {
	return &proxy.ImplPropUint32{
		Impl: v,
		Name: "AccessTechnologies",
	}
}

type PropModemSignalQuality interface {
	Get(flags dbus.Flags) (value ModemSignalQuality, err error)
	Set(flags dbus.Flags, value ModemSignalQuality) error
	ConnectChanged(cb func(hasValue bool, value ModemSignalQuality)) error
}

type implPropModemSignalQuality struct {
	Impl proxy.Implementer
	Name string
}

func (p implPropModemSignalQuality) Get(flags dbus.Flags) (value ModemSignalQuality, err error) {
	err = p.Impl.GetObject_().GetProperty_(flags, p.Impl.GetInterfaceName_(),
		p.Name, &value)
	return
}

func (p implPropModemSignalQuality) Set(flags dbus.Flags, value ModemSignalQuality) error {
	return p.Impl.GetObject_().SetProperty_(flags, p.Impl.GetInterfaceName_(), p.Name, value)
}

func (p implPropModemSignalQuality) ConnectChanged(cb func(hasValue bool, value ModemSignalQuality)) error {
	if cb == nil {
		return errors.New("nil callback")
	}
	cb0 := func(hasValue bool, value interface{}) {
		if hasValue {
			var v ModemSignalQuality
			err := dbus.Store([]interface{}{value}, &v)
			if err != nil {
				return
			}
			cb(true, v)
		} else {
			cb(false, ModemSignalQuality{})
		}
	}
	return p.Impl.GetObject_().ConnectPropertyChanged_(p.Impl.GetInterfaceName_(),
		p.Name, cb0)
}

// property SignalQuality (ub)

func (v *interfaceModem) SignalQuality() PropModemSignalQuality {
	return &implPropModemSignalQuality{
		Impl: v,
		Name: "SignalQuality",
	}
}

// property OwnNumbers as

func (v *interfaceModem) OwnNumbers() proxy.PropStringArray {
	return &proxy.ImplPropStringArray{
		Impl: v,
		Name: "OwnNumbers",
	}
}

// property PowerState u

func (v *interfaceModem) PowerState() proxy.PropUint32 {
	return &proxy.ImplPropUint32{
		Impl: v,
		Name: "PowerState",
	}
}

type PropModemSupportedModes interface {
	Get(flags dbus.Flags) (value []ModemModes, err error)
	Set(flags dbus.Flags, value []ModemModes) error
	ConnectChanged(cb func(hasValue bool, value []ModemModes)) error
}

type implPropModemSupportedModes struct {
	Impl proxy.Implementer
	Name string
}

func (p implPropModemSupportedModes) Get(flags dbus.Flags) (value []ModemModes, err error) {
	err = p.Impl.GetObject_().GetProperty_(flags, p.Impl.GetInterfaceName_(),
		p.Name, &value)
	return
}

func (p implPropModemSupportedModes) Set(flags dbus.Flags, value []ModemModes) error {
	return p.Impl.GetObject_().SetProperty_(flags, p.Impl.GetInterfaceName_(), p.Name, value)
}

func (p implPropModemSupportedModes) ConnectChanged(cb func(hasValue bool, value []ModemModes)) error {
	if cb == nil {
		return errors.New("nil callback")
	}
	cb0 := func(hasValue bool, value interface{}) {
		if hasValue {
			var v []ModemModes
			err := dbus.Store([]interface{}{value}, &v)
			if err != nil {
				return
			}
			cb(true, v)
		} else {
			cb(false, nil)
		}
	}
	return p.Impl.GetObject_().ConnectPropertyChanged_(p.Impl.GetInterfaceName_(),
		p.Name, cb0)
}

// property SupportedModes a(uu)

func (v *interfaceModem) SupportedModes() PropModemSupportedModes {
	return &implPropModemSupportedModes{
		Impl: v,
		Name: "SupportedModes",
	}
}

type PropModemCurrentModes interface {
	Get(flags dbus.Flags) (value ModemModes, err error)
	Set(flags dbus.Flags, value ModemModes) error
	ConnectChanged(cb func(hasValue bool, value ModemModes)) error
}

type implPropModemCurrentModes struct {
	Impl proxy.Implementer
	Name string
}

func (p implPropModemCurrentModes) Get(flags dbus.Flags) (value ModemModes, err error) {
	err = p.Impl.GetObject_().GetProperty_(flags, p.Impl.GetInterfaceName_(),
		p.Name, &value)
	return
}

func (p implPropModemCurrentModes) Set(flags dbus.Flags, value ModemModes) error {
	return p.Impl.GetObject_().SetProperty_(flags, p.Impl.GetInterfaceName_(), p.Name, value)
}

func (p implPropModemCurrentModes) ConnectChanged(cb func(hasValue bool, value ModemModes)) error {
	if cb == nil {
		return errors.New("nil callback")
	}
	cb0 := func(hasValue bool, value interface{}) {
		if hasValue {
			var v ModemModes
			err := dbus.Store([]interface{}{value}, &v)
			if err != nil {
				return
			}
			cb(true, v)
		} else {
			cb(false, ModemModes{})
		}
	}
	return p.Impl.GetObject_().ConnectPropertyChanged_(p.Impl.GetInterfaceName_(),
		p.Name, cb0)
}

// property CurrentModes (uu)

func (v *interfaceModem) CurrentModes() PropModemCurrentModes {
	return &implPropModemCurrentModes{
		Impl: v,
		Name: "CurrentModes",
	}
}

// property SupportedBands au

func (v *interfaceModem) SupportedBands() proxy.PropUint32Array {
	return &proxy.ImplPropUint32Array{
		Impl: v,
		Name: "SupportedBands",
	}
}

// property CurrentBands au

func (v *interfaceModem) CurrentBands() proxy.PropUint32Array {
	return &proxy.ImplPropUint32Array{
		Impl: v,
		Name: "CurrentBands",
	}
}

// property SupportedIpFamilies u

func (v *interfaceModem) SupportedIpFamilies() proxy.PropUint32 {
	return &proxy.ImplPropUint32{
		Impl: v,
		Name: "SupportedIpFamilies",
	}
}

func (obj *objectModem) Firmware() modemFirmware {
	return &obj.interfaceModemFirmware
}

type modemFirmware interface {
	GoList(flags dbus.Flags, ch chan *dbus.Call) *dbus.Call
	List(flags dbus.Flags) (string, []map[string]dbus.Variant, error)
	GoSelect(flags dbus.Flags, ch chan *dbus.Call, uniqueid string) *dbus.Call
	Select(flags dbus.Flags, uniqueid string) error
}

type interfaceModemFirmware struct{}

func (v *interfaceModemFirmware) GetObject_() *proxy.ImplObject {
	return (*proxy.ImplObject)(unsafe.Pointer(v))
}

func (*interfaceModemFirmware) GetInterfaceName_() string {
	return "org.freedesktop.ModemManager1.Modem.Firmware"
}

// method List

func (v *interfaceModemFirmware) GoList(flags dbus.Flags, ch chan *dbus.Call) *dbus.Call {
	return v.GetObject_().Go_(v.GetInterfaceName_()+".List", flags, ch)
}

func (*interfaceModemFirmware) StoreList(call *dbus.Call) (selected string, installed []map[string]dbus.Variant, err error) {
	err = call.Store(&selected, &installed)
	return
}

func (v *interfaceModemFirmware) List(flags dbus.Flags) (string, []map[string]dbus.Variant, error) {
	return v.StoreList(
		<-v.GoList(flags, make(chan *dbus.Call, 1)).Done)
}

// method Select

func (v *interfaceModemFirmware) GoSelect(flags dbus.Flags, ch chan *dbus.Call, uniqueid string) *dbus.Call {
	return v.GetObject_().Go_(v.GetInterfaceName_()+".Select", flags, ch, uniqueid)
}

func (v *interfaceModemFirmware) Select(flags dbus.Flags, uniqueid string) error {
	return (<-v.GoSelect(flags, make(chan *dbus.Call, 1), uniqueid).Done).Err
}

func (obj *objectModem) Location() modemLocation {
	return &obj.interfaceModemLocation
}

type modemLocation interface {
	GoSetup(flags dbus.Flags, ch chan *dbus.Call, sources uint32, signal_location bool) *dbus.Call
	Setup(flags dbus.Flags, sources uint32, signal_location bool) error
	GoGetLocation(flags dbus.Flags, ch chan *dbus.Call) *dbus.Call
	GetLocation(flags dbus.Flags) (map[uint32]dbus.Variant, error)
	GoSetSuplServer(flags dbus.Flags, ch chan *dbus.Call, supl string) *dbus.Call
	SetSuplServer(flags dbus.Flags, supl string) error
	GoSetGpsRefreshRate(flags dbus.Flags, ch chan *dbus.Call, rate uint32) *dbus.Call
	SetGpsRefreshRate(flags dbus.Flags, rate uint32) error
	Capabilities() proxy.PropUint32
	Enabled() proxy.PropUint32
	SignalsLocation() proxy.PropBool
	Location() PropModemLocation
	SuplServer() proxy.PropString
	GpsRefreshRate() proxy.PropUint32
}

type interfaceModemLocation struct{}

func (v *interfaceModemLocation) GetObject_() *proxy.ImplObject {
	return (*proxy.ImplObject)(unsafe.Pointer(v))
}

func (*interfaceModemLocation) GetInterfaceName_() string {
	return "org.freedesktop.ModemManager1.Modem.Location"
}

// method Setup

func (v *interfaceModemLocation) GoSetup(flags dbus.Flags, ch chan *dbus.Call, sources uint32, signal_location bool) *dbus.Call {
	return v.GetObject_().Go_(v.GetInterfaceName_()+".Setup", flags, ch, sources, signal_location)
}

func (v *interfaceModemLocation) Setup(flags dbus.Flags, sources uint32, signal_location bool) error {
	return (<-v.GoSetup(flags, make(chan *dbus.Call, 1), sources, signal_location).Done).Err
}

// method GetLocation

func (v *interfaceModemLocation) GoGetLocation(flags dbus.Flags, ch chan *dbus.Call) *dbus.Call {
	return v.GetObject_().Go_(v.GetInterfaceName_()+".GetLocation", flags, ch)
}

func (*interfaceModemLocation) StoreGetLocation(call *dbus.Call) (Location map[uint32]dbus.Variant, err error) {
	err = call.Store(&Location)
	return
}

func (v *interfaceModemLocation) GetLocation(flags dbus.Flags) (map[uint32]dbus.Variant, error) {
	return v.StoreGetLocation(
		<-v.GoGetLocation(flags, make(chan *dbus.Call, 1)).Done)
}

// method SetSuplServer

func (v *interfaceModemLocation) GoSetSuplServer(flags dbus.Flags, ch chan *dbus.Call, supl string) *dbus.Call {
	return v.GetObject_().Go_(v.GetInterfaceName_()+".SetSuplServer", flags, ch, supl)
}

func (v *interfaceModemLocation) SetSuplServer(flags dbus.Flags, supl string) error {
	return (<-v.GoSetSuplServer(flags, make(chan *dbus.Call, 1), supl).Done).Err
}

// method SetGpsRefreshRate

func (v *interfaceModemLocation) GoSetGpsRefreshRate(flags dbus.Flags, ch chan *dbus.Call, rate uint32) *dbus.Call {
	return v.GetObject_().Go_(v.GetInterfaceName_()+".SetGpsRefreshRate", flags, ch, rate)
}

func (v *interfaceModemLocation) SetGpsRefreshRate(flags dbus.Flags, rate uint32) error {
	return (<-v.GoSetGpsRefreshRate(flags, make(chan *dbus.Call, 1), rate).Done).Err
}

// property Capabilities u

func (v *interfaceModemLocation) Capabilities() proxy.PropUint32 {
	return &proxy.ImplPropUint32{
		Impl: v,
		Name: "Capabilities",
	}
}

// property Enabled u

func (v *interfaceModemLocation) Enabled() proxy.PropUint32 {
	return &proxy.ImplPropUint32{
		Impl: v,
		Name: "Enabled",
	}
}

// property SignalsLocation b

func (v *interfaceModemLocation) SignalsLocation() proxy.PropBool {
	return &proxy.ImplPropBool{
		Impl: v,
		Name: "SignalsLocation",
	}
}

type PropModemLocation interface {
	Get(flags dbus.Flags) (value map[uint32]dbus.Variant, err error)
	Set(flags dbus.Flags, value map[uint32]dbus.Variant) error
	ConnectChanged(cb func(hasValue bool, value map[uint32]dbus.Variant)) error
}

type implPropModemLocation struct {
	Impl proxy.Implementer
	Name string
}

func (p implPropModemLocation) Get(flags dbus.Flags) (value map[uint32]dbus.Variant, err error) {
	err = p.Impl.GetObject_().GetProperty_(flags, p.Impl.GetInterfaceName_(),
		p.Name, &value)
	return
}

func (p implPropModemLocation) Set(flags dbus.Flags, value map[uint32]dbus.Variant) error {
	return p.Impl.GetObject_().SetProperty_(flags, p.Impl.GetInterfaceName_(), p.Name, value)
}

func (p implPropModemLocation) ConnectChanged(cb func(hasValue bool, value map[uint32]dbus.Variant)) error {
	if cb == nil {
		return errors.New("nil callback")
	}
	cb0 := func(hasValue bool, value interface{}) {
		if hasValue {
			var v map[uint32]dbus.Variant
			err := dbus.Store([]interface{}{value}, &v)
			if err != nil {
				return
			}
			cb(true, v)
		} else {
			cb(false, nil)
		}
	}
	return p.Impl.GetObject_().ConnectPropertyChanged_(p.Impl.GetInterfaceName_(),
		p.Name, cb0)
}

// property Location a{uv}

func (v *interfaceModemLocation) Location() PropModemLocation {
	return &implPropModemLocation{
		Impl: v,
		Name: "Location",
	}
}

// property SuplServer s

func (v *interfaceModemLocation) SuplServer() proxy.PropString {
	return &proxy.ImplPropString{
		Impl: v,
		Name: "SuplServer",
	}
}

// property GpsRefreshRate u

func (v *interfaceModemLocation) GpsRefreshRate() proxy.PropUint32 {
	return &proxy.ImplPropUint32{
		Impl: v,
		Name: "GpsRefreshRate",
	}
}

func (obj *objectModem) Messaging() modemMessaging {
	return &obj.interfaceModemMessaging
}

type modemMessaging interface {
	GoList(flags dbus.Flags, ch chan *dbus.Call) *dbus.Call
	List(flags dbus.Flags) ([]dbus.ObjectPath, error)
	GoDelete(flags dbus.Flags, ch chan *dbus.Call, path dbus.ObjectPath) *dbus.Call
	Delete(flags dbus.Flags, path dbus.ObjectPath) error
	GoCreate(flags dbus.Flags, ch chan *dbus.Call, properties map[string]dbus.Variant) *dbus.Call
	Create(flags dbus.Flags, properties map[string]dbus.Variant) (dbus.ObjectPath, error)
	ConnectAdded(cb func(path dbus.ObjectPath, received bool)) (dbusutil.SignalHandlerId, error)
	ConnectDeleted(cb func(path dbus.ObjectPath)) (dbusutil.SignalHandlerId, error)
	Messages() proxy.PropObjectPathArray
	SupportedStorages() proxy.PropUint32Array
	DefaultStorage() proxy.PropUint32
}

type interfaceModemMessaging struct{}

func (v *interfaceModemMessaging) GetObject_() *proxy.ImplObject {
	return (*proxy.ImplObject)(unsafe.Pointer(v))
}

func (*interfaceModemMessaging) GetInterfaceName_() string {
	return "org.freedesktop.ModemManager1.Modem.Messaging"
}

// method List

func (v *interfaceModemMessaging) GoList(flags dbus.Flags, ch chan *dbus.Call) *dbus.Call {
	return v.GetObject_().Go_(v.GetInterfaceName_()+".List", flags, ch)
}

func (*interfaceModemMessaging) StoreList(call *dbus.Call) (result []dbus.ObjectPath, err error) {
	err = call.Store(&result)
	return
}

func (v *interfaceModemMessaging) List(flags dbus.Flags) ([]dbus.ObjectPath, error) {
	return v.StoreList(
		<-v.GoList(flags, make(chan *dbus.Call, 1)).Done)
}

// method Delete

func (v *interfaceModemMessaging) GoDelete(flags dbus.Flags, ch chan *dbus.Call, path dbus.ObjectPath) *dbus.Call {
	return v.GetObject_().Go_(v.GetInterfaceName_()+".Delete", flags, ch, path)
}

func (v *interfaceModemMessaging) Delete(flags dbus.Flags, path dbus.ObjectPath) error {
	return (<-v.GoDelete(flags, make(chan *dbus.Call, 1), path).Done).Err
}

// method Create

func (v *interfaceModemMessaging) GoCreate(flags dbus.Flags, ch chan *dbus.Call, properties map[string]dbus.Variant) *dbus.Call {
	return v.GetObject_().Go_(v.GetInterfaceName_()+".Create", flags, ch, properties)
}

func (*interfaceModemMessaging) StoreCreate(call *dbus.Call) (path dbus.ObjectPath, err error) {
	err = call.Store(&path)
	return
}

func (v *interfaceModemMessaging) Create(flags dbus.Flags, properties map[string]dbus.Variant) (dbus.ObjectPath, error) {
	return v.StoreCreate(
		<-v.GoCreate(flags, make(chan *dbus.Call, 1), properties).Done)
}

// signal Added

func (v *interfaceModemMessaging) ConnectAdded(cb func(path dbus.ObjectPath, received bool)) (dbusutil.SignalHandlerId, error) {
	if cb == nil {
		return 0, errors.New("nil callback")
	}
	obj := v.GetObject_()
	rule := fmt.Sprintf(
		"type='signal',interface='%s',member='%s',path='%s',sender='%s'",
		v.GetInterfaceName_(), "Added", obj.Path_(), obj.ServiceName_())

	sigRule := &dbusutil.SignalRule{
		Path: obj.Path_(),
		Name: v.GetInterfaceName_() + ".Added",
	}
	handlerFunc := func(sig *dbus.Signal) {
		var path dbus.ObjectPath
		var received bool
		err := dbus.Store(sig.Body, &path, &received)
		if err == nil {
			cb(path, received)
		}
	}

	return obj.ConnectSignal_(rule, sigRule, handlerFunc)
}

// signal Deleted

func (v *interfaceModemMessaging) ConnectDeleted(cb func(path dbus.ObjectPath)) (dbusutil.SignalHandlerId, error) {
	if cb == nil {
		return 0, errors.New("nil callback")
	}
	obj := v.GetObject_()
	rule := fmt.Sprintf(
		"type='signal',interface='%s',member='%s',path='%s',sender='%s'",
		v.GetInterfaceName_(), "Deleted", obj.Path_(), obj.ServiceName_())

	sigRule := &dbusutil.SignalRule{
		Path: obj.Path_(),
		Name: v.GetInterfaceName_() + ".Deleted",
	}
	handlerFunc := func(sig *dbus.Signal) {
		var path dbus.ObjectPath
		err := dbus.Store(sig.Body, &path)
		if err == nil {
			cb(path)
		}
	}

	return obj.ConnectSignal_(rule, sigRule, handlerFunc)
}

// property Messages ao

func (v *interfaceModemMessaging) Messages() proxy.PropObjectPathArray {
	return &proxy.ImplPropObjectPathArray{
		Impl: v,
		Name: "Messages",
	}
}

// property SupportedStorages au

func (v *interfaceModemMessaging) SupportedStorages() proxy.PropUint32Array {
	return &proxy.ImplPropUint32Array{
		Impl: v,
		Name: "SupportedStorages",
	}
}

// property DefaultStorage u

func (v *interfaceModemMessaging) DefaultStorage() proxy.PropUint32 {
	return &proxy.ImplPropUint32{
		Impl: v,
		Name: "DefaultStorage",
	}
}

func (obj *objectModem) Modem3gppUssd() modem3gppUssd {
	return &obj.interfaceModem3gppUssd
}

type modem3gppUssd interface {
	GoInitiate(flags dbus.Flags, ch chan *dbus.Call, command string) *dbus.Call
	Initiate(flags dbus.Flags, command string) (string, error)
	GoRespond(flags dbus.Flags, ch chan *dbus.Call, response string) *dbus.Call
	Respond(flags dbus.Flags, response string) (string, error)
	GoCancel(flags dbus.Flags, ch chan *dbus.Call) *dbus.Call
	Cancel(flags dbus.Flags) error
	State() proxy.PropUint32
	NetworkNotification() proxy.PropString
	NetworkRequest() proxy.PropString
}

type interfaceModem3gppUssd struct{}

func (v *interfaceModem3gppUssd) GetObject_() *proxy.ImplObject {
	return (*proxy.ImplObject)(unsafe.Pointer(v))
}

func (*interfaceModem3gppUssd) GetInterfaceName_() string {
	return "org.freedesktop.ModemManager1.Modem.Modem3gpp.Ussd"
}

// method Initiate

func (v *interfaceModem3gppUssd) GoInitiate(flags dbus.Flags, ch chan *dbus.Call, command string) *dbus.Call {
	return v.GetObject_().Go_(v.GetInterfaceName_()+".Initiate", flags, ch, command)
}

func (*interfaceModem3gppUssd) StoreInitiate(call *dbus.Call) (reply string, err error) {
	err = call.Store(&reply)
	return
}

func (v *interfaceModem3gppUssd) Initiate(flags dbus.Flags, command string) (string, error) {
	return v.StoreInitiate(
		<-v.GoInitiate(flags, make(chan *dbus.Call, 1), command).Done)
}

// method Respond

func (v *interfaceModem3gppUssd) GoRespond(flags dbus.Flags, ch chan *dbus.Call, response string) *dbus.Call {
	return v.GetObject_().Go_(v.GetInterfaceName_()+".Respond", flags, ch, response)
}

func (*interfaceModem3gppUssd) StoreRespond(call *dbus.Call) (reply string, err error) {
	err = call.Store(&reply)
	return
}

func (v *interfaceModem3gppUssd) Respond(flags dbus.Flags, response string) (string, error) {
	return v.StoreRespond(
		<-v.GoRespond(flags, make(chan *dbus.Call, 1), response).Done)
}

// method Cancel

func (v *interfaceModem3gppUssd) GoCancel(flags dbus.Flags, ch chan *dbus.Call) *dbus.Call {
	return v.GetObject_().Go_(v.GetInterfaceName_()+".Cancel", flags, ch)
}

func (v *interfaceModem3gppUssd) Cancel(flags dbus.Flags) error {
	return (<-v.GoCancel(flags, make(chan *dbus.Call, 1)).Done).Err
}

// property State u

func (v *interfaceModem3gppUssd) State() proxy.PropUint32 {
	return &proxy.ImplPropUint32{
		Impl: v,
		Name: "State",
	}
}

// property NetworkNotification s

func (v *interfaceModem3gppUssd) NetworkNotification() proxy.PropString {
	return &proxy.ImplPropString{
		Impl: v,
		Name: "NetworkNotification",
	}
}

// property NetworkRequest s

func (v *interfaceModem3gppUssd) NetworkRequest() proxy.PropString {
	return &proxy.ImplPropString{
		Impl: v,
		Name: "NetworkRequest",
	}
}

func (obj *objectModem) Modem3gpp() modem3gpp {
	return &obj.interfaceModem3gpp
}

type modem3gpp interface {
	GoRegister(flags dbus.Flags, ch chan *dbus.Call, operator_id string) *dbus.Call
	Register(flags dbus.Flags, operator_id string) error
	GoScan(flags dbus.Flags, ch chan *dbus.Call) *dbus.Call
	Scan(flags dbus.Flags) ([]map[string]dbus.Variant, error)
	Imei() proxy.PropString
	RegistrationState() proxy.PropUint32
	OperatorCode() proxy.PropString
	OperatorName() proxy.PropString
	EnabledFacilityLocks() proxy.PropUint32
	SubscriptionState() proxy.PropUint32
}

type interfaceModem3gpp struct{}

func (v *interfaceModem3gpp) GetObject_() *proxy.ImplObject {
	return (*proxy.ImplObject)(unsafe.Pointer(v))
}

func (*interfaceModem3gpp) GetInterfaceName_() string {
	return "org.freedesktop.ModemManager1.Modem.Modem3gpp"
}

// method Register

func (v *interfaceModem3gpp) GoRegister(flags dbus.Flags, ch chan *dbus.Call, operator_id string) *dbus.Call {
	return v.GetObject_().Go_(v.GetInterfaceName_()+".Register", flags, ch, operator_id)
}

func (v *interfaceModem3gpp) Register(flags dbus.Flags, operator_id string) error {
	return (<-v.GoRegister(flags, make(chan *dbus.Call, 1), operator_id).Done).Err
}

// method Scan

func (v *interfaceModem3gpp) GoScan(flags dbus.Flags, ch chan *dbus.Call) *dbus.Call {
	return v.GetObject_().Go_(v.GetInterfaceName_()+".Scan", flags, ch)
}

func (*interfaceModem3gpp) StoreScan(call *dbus.Call) (results []map[string]dbus.Variant, err error) {
	err = call.Store(&results)
	return
}

func (v *interfaceModem3gpp) Scan(flags dbus.Flags) ([]map[string]dbus.Variant, error) {
	return v.StoreScan(
		<-v.GoScan(flags, make(chan *dbus.Call, 1)).Done)
}

// property Imei s

func (v *interfaceModem3gpp) Imei() proxy.PropString {
	return &proxy.ImplPropString{
		Impl: v,
		Name: "Imei",
	}
}

// property RegistrationState u

func (v *interfaceModem3gpp) RegistrationState() proxy.PropUint32 {
	return &proxy.ImplPropUint32{
		Impl: v,
		Name: "RegistrationState",
	}
}

// property OperatorCode s

func (v *interfaceModem3gpp) OperatorCode() proxy.PropString {
	return &proxy.ImplPropString{
		Impl: v,
		Name: "OperatorCode",
	}
}

// property OperatorName s

func (v *interfaceModem3gpp) OperatorName() proxy.PropString {
	return &proxy.ImplPropString{
		Impl: v,
		Name: "OperatorName",
	}
}

// property EnabledFacilityLocks u

func (v *interfaceModem3gpp) EnabledFacilityLocks() proxy.PropUint32 {
	return &proxy.ImplPropUint32{
		Impl: v,
		Name: "EnabledFacilityLocks",
	}
}

// property SubscriptionState u

func (v *interfaceModem3gpp) SubscriptionState() proxy.PropUint32 {
	return &proxy.ImplPropUint32{
		Impl: v,
		Name: "SubscriptionState",
	}
}

func (obj *objectModem) Cdma() modemCdma {
	return &obj.interfaceModemCdma
}

type modemCdma interface {
	GoActivate(flags dbus.Flags, ch chan *dbus.Call, carrier_code string) *dbus.Call
	Activate(flags dbus.Flags, carrier_code string) error
	GoActivateManual(flags dbus.Flags, ch chan *dbus.Call, properties map[string]dbus.Variant) *dbus.Call
	ActivateManual(flags dbus.Flags, properties map[string]dbus.Variant) error
	ConnectActivationStateChanged(cb func(activation_state uint32, activation_error uint32, status_changes map[string]dbus.Variant)) (dbusutil.SignalHandlerId, error)
	ActivationState() proxy.PropUint32
	Meid() proxy.PropString
	Esn() proxy.PropString
	Sid() proxy.PropUint32
	Nid() proxy.PropUint32
	Cdma1xRegistrationState() proxy.PropUint32
	EvdoRegistrationState() proxy.PropUint32
}

type interfaceModemCdma struct{}

func (v *interfaceModemCdma) GetObject_() *proxy.ImplObject {
	return (*proxy.ImplObject)(unsafe.Pointer(v))
}

func (*interfaceModemCdma) GetInterfaceName_() string {
	return "org.freedesktop.ModemManager1.Modem.ModemCdma"
}

// method Activate

func (v *interfaceModemCdma) GoActivate(flags dbus.Flags, ch chan *dbus.Call, carrier_code string) *dbus.Call {
	return v.GetObject_().Go_(v.GetInterfaceName_()+".Activate", flags, ch, carrier_code)
}

func (v *interfaceModemCdma) Activate(flags dbus.Flags, carrier_code string) error {
	return (<-v.GoActivate(flags, make(chan *dbus.Call, 1), carrier_code).Done).Err
}

// method ActivateManual

func (v *interfaceModemCdma) GoActivateManual(flags dbus.Flags, ch chan *dbus.Call, properties map[string]dbus.Variant) *dbus.Call {
	return v.GetObject_().Go_(v.GetInterfaceName_()+".ActivateManual", flags, ch, properties)
}

func (v *interfaceModemCdma) ActivateManual(flags dbus.Flags, properties map[string]dbus.Variant) error {
	return (<-v.GoActivateManual(flags, make(chan *dbus.Call, 1), properties).Done).Err
}

// signal ActivationStateChanged

func (v *interfaceModemCdma) ConnectActivationStateChanged(cb func(activation_state uint32, activation_error uint32, status_changes map[string]dbus.Variant)) (dbusutil.SignalHandlerId, error) {
	if cb == nil {
		return 0, errors.New("nil callback")
	}
	obj := v.GetObject_()
	rule := fmt.Sprintf(
		"type='signal',interface='%s',member='%s',path='%s',sender='%s'",
		v.GetInterfaceName_(), "ActivationStateChanged", obj.Path_(), obj.ServiceName_())

	sigRule := &dbusutil.SignalRule{
		Path: obj.Path_(),
		Name: v.GetInterfaceName_() + ".ActivationStateChanged",
	}
	handlerFunc := func(sig *dbus.Signal) {
		var activation_state uint32
		var activation_error uint32
		var status_changes map[string]dbus.Variant
		err := dbus.Store(sig.Body, &activation_state, &activation_error, &status_changes)
		if err == nil {
			cb(activation_state, activation_error, status_changes)
		}
	}

	return obj.ConnectSignal_(rule, sigRule, handlerFunc)
}

// property ActivationState u

func (v *interfaceModemCdma) ActivationState() proxy.PropUint32 {
	return &proxy.ImplPropUint32{
		Impl: v,
		Name: "ActivationState",
	}
}

// property Meid s

func (v *interfaceModemCdma) Meid() proxy.PropString {
	return &proxy.ImplPropString{
		Impl: v,
		Name: "Meid",
	}
}

// property Esn s

func (v *interfaceModemCdma) Esn() proxy.PropString {
	return &proxy.ImplPropString{
		Impl: v,
		Name: "Esn",
	}
}

// property Sid u

func (v *interfaceModemCdma) Sid() proxy.PropUint32 {
	return &proxy.ImplPropUint32{
		Impl: v,
		Name: "Sid",
	}
}

// property Nid u

func (v *interfaceModemCdma) Nid() proxy.PropUint32 {
	return &proxy.ImplPropUint32{
		Impl: v,
		Name: "Nid",
	}
}

// property Cdma1xRegistrationState u

func (v *interfaceModemCdma) Cdma1xRegistrationState() proxy.PropUint32 {
	return &proxy.ImplPropUint32{
		Impl: v,
		Name: "Cdma1xRegistrationState",
	}
}

// property EvdoRegistrationState u

func (v *interfaceModemCdma) EvdoRegistrationState() proxy.PropUint32 {
	return &proxy.ImplPropUint32{
		Impl: v,
		Name: "EvdoRegistrationState",
	}
}

func (obj *objectModem) Oma() modemOma {
	return &obj.interfaceModemOma
}

type modemOma interface {
	GoSetup(flags dbus.Flags, ch chan *dbus.Call, features uint32) *dbus.Call
	Setup(flags dbus.Flags, features uint32) error
	GoStartClientInitiatedSession(flags dbus.Flags, ch chan *dbus.Call, session_type uint32) *dbus.Call
	StartClientInitiatedSession(flags dbus.Flags, session_type uint32) error
	GoAcceptNetworkInitiatedSession(flags dbus.Flags, ch chan *dbus.Call, session_id uint32, accept bool) *dbus.Call
	AcceptNetworkInitiatedSession(flags dbus.Flags, session_id uint32, accept bool) error
	GoCancelSession(flags dbus.Flags, ch chan *dbus.Call) *dbus.Call
	CancelSession(flags dbus.Flags) error
	ConnectSessionStateChanged(cb func(old_session_state int32, new_session_state int32, session_state_failed_reason uint32)) (dbusutil.SignalHandlerId, error)
	Features() proxy.PropUint32
	PendingNetworkInitiatedSessions() PropModemOmaPendingNetworkInitiatedSessions
	SessionType() proxy.PropUint32
	SessionState() proxy.PropInt32
}

type interfaceModemOma struct{}

func (v *interfaceModemOma) GetObject_() *proxy.ImplObject {
	return (*proxy.ImplObject)(unsafe.Pointer(v))
}

func (*interfaceModemOma) GetInterfaceName_() string {
	return "org.freedesktop.ModemManager1.Modem.Oma"
}

// method Setup

func (v *interfaceModemOma) GoSetup(flags dbus.Flags, ch chan *dbus.Call, features uint32) *dbus.Call {
	return v.GetObject_().Go_(v.GetInterfaceName_()+".Setup", flags, ch, features)
}

func (v *interfaceModemOma) Setup(flags dbus.Flags, features uint32) error {
	return (<-v.GoSetup(flags, make(chan *dbus.Call, 1), features).Done).Err
}

// method StartClientInitiatedSession

func (v *interfaceModemOma) GoStartClientInitiatedSession(flags dbus.Flags, ch chan *dbus.Call, session_type uint32) *dbus.Call {
	return v.GetObject_().Go_(v.GetInterfaceName_()+".StartClientInitiatedSession", flags, ch, session_type)
}

func (v *interfaceModemOma) StartClientInitiatedSession(flags dbus.Flags, session_type uint32) error {
	return (<-v.GoStartClientInitiatedSession(flags, make(chan *dbus.Call, 1), session_type).Done).Err
}

// method AcceptNetworkInitiatedSession

func (v *interfaceModemOma) GoAcceptNetworkInitiatedSession(flags dbus.Flags, ch chan *dbus.Call, session_id uint32, accept bool) *dbus.Call {
	return v.GetObject_().Go_(v.GetInterfaceName_()+".AcceptNetworkInitiatedSession", flags, ch, session_id, accept)
}

func (v *interfaceModemOma) AcceptNetworkInitiatedSession(flags dbus.Flags, session_id uint32, accept bool) error {
	return (<-v.GoAcceptNetworkInitiatedSession(flags, make(chan *dbus.Call, 1), session_id, accept).Done).Err
}

// method CancelSession

func (v *interfaceModemOma) GoCancelSession(flags dbus.Flags, ch chan *dbus.Call) *dbus.Call {
	return v.GetObject_().Go_(v.GetInterfaceName_()+".CancelSession", flags, ch)
}

func (v *interfaceModemOma) CancelSession(flags dbus.Flags) error {
	return (<-v.GoCancelSession(flags, make(chan *dbus.Call, 1)).Done).Err
}

// signal SessionStateChanged

func (v *interfaceModemOma) ConnectSessionStateChanged(cb func(old_session_state int32, new_session_state int32, session_state_failed_reason uint32)) (dbusutil.SignalHandlerId, error) {
	if cb == nil {
		return 0, errors.New("nil callback")
	}
	obj := v.GetObject_()
	rule := fmt.Sprintf(
		"type='signal',interface='%s',member='%s',path='%s',sender='%s'",
		v.GetInterfaceName_(), "SessionStateChanged", obj.Path_(), obj.ServiceName_())

	sigRule := &dbusutil.SignalRule{
		Path: obj.Path_(),
		Name: v.GetInterfaceName_() + ".SessionStateChanged",
	}
	handlerFunc := func(sig *dbus.Signal) {
		var old_session_state int32
		var new_session_state int32
		var session_state_failed_reason uint32
		err := dbus.Store(sig.Body, &old_session_state, &new_session_state, &session_state_failed_reason)
		if err == nil {
			cb(old_session_state, new_session_state, session_state_failed_reason)
		}
	}

	return obj.ConnectSignal_(rule, sigRule, handlerFunc)
}

// property Features u

func (v *interfaceModemOma) Features() proxy.PropUint32 {
	return &proxy.ImplPropUint32{
		Impl: v,
		Name: "Features",
	}
}

type PropModemOmaPendingNetworkInitiatedSessions interface {
	Get(flags dbus.Flags) (value []OmaSession, err error)
	Set(flags dbus.Flags, value []OmaSession) error
	ConnectChanged(cb func(hasValue bool, value []OmaSession)) error
}

type implPropModemOmaPendingNetworkInitiatedSessions struct {
	Impl proxy.Implementer
	Name string
}

func (p implPropModemOmaPendingNetworkInitiatedSessions) Get(flags dbus.Flags) (value []OmaSession, err error) {
	err = p.Impl.GetObject_().GetProperty_(flags, p.Impl.GetInterfaceName_(),
		p.Name, &value)
	return
}

func (p implPropModemOmaPendingNetworkInitiatedSessions) Set(flags dbus.Flags, value []OmaSession) error {
	return p.Impl.GetObject_().SetProperty_(flags, p.Impl.GetInterfaceName_(), p.Name, value)
}

func (p implPropModemOmaPendingNetworkInitiatedSessions) ConnectChanged(cb func(hasValue bool, value []OmaSession)) error {
	if cb == nil {
		return errors.New("nil callback")
	}
	cb0 := func(hasValue bool, value interface{}) {
		if hasValue {
			var v []OmaSession
			err := dbus.Store([]interface{}{value}, &v)
			if err != nil {
				return
			}
			cb(true, v)
		} else {
			cb(false, nil)
		}
	}
	return p.Impl.GetObject_().ConnectPropertyChanged_(p.Impl.GetInterfaceName_(),
		p.Name, cb0)
}

// property PendingNetworkInitiatedSessions a(uu)

func (v *interfaceModemOma) PendingNetworkInitiatedSessions() PropModemOmaPendingNetworkInitiatedSessions {
	return &implPropModemOmaPendingNetworkInitiatedSessions{
		Impl: v,
		Name: "PendingNetworkInitiatedSessions",
	}
}

// property SessionType u

func (v *interfaceModemOma) SessionType() proxy.PropUint32 {
	return &proxy.ImplPropUint32{
		Impl: v,
		Name: "SessionType",
	}
}

// property SessionState i

func (v *interfaceModemOma) SessionState() proxy.PropInt32 {
	return &proxy.ImplPropInt32{
		Impl: v,
		Name: "SessionState",
	}
}

func (obj *objectModem) Signal() modemSignal {
	return &obj.interfaceModemSignal
}

type modemSignal interface {
	GoSetup(flags dbus.Flags, ch chan *dbus.Call, rate uint32) *dbus.Call
	Setup(flags dbus.Flags, rate uint32) error
	Rate() proxy.PropUint32
	Cdma() PropMapStringVariant
	Evdo() PropMapStringVariant
	Gsm() PropMapStringVariant
	Umts() PropMapStringVariant
	Lte() PropMapStringVariant
}

type interfaceModemSignal struct{}

func (v *interfaceModemSignal) GetObject_() *proxy.ImplObject {
	return (*proxy.ImplObject)(unsafe.Pointer(v))
}

func (*interfaceModemSignal) GetInterfaceName_() string {
	return "org.freedesktop.ModemManager1.Modem.Signal"
}

// method Setup

func (v *interfaceModemSignal) GoSetup(flags dbus.Flags, ch chan *dbus.Call, rate uint32) *dbus.Call {
	return v.GetObject_().Go_(v.GetInterfaceName_()+".Setup", flags, ch, rate)
}

func (v *interfaceModemSignal) Setup(flags dbus.Flags, rate uint32) error {
	return (<-v.GoSetup(flags, make(chan *dbus.Call, 1), rate).Done).Err
}

// property Rate u

func (v *interfaceModemSignal) Rate() proxy.PropUint32 {
	return &proxy.ImplPropUint32{
		Impl: v,
		Name: "Rate",
	}
}

// property Cdma a{sv}

func (v *interfaceModemSignal) Cdma() PropMapStringVariant {
	return &implPropMapStringVariant{
		Impl: v,
		Name: "Cdma",
	}
}

// property Evdo a{sv}

func (v *interfaceModemSignal) Evdo() PropMapStringVariant {
	return &implPropMapStringVariant{
		Impl: v,
		Name: "Evdo",
	}
}

// property Gsm a{sv}

func (v *interfaceModemSignal) Gsm() PropMapStringVariant {
	return &implPropMapStringVariant{
		Impl: v,
		Name: "Gsm",
	}
}

// property Umts a{sv}

func (v *interfaceModemSignal) Umts() PropMapStringVariant {
	return &implPropMapStringVariant{
		Impl: v,
		Name: "Umts",
	}
}

// property Lte a{sv}

func (v *interfaceModemSignal) Lte() PropMapStringVariant {
	return &implPropMapStringVariant{
		Impl: v,
		Name: "Lte",
	}
}

func (obj *objectModem) Simple() modemSimple {
	return &obj.interfaceModemSimple
}

type modemSimple interface {
	GoConnect(flags dbus.Flags, ch chan *dbus.Call, properties map[string]dbus.Variant) *dbus.Call
	Connect(flags dbus.Flags, properties map[string]dbus.Variant) (dbus.ObjectPath, error)
	GoDisconnect(flags dbus.Flags, ch chan *dbus.Call, bearer dbus.ObjectPath) *dbus.Call
	Disconnect(flags dbus.Flags, bearer dbus.ObjectPath) error
	GoGetStatus(flags dbus.Flags, ch chan *dbus.Call) *dbus.Call
	GetStatus(flags dbus.Flags) (map[string]dbus.Variant, error)
}

type interfaceModemSimple struct{}

func (v *interfaceModemSimple) GetObject_() *proxy.ImplObject {
	return (*proxy.ImplObject)(unsafe.Pointer(v))
}

func (*interfaceModemSimple) GetInterfaceName_() string {
	return "org.freedesktop.ModemManager1.Modem.Simple"
}

// method Connect

func (v *interfaceModemSimple) GoConnect(flags dbus.Flags, ch chan *dbus.Call, properties map[string]dbus.Variant) *dbus.Call {
	return v.GetObject_().Go_(v.GetInterfaceName_()+".Connect", flags, ch, properties)
}

func (*interfaceModemSimple) StoreConnect(call *dbus.Call) (bearer dbus.ObjectPath, err error) {
	err = call.Store(&bearer)
	return
}

func (v *interfaceModemSimple) Connect(flags dbus.Flags, properties map[string]dbus.Variant) (dbus.ObjectPath, error) {
	return v.StoreConnect(
		<-v.GoConnect(flags, make(chan *dbus.Call, 1), properties).Done)
}

// method Disconnect

func (v *interfaceModemSimple) GoDisconnect(flags dbus.Flags, ch chan *dbus.Call, bearer dbus.ObjectPath) *dbus.Call {
	return v.GetObject_().Go_(v.GetInterfaceName_()+".Disconnect", flags, ch, bearer)
}

func (v *interfaceModemSimple) Disconnect(flags dbus.Flags, bearer dbus.ObjectPath) error {
	return (<-v.GoDisconnect(flags, make(chan *dbus.Call, 1), bearer).Done).Err
}

// method GetStatus

func (v *interfaceModemSimple) GoGetStatus(flags dbus.Flags, ch chan *dbus.Call) *dbus.Call {
	return v.GetObject_().Go_(v.GetInterfaceName_()+".GetStatus", flags, ch)
}

func (*interfaceModemSimple) StoreGetStatus(call *dbus.Call) (properties map[string]dbus.Variant, err error) {
	err = call.Store(&properties)
	return
}

func (v *interfaceModemSimple) GetStatus(flags dbus.Flags) (map[string]dbus.Variant, error) {
	return v.StoreGetStatus(
		<-v.GoGetStatus(flags, make(chan *dbus.Call, 1)).Done)
}

func (obj *objectModem) Time() modemTime {
	return &obj.interfaceModemTime
}

type modemTime interface {
	GoGetNetworkTime(flags dbus.Flags, ch chan *dbus.Call) *dbus.Call
	GetNetworkTime(flags dbus.Flags) (string, error)
	ConnectNetworkTimeChanged(cb func(time string)) (dbusutil.SignalHandlerId, error)
	NetworkTimezone() PropMapStringVariant
}

type interfaceModemTime struct{}

func (v *interfaceModemTime) GetObject_() *proxy.ImplObject {
	return (*proxy.ImplObject)(unsafe.Pointer(v))
}

func (*interfaceModemTime) GetInterfaceName_() string {
	return "org.freedesktop.ModemManager1.Modem.Time"
}

// method GetNetworkTime

func (v *interfaceModemTime) GoGetNetworkTime(flags dbus.Flags, ch chan *dbus.Call) *dbus.Call {
	return v.GetObject_().Go_(v.GetInterfaceName_()+".GetNetworkTime", flags, ch)
}

func (*interfaceModemTime) StoreGetNetworkTime(call *dbus.Call) (time string, err error) {
	err = call.Store(&time)
	return
}

func (v *interfaceModemTime) GetNetworkTime(flags dbus.Flags) (string, error) {
	return v.StoreGetNetworkTime(
		<-v.GoGetNetworkTime(flags, make(chan *dbus.Call, 1)).Done)
}

// signal NetworkTimeChanged

func (v *interfaceModemTime) ConnectNetworkTimeChanged(cb func(time string)) (dbusutil.SignalHandlerId, error) {
	if cb == nil {
		return 0, errors.New("nil callback")
	}
	obj := v.GetObject_()
	rule := fmt.Sprintf(
		"type='signal',interface='%s',member='%s',path='%s',sender='%s'",
		v.GetInterfaceName_(), "NetworkTimeChanged", obj.Path_(), obj.ServiceName_())

	sigRule := &dbusutil.SignalRule{
		Path: obj.Path_(),
		Name: v.GetInterfaceName_() + ".NetworkTimeChanged",
	}
	handlerFunc := func(sig *dbus.Signal) {
		var time string
		err := dbus.Store(sig.Body, &time)
		if err == nil {
			cb(time)
		}
	}

	return obj.ConnectSignal_(rule, sigRule, handlerFunc)
}

// property NetworkTimezone a{sv}

func (v *interfaceModemTime) NetworkTimezone() PropMapStringVariant {
	return &implPropMapStringVariant{
		Impl: v,
		Name: "NetworkTimezone",
	}
}

func (obj *objectModem) Voice() modemVoice {
	return &obj.interfaceModemVoice
}

type modemVoice interface {
	GoListCalls(flags dbus.Flags, ch chan *dbus.Call) *dbus.Call
	ListCalls(flags dbus.Flags) ([]dbus.ObjectPath, error)
	GoDeleteCall(flags dbus.Flags, ch chan *dbus.Call, path dbus.ObjectPath) *dbus.Call
	DeleteCall(flags dbus.Flags, path dbus.ObjectPath) error
	GoCreateCall(flags dbus.Flags, ch chan *dbus.Call, properties map[string]dbus.Variant) *dbus.Call
	CreateCall(flags dbus.Flags, properties map[string]dbus.Variant) (dbus.ObjectPath, error)
	ConnectCallAdded(cb func(path dbus.ObjectPath)) (dbusutil.SignalHandlerId, error)
	ConnectCallDeleted(cb func(path dbus.ObjectPath)) (dbusutil.SignalHandlerId, error)
	Calls() proxy.PropObjectPathArray
}

type interfaceModemVoice struct{}

func (v *interfaceModemVoice) GetObject_() *proxy.ImplObject {
	return (*proxy.ImplObject)(unsafe.Pointer(v))
}

func (*interfaceModemVoice) GetInterfaceName_() string {
	return "org.freedesktop.ModemManager1.Modem.Voice"
}

// method ListCalls

func (v *interfaceModemVoice) GoListCalls(flags dbus.Flags, ch chan *dbus.Call) *dbus.Call {
	return v.GetObject_().Go_(v.GetInterfaceName_()+".ListCalls", flags, ch)
}

func (*interfaceModemVoice) StoreListCalls(call *dbus.Call) (result []dbus.ObjectPath, err error) {
	err = call.Store(&result)
	return
}

func (v *interfaceModemVoice) ListCalls(flags dbus.Flags) ([]dbus.ObjectPath, error) {
	return v.StoreListCalls(
		<-v.GoListCalls(flags, make(chan *dbus.Call, 1)).Done)
}

// method DeleteCall

func (v *interfaceModemVoice) GoDeleteCall(flags dbus.Flags, ch chan *dbus.Call, path dbus.ObjectPath) *dbus.Call {
	return v.GetObject_().Go_(v.GetInterfaceName_()+".DeleteCall", flags, ch, path)
}

func (v *interfaceModemVoice) DeleteCall(flags dbus.Flags, path dbus.ObjectPath) error {
	return (<-v.GoDeleteCall(flags, make(chan *dbus.Call, 1), path).Done).Err
}

// method CreateCall

func (v *interfaceModemVoice) GoCreateCall(flags dbus.Flags, ch chan *dbus.Call, properties map[string]dbus.Variant) *dbus.Call {
	return v.GetObject_().Go_(v.GetInterfaceName_()+".CreateCall", flags, ch, properties)
}

func (*interfaceModemVoice) StoreCreateCall(call *dbus.Call) (path dbus.ObjectPath, err error) {
	err = call.Store(&path)
	return
}

func (v *interfaceModemVoice) CreateCall(flags dbus.Flags, properties map[string]dbus.Variant) (dbus.ObjectPath, error) {
	return v.StoreCreateCall(
		<-v.GoCreateCall(flags, make(chan *dbus.Call, 1), properties).Done)
}

// signal CallAdded

func (v *interfaceModemVoice) ConnectCallAdded(cb func(path dbus.ObjectPath)) (dbusutil.SignalHandlerId, error) {
	if cb == nil {
		return 0, errors.New("nil callback")
	}
	obj := v.GetObject_()
	rule := fmt.Sprintf(
		"type='signal',interface='%s',member='%s',path='%s',sender='%s'",
		v.GetInterfaceName_(), "CallAdded", obj.Path_(), obj.ServiceName_())

	sigRule := &dbusutil.SignalRule{
		Path: obj.Path_(),
		Name: v.GetInterfaceName_() + ".CallAdded",
	}
	handlerFunc := func(sig *dbus.Signal) {
		var path dbus.ObjectPath
		err := dbus.Store(sig.Body, &path)
		if err == nil {
			cb(path)
		}
	}

	return obj.ConnectSignal_(rule, sigRule, handlerFunc)
}

// signal CallDeleted

func (v *interfaceModemVoice) ConnectCallDeleted(cb func(path dbus.ObjectPath)) (dbusutil.SignalHandlerId, error) {
	if cb == nil {
		return 0, errors.New("nil callback")
	}
	obj := v.GetObject_()
	rule := fmt.Sprintf(
		"type='signal',interface='%s',member='%s',path='%s',sender='%s'",
		v.GetInterfaceName_(), "CallDeleted", obj.Path_(), obj.ServiceName_())

	sigRule := &dbusutil.SignalRule{
		Path: obj.Path_(),
		Name: v.GetInterfaceName_() + ".CallDeleted",
	}
	handlerFunc := func(sig *dbus.Signal) {
		var path dbus.ObjectPath
		err := dbus.Store(sig.Body, &path)
		if err == nil {
			cb(path)
		}
	}

	return obj.ConnectSignal_(rule, sigRule, handlerFunc)
}

// property Calls ao

func (v *interfaceModemVoice) Calls() proxy.PropObjectPathArray {
	return &proxy.ImplPropObjectPathArray{
		Impl: v,
		Name: "Calls",
	}
}

type PropMapStringVariant interface {
	Get(flags dbus.Flags) (value map[string]dbus.Variant, err error)
	Set(flags dbus.Flags, value map[string]dbus.Variant) error
	ConnectChanged(cb func(hasValue bool, value map[string]dbus.Variant)) error
}

type implPropMapStringVariant struct {
	Impl proxy.Implementer
	Name string
}

func (p implPropMapStringVariant) Get(flags dbus.Flags) (value map[string]dbus.Variant, err error) {
	err = p.Impl.GetObject_().GetProperty_(flags, p.Impl.GetInterfaceName_(),
		p.Name, &value)
	return
}

func (p implPropMapStringVariant) Set(flags dbus.Flags, value map[string]dbus.Variant) error {
	return p.Impl.GetObject_().SetProperty_(flags, p.Impl.GetInterfaceName_(), p.Name, value)
}

func (p implPropMapStringVariant) ConnectChanged(cb func(hasValue bool, value map[string]dbus.Variant)) error {
	if cb == nil {
		return errors.New("nil callback")
	}
	cb0 := func(hasValue bool, value interface{}) {
		if hasValue {
			var v map[string]dbus.Variant
			err := dbus.Store([]interface{}{value}, &v)
			if err != nil {
				return
			}
			cb(true, v)
		} else {
			cb(false, nil)
		}
	}
	return p.Impl.GetObject_().ConnectPropertyChanged_(p.Impl.GetInterfaceName_(),
		p.Name, cb0)
}
