// Code generated by "./generator ./system/org.deepin.dde.apps1"; DO NOT EDIT.

// SPDX-FileCopyrightText: 2018 - 2023 UnionTech Software Technology Co., Ltd.
//
// SPDX-License-Identifier: GPL-3.0-or-later
package apps1

import (
	"errors"
	"fmt"
	"unsafe"

	"github.com/godbus/dbus/v5"
	"github.com/linuxdeepin/go-lib/dbusutil"
	"github.com/linuxdeepin/go-lib/dbusutil/proxy"
)

type Apps interface {
	DesktopFileWatcher() desktopFileWatcher // interface org.deepin.dde.Apps1.DesktopFileWatcher
	LaunchedRecorder() launchedRecorder     // interface org.deepin.dde.Apps1.LaunchedRecorder
	proxy.Object
}

type objectApps struct {
	interfaceDesktopFileWatcher // interface org.deepin.dde.Apps1.DesktopFileWatcher
	interfaceLaunchedRecorder   // interface org.deepin.dde.Apps1.LaunchedRecorder
	proxy.ImplObject
}

func NewApps(conn *dbus.Conn) Apps {
	obj := new(objectApps)
	obj.ImplObject.Init_(conn, "org.deepin.dde.Apps1", "/org/deepin/dde/Apps1")
	return obj
}

func (obj *objectApps) DesktopFileWatcher() desktopFileWatcher {
	return &obj.interfaceDesktopFileWatcher
}

type desktopFileWatcher interface {
	ConnectEvent(cb func(name string, op uint32)) (dbusutil.SignalHandlerId, error)
}

type interfaceDesktopFileWatcher struct{}

func (v *interfaceDesktopFileWatcher) GetObject_() *proxy.ImplObject {
	return (*proxy.ImplObject)(unsafe.Pointer(v))
}

func (*interfaceDesktopFileWatcher) GetInterfaceName_() string {
	return "org.deepin.dde.Apps1.DesktopFileWatcher"
}

// signal Event

func (v *interfaceDesktopFileWatcher) ConnectEvent(cb func(name string, op uint32)) (dbusutil.SignalHandlerId, error) {
	if cb == nil {
		return 0, errors.New("nil callback")
	}
	obj := v.GetObject_()
	rule := fmt.Sprintf(
		"type='signal',interface='%s',member='%s',path='%s',sender='%s'",
		v.GetInterfaceName_(), "Event", obj.Path_(), obj.ServiceName_())

	sigRule := &dbusutil.SignalRule{
		Path: obj.Path_(),
		Name: v.GetInterfaceName_() + ".Event",
	}
	handlerFunc := func(sig *dbus.Signal) {
		var name string
		var op uint32
		err := dbus.Store(sig.Body, &name, &op)
		if err == nil {
			cb(name, op)
		}
	}

	return obj.ConnectSignal_(rule, sigRule, handlerFunc)
}

func (obj *objectApps) LaunchedRecorder() launchedRecorder {
	return &obj.interfaceLaunchedRecorder
}

type launchedRecorder interface {
	GoGetNew(flags dbus.Flags, ch chan *dbus.Call) *dbus.Call
	GetNew(flags dbus.Flags) (map[string][]string, error)
	GoMarkLaunched(flags dbus.Flags, ch chan *dbus.Call, desktopFile string) *dbus.Call
	MarkLaunched(flags dbus.Flags, desktopFile string) error
	GoUninstallHints(flags dbus.Flags, ch chan *dbus.Call, desktopFiles []string) *dbus.Call
	UninstallHints(flags dbus.Flags, desktopFiles []string) error
	GoWatchDirs(flags dbus.Flags, ch chan *dbus.Call, dirs []string) *dbus.Call
	WatchDirs(flags dbus.Flags, dirs []string) error
	ConnectLaunched(cb func(file string)) (dbusutil.SignalHandlerId, error)
	ConnectStatusSaved(cb func(root string, file string, ok bool)) (dbusutil.SignalHandlerId, error)
	ConnectServiceRestarted(cb func()) (dbusutil.SignalHandlerId, error)
}

type interfaceLaunchedRecorder struct{}

func (v *interfaceLaunchedRecorder) GetObject_() *proxy.ImplObject {
	return (*proxy.ImplObject)(unsafe.Pointer(v))
}

func (*interfaceLaunchedRecorder) GetInterfaceName_() string {
	return "org.deepin.dde.Apps1.LaunchedRecorder"
}

// method GetNew

func (v *interfaceLaunchedRecorder) GoGetNew(flags dbus.Flags, ch chan *dbus.Call) *dbus.Call {
	return v.GetObject_().Go_(v.GetInterfaceName_()+".GetNew", flags, ch)
}

func (*interfaceLaunchedRecorder) StoreGetNew(call *dbus.Call) (newApps map[string][]string, err error) {
	err = call.Store(&newApps)
	return
}

func (v *interfaceLaunchedRecorder) GetNew(flags dbus.Flags) (map[string][]string, error) {
	return v.StoreGetNew(
		<-v.GoGetNew(flags, make(chan *dbus.Call, 1)).Done)
}

// method MarkLaunched

func (v *interfaceLaunchedRecorder) GoMarkLaunched(flags dbus.Flags, ch chan *dbus.Call, desktopFile string) *dbus.Call {
	return v.GetObject_().Go_(v.GetInterfaceName_()+".MarkLaunched", flags, ch, desktopFile)
}

func (v *interfaceLaunchedRecorder) MarkLaunched(flags dbus.Flags, desktopFile string) error {
	return (<-v.GoMarkLaunched(flags, make(chan *dbus.Call, 1), desktopFile).Done).Err
}

// method UninstallHints

func (v *interfaceLaunchedRecorder) GoUninstallHints(flags dbus.Flags, ch chan *dbus.Call, desktopFiles []string) *dbus.Call {
	return v.GetObject_().Go_(v.GetInterfaceName_()+".UninstallHints", flags, ch, desktopFiles)
}

func (v *interfaceLaunchedRecorder) UninstallHints(flags dbus.Flags, desktopFiles []string) error {
	return (<-v.GoUninstallHints(flags, make(chan *dbus.Call, 1), desktopFiles).Done).Err
}

// method WatchDirs

func (v *interfaceLaunchedRecorder) GoWatchDirs(flags dbus.Flags, ch chan *dbus.Call, dirs []string) *dbus.Call {
	return v.GetObject_().Go_(v.GetInterfaceName_()+".WatchDirs", flags, ch, dirs)
}

func (v *interfaceLaunchedRecorder) WatchDirs(flags dbus.Flags, dirs []string) error {
	return (<-v.GoWatchDirs(flags, make(chan *dbus.Call, 1), dirs).Done).Err
}

// signal Launched

func (v *interfaceLaunchedRecorder) ConnectLaunched(cb func(file string)) (dbusutil.SignalHandlerId, error) {
	if cb == nil {
		return 0, errors.New("nil callback")
	}
	obj := v.GetObject_()
	rule := fmt.Sprintf(
		"type='signal',interface='%s',member='%s',path='%s',sender='%s'",
		v.GetInterfaceName_(), "Launched", obj.Path_(), obj.ServiceName_())

	sigRule := &dbusutil.SignalRule{
		Path: obj.Path_(),
		Name: v.GetInterfaceName_() + ".Launched",
	}
	handlerFunc := func(sig *dbus.Signal) {
		var file string
		err := dbus.Store(sig.Body, &file)
		if err == nil {
			cb(file)
		}
	}

	return obj.ConnectSignal_(rule, sigRule, handlerFunc)
}

// signal StatusSaved

func (v *interfaceLaunchedRecorder) ConnectStatusSaved(cb func(root string, file string, ok bool)) (dbusutil.SignalHandlerId, error) {
	if cb == nil {
		return 0, errors.New("nil callback")
	}
	obj := v.GetObject_()
	rule := fmt.Sprintf(
		"type='signal',interface='%s',member='%s',path='%s',sender='%s'",
		v.GetInterfaceName_(), "StatusSaved", obj.Path_(), obj.ServiceName_())

	sigRule := &dbusutil.SignalRule{
		Path: obj.Path_(),
		Name: v.GetInterfaceName_() + ".StatusSaved",
	}
	handlerFunc := func(sig *dbus.Signal) {
		var root string
		var file string
		var ok bool
		err := dbus.Store(sig.Body, &root, &file, &ok)
		if err == nil {
			cb(root, file, ok)
		}
	}

	return obj.ConnectSignal_(rule, sigRule, handlerFunc)
}

// signal ServiceRestarted

func (v *interfaceLaunchedRecorder) ConnectServiceRestarted(cb func()) (dbusutil.SignalHandlerId, error) {
	if cb == nil {
		return 0, errors.New("nil callback")
	}
	obj := v.GetObject_()
	rule := fmt.Sprintf(
		"type='signal',interface='%s',member='%s',path='%s',sender='%s'",
		v.GetInterfaceName_(), "ServiceRestarted", obj.Path_(), obj.ServiceName_())

	sigRule := &dbusutil.SignalRule{
		Path: obj.Path_(),
		Name: v.GetInterfaceName_() + ".ServiceRestarted",
	}
	handlerFunc := func(sig *dbus.Signal) {
		cb()
	}

	return obj.ConnectSignal_(rule, sigRule, handlerFunc)
}
