//
// Created by uos on 2022/6/14.
//

#ifndef UOS_RECOVERY_DBINTERFACE_H
#define UOS_RECOVERY_DBINTERFACE_H

#include "utils/global.h"
#include "utils/Singleton.h"
#include <QObject>
#include <DSingleton>
#include <QtSql/QSqlDatabase>

DTK_USE_NAMESPACE
DCORE_USE_NAMESPACE

class DBInterface : public QObject, public URS::Singleton<DBInterface>
{
public:
    ~DBInterface();
    void initDataBase();
    void addOperateLog(const OperateLog &operateLog);
    OperateLogList queryOperateLog(const OperateLogQuery &query);

    void addGhostLog(const GhostLog &log);
    GhostLogList queryGhostLog(const GhostLogQuery &query);
    int deleteGhostLog(const GhostLog &log);

    //判断mask的第i位是否为1
    bool checkMask(int mask, quint32 i);
private:
    QSqlDatabase m_db;
};


#endif //UOS_RECOVERY_DBINTERFACE_H
