//
// Created by 张雪明 <zhangxueming@uniontech.com> on 2023/11/7.
//

#ifndef UOS_RECOVERY_DATA_BACKUP_WIDGET_H
#define UOS_RECOVERY_DATA_BACKUP_WIDGET_H

#include <DWidget>
#include <DLabel>
#include <DLineEdit>
#include <DComboBox>
#include <DPushButton>
#include <DSuggestButton>
#include <DSpinner>
#include <DIconButton>
#include <QVBoxLayout>
#include <QStandardItemModel>
#include <QMap>
#include <QPair>
#include <QList>
#include <QStringList>
#include "common/BaseTableView.h"
#include "utils/global.h"
#include "utils/FsTab.h"

DTK_USE_NAMESPACE
DWIDGET_USE_NAMESPACE

class BackupPathDeleteWidget : public QWidget {
    Q_OBJECT
public:
    //static bool m_isRemoving;
    explicit BackupPathDeleteWidget(QWidget *parent = nullptr);
    void setBackupPathInfo(const QString &opID, const QString &path);
    void setDeleteBtnVisible(bool visible);
    void setSpinnerVisible(bool visible);
    void stopSpinner();

Q_SIGNALS:
    void deleteBackupPathClicked(const QString &opID);
public Q_SLOTS:
    void onDelete();
private:
    DPushButton *m_deleteBtn = nullptr;
    DSpinner *m_spinner = nullptr;
    QPair<QString, QString> m_opIDPath;
};

class DataBackupWidget : public DWidget {
    Q_OBJECT
public:
    explicit DataBackupWidget(DWidget *parent = nullptr);
    void initUI();
    void initLayout();
    void initTableView();
    void setDestDevice(const QJsonObject &jsonObject);
    QString getDestDeviceUUID();
    QStringList getBackupFiles();
    void setTips(const QString &tips);
    void setTipsStyleSheet(const QString &styleSheet);
    void startSpinner();
    void stopSpinner();
    void setButtonEnable(bool enable);
    QString getNote();
    void resetWidget();
    void setAddIconBtnEnable(bool enable);
    QString getDirBindPath(const QString &path);

Q_SIGNALS:
    void cancel();
    void start(const QString &remark);

private Q_SLOTS:
    void onAddBtnClicked(bool clicked);
    void onDeleteBackupPathClicked(const QString &opID);
    void onStartBackup();
    void onNoteTextChanged();
    void onBackDirFontChanged(const QFont &font);

private:
    int getComboWidth(const QFont &font);

private:
    DLabel *m_title = nullptr;
    DLabel *m_backupDirTitle = nullptr;
    DIconButton *m_addIconBtn = nullptr;
//    DIconButton *m_deleteIconBtn = nullptr;
    BaseTableView *m_tableView = nullptr;
    QStandardItemModel *m_model = nullptr;
    DLabel *m_backupDir = nullptr;
    DComboBox *m_comboBox;
    DLabel *m_noteLabel = nullptr;
    DLineEdit *m_noteEdit = nullptr;
    DSpinner *m_spinner = nullptr;
    DLabel *m_tips = nullptr;
    DPushButton *m_cancelBtn = nullptr;
    DSuggestButton *m_startBtn = nullptr;
    QVBoxLayout *m_mainVLayout = nullptr;
    QList<Partition> m_partitionList;
    FSTabInfoList m_fstabInfos;
    QMap<QString, QString> m_bindDirMap;
    bool m_isImmutable = false;
};

#endif //UOS_RECOVERY_DATA_BACKUP_WIDGET_H
